/*
 * Decompiled with CFR 0.152.
 */
package com.pierfrancescosoffritti.androidyoutubeplayer.core.player.views;

import android.os.Handler;
import android.os.Looper;
import android.webkit.WebView;
import com.pierfrancescosoffritti.androidyoutubeplayer.core.player.BooleanProvider;
import com.pierfrancescosoffritti.androidyoutubeplayer.core.player.PlayerConstants;
import com.pierfrancescosoffritti.androidyoutubeplayer.core.player.PlayerConstantsKt;
import com.pierfrancescosoffritti.androidyoutubeplayer.core.player.YouTubePlayer;
import com.pierfrancescosoffritti.androidyoutubeplayer.core.player.YouTubePlayerCallbacks;
import com.pierfrancescosoffritti.androidyoutubeplayer.core.player.listeners.YouTubePlayerListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\tH\u0016J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0018\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u001b\u001a\u00020\u0012H\u0016J\b\u0010\u001c\u001a\u00020\u0012H\u0016J\b\u0010\u001d\u001a\u00020\u0012H\u0016J\b\u0010\u001e\u001a\u00020\u0012H\u0016J\u0010\u0010\u001f\u001a\u00020\u00122\u0006\u0010 \u001a\u00020!H\u0016J\b\u0010\"\u001a\u00020\u0012H\u0016J\u0006\u0010#\u001a\u00020\u0012J\u0010\u0010$\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\tH\u0016J\u0010\u0010%\u001a\u00020\u00122\u0006\u0010&\u001a\u00020\u0016H\u0016J\u0010\u0010'\u001a\u00020\u00122\u0006\u0010(\u001a\u00020\u000fH\u0016J\u0010\u0010)\u001a\u00020\u00122\u0006\u0010*\u001a\u00020+H\u0016J\u0010\u0010,\u001a\u00020\u00122\u0006\u0010-\u001a\u00020\u000fH\u0016J\u0010\u0010.\u001a\u00020\u00122\u0006\u0010/\u001a\u00020!H\u0016J\b\u00100\u001a\u00020\u0012H\u0016J\b\u00101\u001a\u00020\u0012H\u0016J-\u00102\u001a\u00020\u0012*\u00020\u00032\u0006\u00103\u001a\u00020\u00142\u0012\u00104\u001a\n\u0012\u0006\b\u0001\u0012\u00020605\"\u000206H\u0002\u00a2\u0006\u0002\u00107R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00068"}, d2={"Lcom/pierfrancescosoffritti/androidyoutubeplayer/core/player/views/YouTubePlayerImpl;", "Lcom/pierfrancescosoffritti/androidyoutubeplayer/core/player/YouTubePlayer;", "webView", "Landroid/webkit/WebView;", "callbacks", "Lcom/pierfrancescosoffritti/androidyoutubeplayer/core/player/YouTubePlayerCallbacks;", "(Landroid/webkit/WebView;Lcom/pierfrancescosoffritti/androidyoutubeplayer/core/player/YouTubePlayerCallbacks;)V", "listeners", "", "Lcom/pierfrancescosoffritti/androidyoutubeplayer/core/player/listeners/YouTubePlayerListener;", "getListeners", "()Ljava/util/Set;", "mainThread", "Landroid/os/Handler;", "addListener", "", "listener", "cueVideo", "", "videoId", "", "startSeconds", "", "isMutedAsync", "callback", "Lcom/pierfrancescosoffritti/androidyoutubeplayer/core/player/BooleanProvider;", "loadVideo", "mute", "nextVideo", "pause", "play", "playVideoAt", "index", "", "previousVideo", "release", "removeListener", "seekTo", "time", "setLoop", "loop", "setPlaybackRate", "playbackRate", "Lcom/pierfrancescosoffritti/androidyoutubeplayer/core/player/PlayerConstants$PlaybackRate;", "setShuffle", "shuffle", "setVolume", "volumePercent", "toggleFullscreen", "unMute", "invoke", "function", "args", "", "", "(Landroid/webkit/WebView;Ljava/lang/String;[Ljava/lang/Object;)V", "core_release"})
@SourceDebugExtension(value={"SMAP\nWebViewYouTubePlayer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WebViewYouTubePlayer.kt\ncom/pierfrancescosoffritti/androidyoutubeplayer/core/player/views/YouTubePlayerImpl\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,182:1\n1#2:183\n11335#3:184\n11670#3,3:185\n*S KotlinDebug\n*F\n+ 1 WebViewYouTubePlayer.kt\ncom/pierfrancescosoffritti/androidyoutubeplayer/core/player/views/YouTubePlayerImpl\n*L\n68#1:184\n68#1:185,3\n*E\n"})
final class YouTubePlayerImpl
implements YouTubePlayer {
    @NotNull
    private final WebView webView;
    @NotNull
    private final YouTubePlayerCallbacks callbacks;
    @NotNull
    private final Handler mainThread;
    @NotNull
    private final Set<YouTubePlayerListener> listeners;

    public YouTubePlayerImpl(@NotNull WebView webView, @NotNull YouTubePlayerCallbacks callbacks) {
        Intrinsics.checkNotNullParameter((Object)webView, (String)"webView");
        Intrinsics.checkNotNullParameter((Object)callbacks, (String)"callbacks");
        this.webView = webView;
        this.callbacks = callbacks;
        this.mainThread = new Handler(Looper.getMainLooper());
        this.listeners = new LinkedHashSet();
    }

    @NotNull
    public final Set<YouTubePlayerListener> getListeners() {
        return this.listeners;
    }

    @Override
    public void loadVideo(@NotNull String videoId, float startSeconds) {
        Intrinsics.checkNotNullParameter((Object)videoId, (String)"videoId");
        Object[] objectArray = new Object[]{videoId, Float.valueOf(startSeconds)};
        this.invoke(this.webView, "loadVideo", objectArray);
    }

    @Override
    public void cueVideo(@NotNull String videoId, float startSeconds) {
        Intrinsics.checkNotNullParameter((Object)videoId, (String)"videoId");
        Object[] objectArray = new Object[]{videoId, Float.valueOf(startSeconds)};
        this.invoke(this.webView, "cueVideo", objectArray);
    }

    @Override
    public void play() {
        this.invoke(this.webView, "playVideo", new Object[0]);
    }

    @Override
    public void pause() {
        this.invoke(this.webView, "pauseVideo", new Object[0]);
    }

    @Override
    public void nextVideo() {
        this.invoke(this.webView, "nextVideo", new Object[0]);
    }

    @Override
    public void previousVideo() {
        this.invoke(this.webView, "previousVideo", new Object[0]);
    }

    @Override
    public void playVideoAt(int index) {
        Object[] objectArray = new Object[]{index};
        this.invoke(this.webView, "playVideoAt", objectArray);
    }

    @Override
    public void setLoop(boolean loop) {
        Object[] objectArray = new Object[]{loop};
        this.invoke(this.webView, "setLoop", objectArray);
    }

    @Override
    public void setShuffle(boolean shuffle) {
        Object[] objectArray = new Object[]{shuffle};
        this.invoke(this.webView, "setShuffle", objectArray);
    }

    @Override
    public void mute() {
        this.invoke(this.webView, "mute", new Object[0]);
    }

    @Override
    public void unMute() {
        this.invoke(this.webView, "unMute", new Object[0]);
    }

    @Override
    public void isMutedAsync(@NotNull BooleanProvider callback2) {
        Intrinsics.checkNotNullParameter((Object)callback2, (String)"callback");
        long requestId = this.callbacks.registerBooleanCallback(callback2);
        Object[] objectArray = new Object[]{requestId};
        this.invoke(this.webView, "getMuteValue", objectArray);
    }

    @Override
    public void setVolume(int volumePercent) {
        if (!(0 <= volumePercent ? volumePercent < 101 : false)) {
            boolean bl = false;
            String string = "Volume must be between 0 and 100";
            throw new IllegalArgumentException(string.toString());
        }
        Object[] objectArray = new Object[]{volumePercent};
        this.invoke(this.webView, "setVolume", objectArray);
    }

    @Override
    public void seekTo(float time) {
        Object[] objectArray = new Object[]{Float.valueOf(time)};
        this.invoke(this.webView, "seekTo", objectArray);
    }

    @Override
    public void setPlaybackRate(@NotNull PlayerConstants.PlaybackRate playbackRate) {
        Intrinsics.checkNotNullParameter((Object)((Object)playbackRate), (String)"playbackRate");
        Object[] objectArray = new Object[]{Float.valueOf(PlayerConstantsKt.toFloat(playbackRate))};
        this.invoke(this.webView, "setPlaybackRate", objectArray);
    }

    @Override
    public void toggleFullscreen() {
        this.invoke(this.webView, "toggleFullscreen", new Object[0]);
    }

    @Override
    public boolean addListener(@NotNull YouTubePlayerListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        return this.listeners.add(listener);
    }

    @Override
    public boolean removeListener(@NotNull YouTubePlayerListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        return this.listeners.remove(listener);
    }

    public final void release() {
        this.listeners.clear();
        this.mainThread.removeCallbacksAndMessages(null);
    }

    /*
     * WARNING - void declaration
     */
    private final void invoke(WebView $this$invoke, String function, Object ... args) {
        void $this$mapTo$iv$iv;
        Object[] $this$map$iv = args;
        boolean $i$f$map = false;
        Object[] objectArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        int n = ((void)$this$mapTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void it;
            void item$iv$iv;
            void var13_12 = item$iv$iv = $this$mapTo$iv$iv[i];
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it instanceof String ? "" + '\'' + it + '\'' : it.toString());
        }
        List stringArgs = (List)destination$iv$iv;
        this.mainThread.post(() -> YouTubePlayerImpl.invoke$lambda$2($this$invoke, function, stringArgs));
    }

    private static final void invoke$lambda$2(WebView $this_invoke, String $function, List $stringArgs) {
        Intrinsics.checkNotNullParameter((Object)$this_invoke, (String)"$this_invoke");
        Intrinsics.checkNotNullParameter((Object)$function, (String)"$function");
        Intrinsics.checkNotNullParameter((Object)$stringArgs, (String)"$stringArgs");
        $this_invoke.loadUrl("javascript:" + $function + '(' + CollectionsKt.joinToString$default((Iterable)$stringArgs, (CharSequence)",", null, null, (int)0, null, null, (int)62, null) + ')');
    }
}

