/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.platform;

import com.pi4j.common.Describable;
import com.pi4j.common.Descriptor;
import com.pi4j.platform.Platform;
import com.pi4j.platform.exception.PlatformException;
import com.pi4j.platform.exception.PlatformNotFoundException;
import com.pi4j.platform.exception.PlatformTypeException;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public interface Platforms
extends Describable {
    public Map<String, Platform> all();

    public boolean exists(String var1);

    public Platform get(String var1) throws PlatformNotFoundException;

    public <T extends Platform> T defaultPlatform();

    default public <T extends Platform> boolean exists(String platformId, Class<T> platformClass) throws PlatformNotFoundException {
        try {
            return this.get(platformId, platformClass) != null;
        }
        catch (PlatformException e) {
            return false;
        }
    }

    default public boolean hasDefault() {
        return this.defaultPlatform() != null;
    }

    default public <T extends Platform> T getDefault() {
        return this.defaultPlatform();
    }

    default public <T extends Platform> T get(String platformId, Class<T> platformClass) throws PlatformNotFoundException, PlatformTypeException {
        Platform platform = this.get(platformId);
        if (platformClass == null) {
            return (T)platform;
        }
        if (platformClass.isAssignableFrom(platform.getClass())) {
            return (T)platform;
        }
        throw new PlatformTypeException(platformId, platformClass);
    }

    default public boolean exists(Class<? extends Platform> platformClass) throws PlatformNotFoundException {
        try {
            return this.get(platformClass) != null;
        }
        catch (PlatformException e) {
            return false;
        }
    }

    default public <T extends Platform> T get(Class<T> platformClass) throws PlatformNotFoundException {
        Map<String, T> subset = this.all(platformClass);
        if (subset.isEmpty()) {
            throw new PlatformNotFoundException(platformClass);
        }
        return (T)((Platform)subset.values().iterator().next());
    }

    default public <T extends Platform> Map<String, T> all(Class<T> platformClass) throws PlatformNotFoundException {
        ConcurrentHashMap result = new ConcurrentHashMap();
        this.all().values().stream().filter(platformClass::isInstance).forEach(p -> result.put(p.id(), (Platform)platformClass.cast(p)));
        if (result.size() <= 0) {
            throw new PlatformNotFoundException(platformClass);
        }
        return Collections.unmodifiableMap(result);
    }

    default public Map<String, Platform> getAll() {
        return this.all();
    }

    default public <T extends Platform> Map<String, T> getAll(Class<T> platformClass) throws PlatformNotFoundException {
        return this.all(platformClass);
    }

    @Override
    default public Descriptor describe() {
        Map<String, Platform> platforms = this.all();
        Descriptor descriptor = Descriptor.create().category("PLATFORMS").name("Pi4J Runtime Platforms").quantity(platforms == null ? 0 : platforms.size()).type(this.getClass());
        if (platforms != null && !platforms.isEmpty()) {
            platforms.forEach((id, platform) -> descriptor.add(platform.describe()));
        }
        return descriptor;
    }
}

