/*
 * Decompiled with CFR 0.152.
 */
package com.permissionx.guolindev.request;

import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.net.Uri;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentManager;
import android.text.TextUtils;
import com.permissionx.guolindev.callback.ExplainReasonCallback;
import com.permissionx.guolindev.callback.ExplainReasonCallbackWithBeforeParam;
import com.permissionx.guolindev.callback.ForwardToSettingsCallback;
import com.permissionx.guolindev.callback.RequestCallback;
import com.permissionx.guolindev.request.ChainTask;
import com.permissionx.guolindev.request.InvisibleFragment;
import com.permissionx.guolindev.request.RequestBackgroundLocationPermission;
import com.permissionx.guolindev.request.RequestChain;
import com.permissionx.guolindev.request.RequestNormalPermissions;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class PermissionBuilder {
    private static final String FRAGMENT_TAG = "InvisibleFragment";
    FragmentActivity activity;
    Set<String> normalPermissions;
    Set<String> permissionsWontRequest;
    boolean requireBackgroundLocationPermission;
    boolean explainReasonBeforeRequest = false;
    boolean showDialogCalled = false;
    Set<String> grantedPermissions = new HashSet<String>();
    Set<String> deniedPermissions = new HashSet<String>();
    Set<String> permanentDeniedPermissions = new HashSet<String>();
    Set<String> forwardPermissions = new HashSet<String>();
    RequestCallback requestCallback;
    ExplainReasonCallback explainReasonCallback;
    ExplainReasonCallbackWithBeforeParam explainReasonCallbackWithBeforeParam;
    ForwardToSettingsCallback forwardToSettingsCallback;

    public PermissionBuilder(FragmentActivity activity, Set<String> normalPermissions, boolean requireBackgroundLocationPermission, Set<String> permissionsWontRequest) {
        this.activity = activity;
        this.normalPermissions = normalPermissions;
        this.requireBackgroundLocationPermission = requireBackgroundLocationPermission;
        this.permissionsWontRequest = permissionsWontRequest;
    }

    public PermissionBuilder onExplainRequestReason(ExplainReasonCallback callback) {
        this.explainReasonCallback = callback;
        return this;
    }

    public PermissionBuilder onExplainRequestReason(ExplainReasonCallbackWithBeforeParam callback) {
        this.explainReasonCallbackWithBeforeParam = callback;
        return this;
    }

    public PermissionBuilder onForwardToSettings(ForwardToSettingsCallback callback) {
        this.forwardToSettingsCallback = callback;
        return this;
    }

    public PermissionBuilder explainReasonBeforeRequest() {
        this.explainReasonBeforeRequest = true;
        return this;
    }

    public void request(RequestCallback callback) {
        this.requestCallback = callback;
        RequestChain requestChain = new RequestChain();
        requestChain.addTaskToChain(new RequestNormalPermissions(this));
        requestChain.addTaskToChain(new RequestBackgroundLocationPermission(this));
        requestChain.runTask();
    }

    void showHandlePermissionDialog(final ChainTask chainTask, final boolean showReasonOrGoSettings, final List<String> permissions, String message, String positiveText, String negativeText) {
        this.showDialogCalled = true;
        if (permissions == null || permissions.isEmpty()) {
            chainTask.finish();
            return;
        }
        AlertDialog.Builder builder = new AlertDialog.Builder((Context)this.activity);
        builder.setMessage((CharSequence)message);
        builder.setCancelable(!TextUtils.isEmpty((CharSequence)negativeText));
        builder.setPositiveButton((CharSequence)positiveText, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                if (showReasonOrGoSettings) {
                    chainTask.requestAgain(permissions);
                } else {
                    PermissionBuilder.this.forwardToSettings(permissions);
                }
            }
        });
        if (!TextUtils.isEmpty((CharSequence)negativeText)) {
            builder.setNegativeButton((CharSequence)negativeText, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    chainTask.finish();
                }
            });
        }
        AlertDialog dialog = builder.create();
        dialog.setCanceledOnTouchOutside(false);
        dialog.show();
    }

    void requestNow(Set<String> permissions, ChainTask chainTask) {
        this.getInvisibleFragment().requestNow(this, permissions, chainTask);
    }

    void requestAccessBackgroundLocationNow(ChainTask chainTask) {
        this.getInvisibleFragment().requestAccessBackgroundLocationNow(this, chainTask);
    }

    private InvisibleFragment getInvisibleFragment() {
        FragmentManager fragmentManager = this.activity.getSupportFragmentManager();
        Fragment existedFragment = fragmentManager.findFragmentByTag(FRAGMENT_TAG);
        if (existedFragment != null) {
            return (InvisibleFragment)existedFragment;
        }
        InvisibleFragment invisibleFragment = new InvisibleFragment();
        fragmentManager.beginTransaction().add((Fragment)invisibleFragment, FRAGMENT_TAG).commitNow();
        return invisibleFragment;
    }

    private void forwardToSettings(List<String> permissions) {
        this.forwardPermissions.clear();
        this.forwardPermissions.addAll(permissions);
        Intent intent = new Intent("android.settings.APPLICATION_DETAILS_SETTINGS");
        Uri uri = Uri.fromParts((String)"package", (String)this.activity.getPackageName(), null);
        intent.setData(uri);
        this.getInvisibleFragment().startActivityForResult(intent, 2);
    }
}

