/*
 * Decompiled with CFR 0.152.
 */
package com.permissionx.guolindev.request;

import android.content.Intent;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.util.Log;
import com.permissionx.guolindev.PermissionX;
import com.permissionx.guolindev.request.ChainTask;
import com.permissionx.guolindev.request.PermissionBuilder;
import java.util.ArrayList;
import java.util.Set;

public class InvisibleFragment
extends Fragment {
    public static final int REQUEST_NORMAL_PERMISSIONS = 1;
    public static final int REQUEST_BACKGROUND_LOCATION_PERMISSION = 2;
    public static final int FORWARD_TO_SETTINGS = 2;
    private PermissionBuilder pb;
    private ChainTask task;

    void requestNow(PermissionBuilder permissionBuilder, Set<String> permissions, ChainTask chainTask) {
        this.pb = permissionBuilder;
        this.task = chainTask;
        this.requestPermissions(permissions.toArray(new String[0]), 1);
    }

    void requestAccessBackgroundLocationNow(PermissionBuilder permissionBuilder, ChainTask chainTask) {
        this.pb = permissionBuilder;
        this.task = chainTask;
        this.requestPermissions(new String[]{"android.permission.ACCESS_BACKGROUND_LOCATION"}, 2);
    }

    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        if (requestCode == 1) {
            this.onRequestNormalPermissionsResult(permissions, grantResults);
        } else if (requestCode == 2) {
            this.onRequestBackgroundLocationPermissionResult();
        }
    }

    public void onActivityResult(int requestCode, int resultCode, @Nullable Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (requestCode == 2) {
            if (this.task != null && this.pb != null) {
                this.task.requestAgain(new ArrayList<String>(this.pb.forwardPermissions));
            } else {
                Log.w((String)"PermissionX", (String)"permissionBuilder should not be null at this time, so we can do nothing in this case.");
            }
        }
    }

    private void onRequestNormalPermissionsResult(@NonNull String[] permissions, @NonNull int[] grantResults) {
        boolean allGranted;
        this.pb.grantedPermissions.clear();
        ArrayList<String> showReasonList = new ArrayList<String>();
        ArrayList<String> forwardList = new ArrayList<String>();
        for (int i = 0; i < permissions.length; ++i) {
            String permission = permissions[i];
            if (grantResults[i] == 0) {
                this.pb.grantedPermissions.add(permission);
                this.pb.deniedPermissions.remove(permission);
                this.pb.permanentDeniedPermissions.remove(permission);
                continue;
            }
            boolean shouldShowRationale = this.shouldShowRequestPermissionRationale(permission);
            if (shouldShowRationale) {
                showReasonList.add(permissions[i]);
                this.pb.deniedPermissions.add(permission);
                continue;
            }
            forwardList.add(permissions[i]);
            this.pb.permanentDeniedPermissions.add(permission);
            this.pb.deniedPermissions.remove(permission);
        }
        ArrayList<String> deniedPermissions = new ArrayList<String>();
        deniedPermissions.addAll(this.pb.deniedPermissions);
        deniedPermissions.addAll(this.pb.permanentDeniedPermissions);
        for (String permission : deniedPermissions) {
            if (!PermissionX.isGranted(this.getContext(), permission)) continue;
            this.pb.deniedPermissions.remove(permission);
            this.pb.grantedPermissions.add(permission);
        }
        boolean bl = allGranted = this.pb.grantedPermissions.size() == this.pb.normalPermissions.size();
        if (allGranted) {
            this.task.finish();
        } else {
            boolean shouldFinishTheTask = true;
            if (!(this.pb.explainReasonCallback == null && this.pb.explainReasonCallbackWithBeforeParam == null || showReasonList.isEmpty())) {
                shouldFinishTheTask = false;
                if (this.pb.explainReasonCallbackWithBeforeParam != null) {
                    this.pb.explainReasonCallbackWithBeforeParam.onExplainReason(this.task.getExplainScope(), new ArrayList<String>(this.pb.deniedPermissions), false);
                } else {
                    this.pb.explainReasonCallback.onExplainReason(this.task.getExplainScope(), new ArrayList<String>(this.pb.deniedPermissions));
                }
            } else if (this.pb.forwardToSettingsCallback != null && !forwardList.isEmpty()) {
                shouldFinishTheTask = false;
                this.pb.forwardToSettingsCallback.onForwardToSettings(this.task.getForwardScope(), new ArrayList<String>(this.pb.permanentDeniedPermissions));
            }
            if (shouldFinishTheTask || !this.pb.showDialogCalled) {
                this.task.finish();
            }
        }
    }

    private void onRequestBackgroundLocationPermissionResult() {
        if (PermissionX.isGranted(this.getContext(), "android.permission.ACCESS_BACKGROUND_LOCATION")) {
            this.pb.grantedPermissions.add("android.permission.ACCESS_BACKGROUND_LOCATION");
            this.pb.deniedPermissions.remove("android.permission.ACCESS_BACKGROUND_LOCATION");
            this.pb.permanentDeniedPermissions.remove("android.permission.ACCESS_BACKGROUND_LOCATION");
            this.task.finish();
        } else {
            boolean goesToRequestCallback = true;
            boolean shouldShowRationale = this.shouldShowRequestPermissionRationale("android.permission.ACCESS_BACKGROUND_LOCATION");
            if ((this.pb.explainReasonCallback != null || this.pb.explainReasonCallbackWithBeforeParam != null) && shouldShowRationale) {
                goesToRequestCallback = false;
                ArrayList<String> permissionsToExplain = new ArrayList<String>();
                permissionsToExplain.add("android.permission.ACCESS_BACKGROUND_LOCATION");
                if (this.pb.explainReasonCallbackWithBeforeParam != null) {
                    this.pb.explainReasonCallbackWithBeforeParam.onExplainReason(this.task.getExplainScope(), permissionsToExplain, false);
                } else {
                    this.pb.explainReasonCallback.onExplainReason(this.task.getExplainScope(), permissionsToExplain);
                }
            } else if (this.pb.forwardToSettingsCallback != null && !shouldShowRationale) {
                goesToRequestCallback = false;
                ArrayList<String> permissionsToForward = new ArrayList<String>();
                permissionsToForward.add("android.permission.ACCESS_BACKGROUND_LOCATION");
                this.pb.forwardToSettingsCallback.onForwardToSettings(this.task.getForwardScope(), permissionsToForward);
            }
            if (goesToRequestCallback || !this.pb.showDialogCalled) {
                this.task.finish();
            }
        }
    }
}

