/*
 * Decompiled with CFR 0.152.
 */
package com.permissionx.guolindev.request;

import android.content.Context;
import com.permissionx.guolindev.PermissionX;
import com.permissionx.guolindev.request.ChainTask;
import com.permissionx.guolindev.request.ExplainScope;
import com.permissionx.guolindev.request.ForwardScope;
import com.permissionx.guolindev.request.PermissionBuilder;
import java.util.ArrayList;

abstract class BaseTask
implements ChainTask {
    protected ChainTask next;
    protected PermissionBuilder pb;
    ExplainScope explainReasonScope;
    ForwardScope forwardToSettingsScope;

    BaseTask(PermissionBuilder permissionBuilder) {
        this.pb = permissionBuilder;
        this.explainReasonScope = new ExplainScope(this.pb, this);
        this.forwardToSettingsScope = new ForwardScope(this.pb, this);
    }

    @Override
    public ExplainScope getExplainScope() {
        return this.explainReasonScope;
    }

    @Override
    public ForwardScope getForwardScope() {
        return this.forwardToSettingsScope;
    }

    @Override
    public void finish() {
        if (this.next != null) {
            this.next.request();
        } else {
            ArrayList<String> deniedList = new ArrayList<String>();
            deniedList.addAll(this.pb.deniedPermissions);
            deniedList.addAll(this.pb.permanentDeniedPermissions);
            deniedList.addAll(this.pb.permissionsWontRequest);
            if (this.pb.requireBackgroundLocationPermission) {
                if (PermissionX.isGranted((Context)this.pb.activity, "android.permission.ACCESS_BACKGROUND_LOCATION")) {
                    this.pb.grantedPermissions.add("android.permission.ACCESS_BACKGROUND_LOCATION");
                } else {
                    deniedList.add("android.permission.ACCESS_BACKGROUND_LOCATION");
                }
            }
            if (this.pb.requestCallback != null) {
                this.pb.requestCallback.onResult(deniedList.isEmpty(), new ArrayList<String>(this.pb.grantedPermissions), deniedList);
            }
        }
    }
}

