/*
 * Decompiled with CFR 0.152.
 */
package com.permissionx.guolindev;

import android.os.Build;
import android.support.v4.app.FragmentActivity;
import com.permissionx.guolindev.request.PermissionBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;

public class PermissionCollection {
    private static final String TAG = "PermissionCollection";
    private FragmentActivity activity;

    public PermissionCollection(FragmentActivity activity) {
        this.activity = activity;
    }

    public PermissionBuilder permissions(String ... permissions) {
        return this.permissions(new ArrayList<String>(Arrays.asList(permissions)));
    }

    public PermissionBuilder permissions(List<String> permissions) {
        HashSet<String> permissionSet = new HashSet<String>(permissions);
        boolean requireBackgroundLocationPermission = false;
        HashSet<String> permissionsWontRequest = new HashSet<String>();
        if (permissionSet.contains("android.permission.ACCESS_BACKGROUND_LOCATION")) {
            int osVersion = Build.VERSION.SDK_INT;
            int targetSdkVersion = this.activity.getApplicationInfo().targetSdkVersion;
            if (osVersion >= 30 && targetSdkVersion >= 30) {
                requireBackgroundLocationPermission = true;
                permissionSet.remove("android.permission.ACCESS_BACKGROUND_LOCATION");
            } else if (osVersion < 29) {
                permissionSet.remove("android.permission.ACCESS_BACKGROUND_LOCATION");
                permissionsWontRequest.add("android.permission.ACCESS_BACKGROUND_LOCATION");
            }
        }
        return new PermissionBuilder(this.activity, permissionSet, requireBackgroundLocationPermission, permissionsWontRequest);
    }
}

