/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.impl.mapbased.rpc.sys;

import com.perforce.p4java.impl.mapbased.rpc.func.helper.MD5Digester;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import java.util.zip.ZipException;

public class RpcInflaterOutputStream
extends FilterOutputStream {
    protected final Inflater inf;
    protected final byte[] buf;
    private final byte[] wbuf = new byte[1];
    private boolean usesDefaultInflater = false;
    private boolean closed = false;
    private MD5Digester localDigester = null;

    private void ensureOpen() throws IOException {
        if (this.closed) {
            throw new IOException("Stream closed");
        }
    }

    public RpcInflaterOutputStream(OutputStream out, MD5Digester digester) {
        this(out, new Inflater(), digester);
        this.usesDefaultInflater = true;
    }

    public RpcInflaterOutputStream(OutputStream out, Inflater infl, MD5Digester digester) {
        this(out, infl, 512, digester);
    }

    public RpcInflaterOutputStream(OutputStream out, Inflater infl, int bufLen, MD5Digester digester) {
        super(out);
        this.localDigester = digester;
        if (out == null) {
            throw new NullPointerException("Null output");
        }
        if (infl == null) {
            throw new NullPointerException("Null inflater");
        }
        if (bufLen <= 0) {
            throw new IllegalArgumentException("Buffer size < 1");
        }
        this.inf = infl;
        this.buf = new byte[bufLen];
    }

    @Override
    public void close() throws IOException {
        if (!this.closed) {
            try {
                this.finish();
            }
            finally {
                this.out.close();
                this.closed = true;
            }
        }
    }

    @Override
    public void flush() throws IOException {
        this.ensureOpen();
        if (!this.inf.finished()) {
            try {
                int n;
                while (!this.inf.finished() && !this.inf.needsInput() && (n = this.inf.inflate(this.buf, 0, this.buf.length)) >= 1) {
                    this.out.write(this.buf, 0, n);
                    this.updateDigest(this.buf, 0, n);
                }
                super.flush();
            }
            catch (DataFormatException ex) {
                String msg = ex.getMessage();
                if (msg == null) {
                    msg = "Invalid ZLIB data format";
                }
                throw new ZipException(msg);
            }
        }
    }

    public void finish() throws IOException {
        this.ensureOpen();
        this.flush();
        if (this.usesDefaultInflater) {
            this.inf.end();
        }
    }

    @Override
    public void write(int b) throws IOException {
        this.wbuf[0] = (byte)b;
        this.write(this.wbuf, 0, 1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.ensureOpen();
        if (b == null) {
            throw new NullPointerException("Null buffer for read");
        }
        if (off < 0 || len < 0 || len > b.length - off) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return;
        }
        try {
            do {
                int n;
                if (this.inf.needsInput()) {
                    if (len < 1) return;
                    int part = len < 512 ? len : 512;
                    this.inf.setInput(b, off, part);
                    off += part;
                    len -= part;
                }
                do {
                    if ((n = this.inf.inflate(this.buf, 0, this.buf.length)) <= 0) continue;
                    this.out.write(this.buf, 0, n);
                    this.updateDigest(this.buf, 0, n);
                } while (n > 0);
                if (this.inf.finished()) return;
            } while (!this.inf.needsDictionary());
            throw new ZipException("ZLIB dictionary missing");
        }
        catch (DataFormatException ex) {
            String msg = ex.getMessage();
            if (msg != null) throw new ZipException(msg);
            msg = "Invalid ZLIB data format";
            throw new ZipException(msg);
        }
    }

    private void updateDigest(byte[] bytes, int offset, int count) {
        if (this.localDigester != null && bytes != null) {
            this.localDigester.update(bytes, offset, count);
        }
    }

    public MD5Digester getLocalDigester() {
        return this.localDigester;
    }

    public void setLocalDigester(MD5Digester localDigester) {
        this.localDigester = localDigester;
    }

    public long getBytesWritten() {
        if (this.inf != null) {
            return this.inf.getBytesWritten();
        }
        return 0L;
    }
}

