/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.impl.mapbased.rpc.sys;

import com.perforce.p4java.CharsetConverter;
import com.perforce.p4java.CharsetDefs;
import com.perforce.p4java.Log;
import com.perforce.p4java.env.SystemInfo;
import com.perforce.p4java.exception.NullPointerError;
import com.perforce.p4java.impl.generic.sys.ISystemFileCommandsHelper;
import com.perforce.p4java.impl.mapbased.rpc.func.client.ClientMessage;
import com.perforce.p4java.impl.mapbased.rpc.func.helper.StringHelper;
import com.perforce.p4java.impl.mapbased.rpc.msg.RpcMessage;
import com.perforce.p4java.impl.mapbased.rpc.sys.helper.SymbolicLinkHelper;
import com.perforce.p4java.impl.mapbased.rpc.sys.helper.SysFileHelperBridge;
import com.perforce.p4java.impl.mapbased.rpc.sys.helper.TextNormalizationHelper;
import com.perforce.p4java.impl.mapbased.server.Server;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;

public enum RpcPerforceFileType {
    FST_TEXT,
    FST_BINARY,
    FST_GZIP,
    FST_DIRECTORY,
    FST_SYMLINK,
    FST_RESOURCE,
    FST_SPECIAL,
    FST_MISSING,
    FST_CANTTELL,
    FST_EMPTY,
    FST_UNICODE,
    FST_GUNZIP,
    FST_UTF8,
    FST_UTF16,
    FST_TEXT_GUNZIP,
    FST_BINARY_GUNZIP,
    FST_XTEXT_GUNZIP,
    FST_XBINARY_GUNZIP,
    FST_SYMLINK_GUNZIP,
    FST_RESOURCE_GUNZIP,
    FST_XSYMLINK_GUNZIP,
    FST_XRESOURCE_GUNZIP,
    FST_UNICODE_GUNZIP,
    FST_RTEXT_GUNZIP,
    FST_XUNICODE_GUNZIP,
    FST_XRTEXT_GUNZIP,
    FST_APPLETEXT_GUNZIP,
    FST_APPLEFILE_GUNZIP,
    FST_XAPPLETEXT_GUNZIP,
    FST_XAPPLEFILE_GUNZIP,
    FST_UTF8_GUNZIP,
    FST_XUTF8_GUNZIP,
    FST_UTF16_GUNZIP,
    FST_XUTF16_GUNZIP,
    FST_ATEXT,
    FST_XTEXT,
    FST_RTEXT,
    FST_RXTEXT,
    FST_CBINARY,
    FST_XBINARY,
    FST_XSYMLINK,
    FST_XRESOURCE,
    FST_APPLETEXT,
    FST_APPLEFILE,
    FST_XAPPLEFILE,
    FST_XAPPLETEXT,
    FST_XUNICODE,
    FST_XRTEXT,
    FST_XUTF8,
    FST_XUTF16,
    FST_XGUNZIP,
    FST_RCS;

    public static final String TRACE_PREFIX = "RpcPerforceFileType";
    private static final ISystemFileCommandsHelper fileCommands;
    private static CtAction symlinkAction;
    private static final ActionTableElement[] actionTable;
    private static final byte[] pdfMagic;
    private static final byte[][] cBinaryMagicTable;
    static char[] validUtf8map;

    public static RpcPerforceFileType decodeFromServerString(String str) {
        if (str == null) {
            return FST_TEXT;
        }
        int tf = 0;
        int tl = 0;
        int tu = 0;
        switch (str.length()) {
            default: {
                tu = StringHelper.hexcharToInt(str.charAt(2));
            }
            case 2: {
                tl = StringHelper.hexcharToInt(str.charAt(1));
            }
            case 1: {
                tf = StringHelper.hexcharToInt(str.charAt(0));
            }
            case 0: 
        }
        switch (tf) {
            case 0: {
                return tu == 0 ? FST_TEXT : FST_TEXT_GUNZIP;
            }
            case 1: {
                return tu == 0 ? FST_BINARY : FST_BINARY_GUNZIP;
            }
            case 2: {
                return tu == 0 ? FST_XTEXT : FST_XTEXT_GUNZIP;
            }
            case 3: {
                return tu == 0 ? FST_XBINARY : FST_XBINARY_GUNZIP;
            }
            case 4: {
                return tu == 0 ? FST_SYMLINK : FST_SYMLINK_GUNZIP;
            }
            case 5: {
                return tu == 0 ? FST_RESOURCE : FST_RESOURCE_GUNZIP;
            }
            case 6: {
                return tu == 0 ? FST_XSYMLINK : FST_XSYMLINK_GUNZIP;
            }
            case 7: {
                return tu == 0 ? FST_XRESOURCE : FST_XRESOURCE_GUNZIP;
            }
            case 8: {
                return tu == 0 ? FST_UNICODE : FST_UNICODE_GUNZIP;
            }
            case 9: {
                return tu == 0 ? FST_RTEXT : FST_RTEXT_GUNZIP;
            }
            case 10: {
                return tu == 0 ? FST_XUNICODE : FST_XUNICODE_GUNZIP;
            }
            case 11: {
                return tu == 0 ? FST_XRTEXT : FST_XRTEXT_GUNZIP;
            }
            case 12: {
                return tu == 0 ? FST_APPLETEXT : FST_APPLETEXT_GUNZIP;
            }
            case 13: {
                return tu == 0 ? FST_APPLEFILE : FST_APPLEFILE_GUNZIP;
            }
            case 14: {
                return tu == 0 ? FST_XAPPLETEXT : FST_XAPPLETEXT_GUNZIP;
            }
            case 15: {
                return tu == 0 ? FST_XAPPLEFILE : FST_XAPPLEFILE_GUNZIP;
            }
            case 20: {
                return tu == 0 ? FST_UTF8 : FST_UTF8_GUNZIP;
            }
            case 22: {
                return tu == 0 ? FST_XUTF8 : FST_XUTF8_GUNZIP;
            }
            case 24: {
                return tu == 0 ? FST_UTF16 : FST_UTF16_GUNZIP;
            }
            case 26: {
                return tu == 0 ? FST_XUTF16 : FST_XUTF16_GUNZIP;
            }
            case 257: {
                return FST_GUNZIP;
            }
            case 259: {
                return FST_XGUNZIP;
            }
        }
        return FST_BINARY;
    }

    public boolean isExecutable() {
        switch (this) {
            case FST_XTEXT: 
            case FST_XTEXT_GUNZIP: 
            case FST_XRTEXT: 
            case FST_XRTEXT_GUNZIP: 
            case FST_XAPPLEFILE: 
            case FST_XAPPLEFILE_GUNZIP: 
            case FST_XBINARY: 
            case FST_XBINARY_GUNZIP: 
            case FST_XUNICODE: 
            case FST_XUNICODE_GUNZIP: 
            case FST_XUTF8: 
            case FST_XUTF8_GUNZIP: 
            case FST_XUTF16: 
            case FST_XUTF16_GUNZIP: 
            case FST_XGUNZIP: {
                return true;
            }
        }
        return false;
    }

    public boolean isCompressed() {
        switch (this) {
            case FST_XTEXT_GUNZIP: 
            case FST_XRTEXT_GUNZIP: 
            case FST_XAPPLEFILE_GUNZIP: 
            case FST_XBINARY_GUNZIP: 
            case FST_XUNICODE_GUNZIP: 
            case FST_XUTF8_GUNZIP: 
            case FST_XUTF16_GUNZIP: 
            case FST_XGUNZIP: 
            case FST_TEXT_GUNZIP: 
            case FST_BINARY_GUNZIP: 
            case FST_SYMLINK_GUNZIP: 
            case FST_RESOURCE_GUNZIP: 
            case FST_XSYMLINK_GUNZIP: 
            case FST_XRESOURCE_GUNZIP: 
            case FST_UNICODE_GUNZIP: 
            case FST_RTEXT_GUNZIP: 
            case FST_APPLETEXT_GUNZIP: 
            case FST_APPLEFILE_GUNZIP: 
            case FST_XAPPLETEXT_GUNZIP: 
            case FST_UTF8_GUNZIP: 
            case FST_UTF16_GUNZIP: 
            case FST_GUNZIP: {
                return true;
            }
        }
        return false;
    }

    public static RpcPerforceFileType inferFileType(File file, int scanSize, boolean isUnicodeServer, Charset clientCharset) {
        if (file == null) {
            throw new NullPointerError("Null file handle passed to RpcPerforceFileType.inferFileType()");
        }
        try {
            if (RpcPerforceFileType.isProbablySymLink(file)) {
                return FST_SYMLINK;
            }
            if (!file.exists()) {
                return FST_MISSING;
            }
            if (file.isDirectory()) {
                return FST_DIRECTORY;
            }
            if (!file.isFile()) {
                return FST_CANTTELL;
            }
            if (file.length() == 0L) {
                return FST_EMPTY;
            }
            return RpcPerforceFileType.inferFileTypeFromContents(file, fileCommands.canExecute(file.getPath()), scanSize, isUnicodeServer, clientCharset);
        }
        catch (Exception exc) {
            Log.exception(exc);
            return FST_CANTTELL;
        }
    }

    public static RpcServerTypeStringSpec getServerFileTypeString(String clientPath, boolean overSize, RpcPerforceFileType fileType, String forceType, int xlevel) {
        if (fileType != null) {
            for (ActionTableElement atElement : actionTable) {
                if (atElement.checkType != fileType) continue;
                return RpcPerforceFileType.getAction(clientPath, overSize, xlevel, atElement, forceType);
            }
        }
        Log.error("Encountered null or unknown filetype in getServerFileTypeString()", new Object[0]);
        return new RpcServerTypeStringSpec(null, new RpcMessage(ClientMessage.ClientMessageId.CANT_ADD_FILE_TYPE, 1, 34, new String[]{clientPath, "unknown"}));
    }

    public static boolean isProbablySymLink(File file) {
        if (file != null) {
            if (SymbolicLinkHelper.isSymbolicLinkCapable()) {
                return SymbolicLinkHelper.isSymbolicLink(file.getPath());
            }
            ISystemFileCommandsHelper helper = SysFileHelperBridge.getSysFileCommands();
            if (helper != null && helper.isSymlink(file.getPath())) {
                return true;
            }
            if (!Server.isRunningOnWindows()) {
                try {
                    String absoPath = file.getAbsolutePath();
                    String canoPath = file.getCanonicalPath();
                    if (TextNormalizationHelper.isNormalizationCapable()) {
                        canoPath = TextNormalizationHelper.normalize(file.getCanonicalPath());
                    }
                    if (SystemInfo.isMac() ? !absoPath.equalsIgnoreCase(canoPath) : !absoPath.equals(canoPath)) {
                        return true;
                    }
                }
                catch (IOException ioexc) {
                    Log.warn("unexpected exception in RpcPerforceFileType.isProbablySymLink(): %s", ioexc.getLocalizedMessage());
                    Log.exception(ioexc);
                }
            }
        }
        return false;
    }

    private static RpcServerTypeStringSpec getAction(String clientPath, boolean overSize, int xlevel, ActionTableElement atElement, String forceType) {
        switch (atElement.ctActions[xlevel >= atElement.xlevel ? 1 : 0]) {
            case OK: {
                if (forceType != null) {
                    return new RpcServerTypeStringSpec(forceType, null);
                }
                return new RpcServerTypeStringSpec(atElement.type, null);
            }
            case CHKSZ: {
                if (forceType != null) {
                    return new RpcServerTypeStringSpec(forceType, null);
                }
                if (overSize) {
                    return new RpcServerTypeStringSpec(atElement.cmpType, null);
                }
                return new RpcServerTypeStringSpec(atElement.type, null);
            }
            case ASS: {
                if (forceType != null) {
                    return new RpcServerTypeStringSpec(forceType, new RpcMessage(ClientMessage.ClientMessageId.ASSUMING_FILE_TYPE, 1, 34, new String[]{clientPath, atElement.type, forceType}));
                }
                return new RpcServerTypeStringSpec(atElement.altType, new RpcMessage(ClientMessage.ClientMessageId.ASSUMING_FILE_TYPE, 1, 34, new String[]{clientPath, atElement.type, atElement.altType}));
            }
            case SUBST: {
                return new RpcServerTypeStringSpec(atElement.altType, new RpcMessage(ClientMessage.ClientMessageId.SUBSTITUTING_FILE_TYPE, 1, 34, new String[]{clientPath, atElement.altType, atElement.type}));
            }
            case CANT: {
                return new RpcServerTypeStringSpec(null, new RpcMessage(ClientMessage.ClientMessageId.CANT_ADD_FILE_TYPE, 1, 34, new String[]{clientPath, atElement.type}));
            }
        }
        return new RpcServerTypeStringSpec(null, new RpcMessage(ClientMessage.ClientMessageId.CANT_ADD_FILE_TYPE, 1, 34, new String[]{clientPath, atElement.type}));
    }

    private static RpcPerforceFileType getBinaryType(byte[] buffer, int bytesRead, boolean isExecutable) {
        if (RpcPerforceFileType.isKnownCBinary(buffer, bytesRead)) {
            return FST_CBINARY;
        }
        return isExecutable ? FST_XBINARY : FST_BINARY;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static RpcPerforceFileType inferFileTypeFromContents(File file, boolean isExecutable, int scanSize, boolean isUnicodeServer, Charset clientCharset) {
        boolean utf32Bom;
        byte[] buffer = scanSize < 0 ? new byte[65536] : new byte[scanSize];
        int bytesRead = 0;
        try (FileInputStream inStream = new FileInputStream(file);){
            bytesRead = inStream.read(buffer);
            if (bytesRead < 0) {
                RpcPerforceFileType rpcPerforceFileType = FST_CANTTELL;
                return rpcPerforceFileType;
            }
        }
        catch (IOException ioexc) {
            Log.warn("Unexpected exception: %s", ioexc.getMessage());
            Log.exception(ioexc);
            return FST_CANTTELL;
        }
        if (bytesRead == 0) {
            return FST_EMPTY;
        }
        if (!isUnicodeServer) {
            clientCharset = null;
        }
        boolean highbit = false;
        boolean controlchar = false;
        boolean zero = false;
        for (int i = 0; i < bytesRead; highbit |= (0x80 & buffer[i]) != 0, zero |= buffer[i] == 0, controlchar |= (0x80 & buffer[i]) == 0 && Character.isISOControl(buffer[i]) && !Character.isWhitespace(buffer[i]), ++i) {
        }
        if (RpcPerforceFileType.isPDF(buffer, bytesRead)) {
            RpcPerforceFileType rpcPerforceFileType;
            if (isExecutable) {
                rpcPerforceFileType = FST_XBINARY;
                return rpcPerforceFileType;
            }
            rpcPerforceFileType = FST_BINARY;
            return rpcPerforceFileType;
        }
        RpcPerforceFileType rettype = isExecutable ? FST_XTEXT : FST_TEXT;
        Bom bom = RpcPerforceFileType.readBom(buffer, bytesRead);
        boolean utf8Bom = bom != null && bom == Bom.UTF8;
        boolean utf16Bom = bom != null && bom == Bom.UTF16;
        boolean bl = utf32Bom = bom != null && bom == Bom.UTF32;
        if (utf8Bom) {
            if (controlchar) {
                return RpcPerforceFileType.getBinaryType(buffer, bytesRead, isExecutable);
            }
            if (RpcPerforceFileType.testValidUtf8(buffer, bytesRead) > 0) {
                RpcPerforceFileType rpcPerforceFileType = rettype = isExecutable ? FST_XUTF8 : FST_UTF8;
            }
        }
        if (utf16Bom) {
            rettype = isExecutable ? FST_XUTF16 : FST_UTF16;
            clientCharset = Charset.forName("UTF-16");
            if (RpcPerforceFileType.checkConvert(buffer, bytesRead, clientCharset, true)) return rettype;
            return RpcPerforceFileType.getBinaryType(buffer, bytesRead, isExecutable);
        }
        String charsetName = "none";
        if (clientCharset != null) {
            charsetName = clientCharset.name();
        }
        switch (charsetName) {
            case "UTF-8": {
                if (controlchar) {
                    return RpcPerforceFileType.getBinaryType(buffer, bytesRead, isExecutable);
                }
                if (!highbit || rettype != FST_TEXT && rettype != FST_XTEXT || RpcPerforceFileType.testValidUtf8(buffer, bytesRead) <= 0) break;
                rettype = isExecutable ? FST_XUNICODE : FST_UNICODE;
                break;
            }
            case "UTF-32": 
            case "UTF-32LE": 
            case "UTF-32BE": {
                if (!zero && !highbit && !controlchar || utf8Bom) break;
                RpcPerforceFileType rpcPerforceFileType = rettype = isExecutable ? FST_XUNICODE : FST_UNICODE;
                if (utf32Bom) break;
                if (utf16Bom) {
                    return RpcPerforceFileType.getBinaryType(buffer, bytesRead, isExecutable);
                }
                if (RpcPerforceFileType.checkConvert(buffer, bytesRead, clientCharset, true)) break;
                return RpcPerforceFileType.getBinaryType(buffer, bytesRead, isExecutable);
            }
            case "UTF-16": 
            case "UTF-16LE": 
            case "UTF-16BE": {
                if (!zero && !highbit && !controlchar || utf8Bom) break;
                RpcPerforceFileType rpcPerforceFileType = rettype = isExecutable ? FST_XUNICODE : FST_UNICODE;
                if (utf16Bom) break;
                if (utf32Bom) {
                    return RpcPerforceFileType.getBinaryType(buffer, bytesRead, isExecutable);
                }
                if (RpcPerforceFileType.checkConvert(buffer, bytesRead, clientCharset, true)) break;
                return RpcPerforceFileType.getBinaryType(buffer, bytesRead, isExecutable);
            }
            case "none": {
                if (!controlchar) break;
                return RpcPerforceFileType.getBinaryType(buffer, bytesRead, isExecutable);
            }
            default: {
                if (controlchar) {
                    return RpcPerforceFileType.getBinaryType(buffer, bytesRead, isExecutable);
                }
                if (utf8Bom || !highbit || !RpcPerforceFileType.checkConvert(buffer, bytesRead, clientCharset, false)) break;
                rettype = isExecutable ? FST_XUNICODE : FST_UNICODE;
            }
        }
        if (rettype != FST_UNICODE) return rettype;
        if (!highbit) return rettype;
        if (RpcPerforceFileType.testValidUtf8(buffer, bytesRead) <= 0) return rettype;
        return isExecutable ? FST_XUTF8 : FST_UTF8;
    }

    private static boolean checkConvert(byte[] buffer, int bytesRead, Charset clientCharset, boolean checkSpaces) {
        byte[] bytes = null;
        try {
            CharsetConverter converter = new CharsetConverter(clientCharset, CharsetDefs.UTF8);
            ByteBuffer from = ByteBuffer.wrap(buffer, 0, bytesRead);
            ByteBuffer to = converter.convert(from);
            bytes = to.array();
        }
        catch (Throwable e) {
            return false;
        }
        if (!checkSpaces) {
            return true;
        }
        try {
            int ccnt;
            String str = new String(bytes, "UTF-8");
            int cnt = 0;
            for (ccnt = 0; ccnt < str.length(); ++ccnt) {
                if (!Character.isWhitespace(str.charAt(ccnt))) continue;
                ++cnt;
            }
            if (40 * cnt < ccnt) {
                return false;
            }
        }
        catch (UnsupportedEncodingException e) {
            return false;
        }
        return true;
    }

    private static int testValidUtf8(byte[] buffer, int bytesRead) {
        int followcnt = 0;
        int magic = 0;
        for (int i = 0; i < bytesRead; ++i) {
            char chflags = validUtf8map[0xFF & buffer[i]];
            if (followcnt != 0) {
                if ((chflags & 0x80) != 128) {
                    return 0;
                }
                --followcnt;
                if (magic == 0) continue;
                switch (magic) {
                    case 16: {
                        if ((chflags & 0x20) == 32) break;
                        return 0;
                    }
                    case 32: {
                        if ((chflags & 0x20) != 32) break;
                        return 0;
                    }
                    case 48: {
                        if ((chflags & 0x10) != 16) break;
                        return 0;
                    }
                    case 8: {
                        if ((chflags & 0x30) != 0) break;
                        return 0;
                    }
                }
                magic = 0;
                continue;
            }
            if ((chflags & 0x40) != 64) {
                return 0;
            }
            followcnt = chflags & 7;
            magic = chflags & 0x38;
        }
        if (followcnt != 0) {
            return 3;
        }
        return 1;
    }

    private static Bom readBom(byte[] bytes, int bytesRead) {
        if (bytesRead >= 4 && bytes[0] == -2 && bytes[1] == -1 && bytes[2] == 0 && bytes[3] == 0) {
            return Bom.UTF32;
        }
        if (bytesRead >= 4 && bytes[0] == 0 && bytes[1] == 0 && bytes[2] == -2 && bytes[3] == -1) {
            return Bom.UTF32;
        }
        if (bytesRead >= 3 && bytes[0] == -17 && bytes[1] == -69 && bytes[2] == -65) {
            return Bom.UTF8;
        }
        if (bytesRead >= 2 && bytes[0] == -1 && bytes[1] == -2) {
            return Bom.UTF16;
        }
        if (bytesRead >= 2 && bytes[0] == -2 && bytes[1] == -1) {
            return Bom.UTF16;
        }
        return null;
    }

    private static boolean isPDF(byte[] bytes, int bytesRead) {
        if (bytesRead > pdfMagic.length) {
            int i = 0;
            for (byte b : pdfMagic) {
                if (b == bytes[i++]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean isKnownCBinary(byte[] bytes, int bytesRead) {
        if (bytesRead > 0) {
            for (byte[] magicBytes : cBinaryMagicTable) {
                if (bytesRead <= magicBytes.length) continue;
                int i = 0;
                for (byte b : magicBytes) {
                    if (bytes[i] != b) break;
                    ++i;
                }
                if (i != magicBytes.length) continue;
                return true;
            }
        }
        return false;
    }

    public static byte[][] getBinaryMagicNumberTable() {
        return cBinaryMagicTable;
    }

    static {
        fileCommands = SysFileHelperBridge.getSysFileCommands();
        symlinkAction = SymbolicLinkHelper.isSymbolicLinkCapable() ? CtAction.OK : CtAction.CANT;
        actionTable = new ActionTableElement[]{new ActionTableElement(FST_TEXT, 0, CtAction.OK, CtAction.CHKSZ, "text", "text", "ctext"), new ActionTableElement(FST_XTEXT, 0, CtAction.SUBST, CtAction.CHKSZ, "xtext", "text", "text+Cx"), new ActionTableElement(FST_BINARY, 0, CtAction.OK, CtAction.OK, "binary", "binary"), new ActionTableElement(FST_XBINARY, 0, CtAction.SUBST, CtAction.OK, "xbinary", "binary"), new ActionTableElement(FST_APPLEFILE, 4, CtAction.SUBST, CtAction.OK, "apple", "binary"), new ActionTableElement(FST_XAPPLEFILE, 4, CtAction.SUBST, CtAction.OK, "apple+x", "binary"), new ActionTableElement(FST_CBINARY, 3, CtAction.SUBST, CtAction.OK, "ubinary", "binary"), new ActionTableElement(FST_SYMLINK, 1, CtAction.CANT, symlinkAction, "symlink", null), new ActionTableElement(FST_RESOURCE, 2, CtAction.CANT, CtAction.OK, "resource", null), new ActionTableElement(FST_SPECIAL, -1, CtAction.CANT, CtAction.CANT, "special", null), new ActionTableElement(FST_DIRECTORY, -1, CtAction.CANT, CtAction.CANT, "directory", null), new ActionTableElement(FST_MISSING, -1, CtAction.ASS, CtAction.ASS, "missing", "text"), new ActionTableElement(FST_CANTTELL, -1, CtAction.ASS, CtAction.ASS, "unreadable", "text"), new ActionTableElement(FST_EMPTY, -1, CtAction.ASS, CtAction.ASS, "empty", "text"), new ActionTableElement(FST_UNICODE, 5, CtAction.SUBST, CtAction.CHKSZ, "unicode", "text", "unicode+C"), new ActionTableElement(FST_XUNICODE, 5, CtAction.SUBST, CtAction.CHKSZ, "xunicode", "text", "xunicode+C"), new ActionTableElement(FST_UTF16, 6, CtAction.SUBST, CtAction.CHKSZ, "utf16", "binary", "utf16+C"), new ActionTableElement(FST_XUTF16, 6, CtAction.SUBST, CtAction.CHKSZ, "xutf16", "binary", "xutf16+C"), new ActionTableElement(FST_UTF8, 7, CtAction.SUBST, CtAction.CHKSZ, "utf8", "text", "utf8+C"), new ActionTableElement(FST_XUTF8, 7, CtAction.SUBST, CtAction.CHKSZ, "xutf8", "text", "xutf8+C")};
        pdfMagic = new byte[]{37, 80, 68, 70, 45};
        cBinaryMagicTable = new byte[][]{{71, 73, 70}, {-1, -40, -1, -32}, {-1, -40, -1, -31}, {31, -117}, {-1, 31}, {31, -99}, {80, 75, 3, 4}, {80, 75, 5, 6}, {-119, 80, 78, 71}, {-54, -2, -70, -66}};
        validUtf8map = new char[]{'@', '@', '@', '@', '@', '@', '@', '@', '@', '@', '@', '@', '@', '@', '@', '@', '@', '@', '@', '@', '@', '@', '@', '@', '@', '@', '@', '@', '@', '@', '@', '@', '@', '@', '@', '@', '@', '@', '@', '@', '@', '@', '@', '@', '@', '@', '@', '@', '@', '@', '@', '@', '@', '@', '@', '@', '@', '@', '@', '@', '@', '@', '@', '@', '@', '@', '@', '@', '@', '@', '@', '@', '@', '@', '@', '@', '@', '@', '@', '@', '@', '@', '@', '@', '@', '@', '@', '@', '@', '@', '@', '@', '@', '@', '@', '@', '@', '@', '@', '@', '@', '@', '@', '@', '@', '@', '@', '@', '@', '@', '@', '@', '@', '@', '@', '@', '@', '@', '@', '@', '@', '@', '@', '@', '@', '@', '@', '@', '\u00b0', '\u00b0', '\u00b0', '\u00b0', '\u00b0', '\u00b0', '\u00b0', '\u00b0', '\u00b0', '\u00b0', '\u00b0', '\u00b0', '\u00b0', '\u00b0', '\u00b0', '\u00b0', '\u0090', '\u0090', '\u0090', '\u0090', '\u0090', '\u0090', '\u0090', '\u0090', '\u0090', '\u0090', '\u0090', '\u0090', '\u0090', '\u0090', '\u0090', '\u0090', '\u0080', '\u0080', '\u0080', '\u0080', '\u0080', '\u0080', '\u0080', '\u0080', '\u0080', '\u0080', '\u0080', '\u0080', '\u0080', '\u0080', '\u0080', '\u0080', '\u0080', '\u0080', '\u0080', '\u0080', '\u0080', '\u0080', '\u0080', '\u0080', '\u0080', '\u0080', '\u0080', '\u0080', '\u0080', '\u0080', '\u0080', '\u0080', '\u0000', '\u0000', 'A', 'A', 'A', 'A', 'A', 'A', 'A', 'A', 'A', 'A', 'A', 'A', 'A', 'A', 'A', 'A', 'A', 'A', 'A', 'A', 'A', 'A', 'A', 'A', 'A', 'A', 'A', 'A', 'A', 'A', 'r', 'B', 'B', 'B', 'B', 'B', 'B', 'B', 'B', 'B', 'B', 'B', 'B', 'J', 'B', 'B', 'c', 'C', 'C', 'C', 'S', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000'};
    }

    static enum Bom {
        UTF8,
        UTF16,
        UTF32;

    }

    private static class ActionTableElement {
        public RpcPerforceFileType checkType = null;
        public int xlevel = 0;
        public CtAction[] ctActions = new CtAction[2];
        public String type = null;
        public String altType = null;
        public String cmpType = null;

        ActionTableElement(RpcPerforceFileType checkType, int xlevel, CtAction ctActions0, CtAction ctActions1, String type, String altType, String cmpType) {
            this.checkType = checkType;
            this.xlevel = xlevel;
            this.ctActions[0] = ctActions0;
            this.ctActions[1] = ctActions1;
            this.type = type;
            this.altType = altType;
            this.cmpType = cmpType;
        }

        ActionTableElement(RpcPerforceFileType checkType, int xlevel, CtAction ctActions0, CtAction ctActions1, String type, String altType) {
            this(checkType, xlevel, ctActions0, ctActions1, type, altType, null);
        }
    }

    public static class RpcServerTypeStringSpec {
        private String serverTypeString = null;
        private RpcMessage error = null;

        public RpcServerTypeStringSpec(String str, RpcMessage error) {
            this.serverTypeString = str;
            this.error = error;
        }

        public String getServerTypeString() {
            return this.serverTypeString;
        }

        public RpcMessage getMsg() {
            return this.error;
        }
    }

    private static enum CtAction {
        OK,
        ASS,
        CHKSZ,
        SUBST,
        CANT;

    }
}

