/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.impl.mapbased.server.cmd;

import com.perforce.p4java.Log;
import com.perforce.p4java.common.base.P4ResultMapUtils;
import com.perforce.p4java.core.IUserSummary;
import com.perforce.p4java.core.file.IFileSpec;
import com.perforce.p4java.exception.AccessException;
import com.perforce.p4java.exception.ConnectionException;
import com.perforce.p4java.exception.P4JavaException;
import com.perforce.p4java.exception.RequestException;
import com.perforce.p4java.impl.generic.core.UserSummary;
import com.perforce.p4java.impl.mapbased.server.Parameters;
import com.perforce.p4java.impl.mapbased.server.cmd.BaseDelegator;
import com.perforce.p4java.impl.mapbased.server.cmd.ResultMapParser;
import com.perforce.p4java.option.server.GetReviewsOptions;
import com.perforce.p4java.server.CmdSpec;
import com.perforce.p4java.server.IOptionsServer;
import com.perforce.p4java.server.delegator.IReviewsDelegator;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ReviewsDelegator
extends BaseDelegator
implements IReviewsDelegator {
    public ReviewsDelegator(IOptionsServer server) {
        super(server);
    }

    @Override
    public List<IUserSummary> getReviews(List<IFileSpec> fileSpecs, GetReviewsOptions opts) throws P4JavaException {
        ArrayList<IUserSummary> userList = new ArrayList<IUserSummary>();
        List<Map<String, Object>> resultMaps = this.execMapCmdList(CmdSpec.REVIEWS, Parameters.processParameters(opts, fileSpecs, this.server), null);
        if (Objects.nonNull(resultMaps)) {
            for (Map<String, Object> map : resultMaps) {
                ResultMapParser.handleErrorStr(map);
                try {
                    UserSummary userSummary = new UserSummary(P4ResultMapUtils.parseString(map, "user"), P4ResultMapUtils.parseString(map, "email"), P4ResultMapUtils.parseString(map, "name"), null, null);
                    userList.add(userSummary);
                }
                catch (Throwable thr) {
                    Log.error("Unexpected exception in getReviews: %s", thr.getLocalizedMessage());
                    Log.exception(thr);
                }
            }
        }
        return userList;
    }

    @Override
    public List<IUserSummary> getReviews(int changelistId, List<IFileSpec> fileSpecs) throws ConnectionException, RequestException, AccessException {
        try {
            return this.getReviews(fileSpecs, new GetReviewsOptions(changelistId));
        }
        catch (AccessException | ConnectionException | RequestException exc) {
            throw exc;
        }
        catch (P4JavaException exc) {
            throw new RequestException(exc.getMessage(), exc);
        }
    }
}

