/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.impl.mapbased.server.cmd;

import com.perforce.p4java.core.IUserSummary;
import com.perforce.p4java.exception.AccessException;
import com.perforce.p4java.exception.ConnectionException;
import com.perforce.p4java.exception.P4JavaException;
import com.perforce.p4java.exception.RequestException;
import com.perforce.p4java.impl.generic.core.UserSummary;
import com.perforce.p4java.impl.mapbased.server.Parameters;
import com.perforce.p4java.impl.mapbased.server.cmd.BaseDelegator;
import com.perforce.p4java.impl.mapbased.server.cmd.ResultListBuilder;
import com.perforce.p4java.option.Options;
import com.perforce.p4java.option.server.GetUsersOptions;
import com.perforce.p4java.server.CmdSpec;
import com.perforce.p4java.server.IOptionsServer;
import com.perforce.p4java.server.IServer;
import com.perforce.p4java.server.delegator.IUsersDelegator;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class UsersDelegator
extends BaseDelegator
implements IUsersDelegator {
    public UsersDelegator(IOptionsServer server) {
        super(server);
    }

    @Override
    public List<IUserSummary> getUsers(List<String> userList, GetUsersOptions opts) throws P4JavaException {
        String[] users = null;
        if (Objects.nonNull(userList)) {
            users = userList.toArray(new String[userList.size()]);
        }
        List<Map<String, Object>> resultMaps = this.execMapCmdList(CmdSpec.USERS, Parameters.processParameters((Options)opts, null, users, (IServer)this.server), null);
        return ResultListBuilder.buildNonNullObjectListFromCommandResultMaps(resultMaps, map -> new UserSummary((Map<String, Object>)map, true));
    }

    @Override
    public List<IUserSummary> getUsers(List<String> userList, int maxUsers) throws ConnectionException, RequestException, AccessException {
        try {
            return this.getUsers(userList, new GetUsersOptions().setMaxUsers(maxUsers));
        }
        catch (AccessException | ConnectionException | RequestException exc) {
            throw exc;
        }
        catch (P4JavaException exc) {
            throw new RequestException(exc.getMessage(), exc);
        }
    }
}

