/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.impl.mapbased.server.cmd;

import com.perforce.p4java.Log;
import com.perforce.p4java.common.base.P4ResultMapUtils;
import com.perforce.p4java.exception.P4JavaException;
import com.perforce.p4java.graph.IRevListCommit;
import com.perforce.p4java.impl.generic.graph.RevListCommit;
import com.perforce.p4java.impl.mapbased.server.Parameters;
import com.perforce.p4java.impl.mapbased.server.cmd.BaseDelegator;
import com.perforce.p4java.impl.mapbased.server.cmd.ResultMapParser;
import com.perforce.p4java.option.server.GraphRevListOptions;
import com.perforce.p4java.server.CmdSpec;
import com.perforce.p4java.server.IOptionsServer;
import com.perforce.p4java.server.delegator.IGraphRevListDelegator;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class GraphRevListDelegator
extends BaseDelegator
implements IGraphRevListDelegator {
    public GraphRevListDelegator(IOptionsServer server) {
        super(server);
    }

    @Override
    public List<IRevListCommit> getGraphRevList(GraphRevListOptions options) throws P4JavaException {
        List<Map<String, Object>> resultMaps = this.execMapCmdList(CmdSpec.GRAPH, Parameters.processParameters(options, this.server), null);
        if (!Objects.nonNull(resultMaps)) {
            return null;
        }
        String commit = null;
        ArrayList<IRevListCommit> graphRevList = new ArrayList<IRevListCommit>();
        for (Map<String, Object> map : resultMaps) {
            ResultMapParser.handleErrorStr(map);
            try {
                if (map.containsKey("commit")) {
                    commit = P4ResultMapUtils.parseString(map, "commit");
                }
            }
            catch (Throwable thr) {
                Log.exception(thr);
            }
            graphRevList.add(new RevListCommit(commit));
        }
        return graphRevList;
    }
}

