/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.impl.mapbased.server.cmd;

import com.perforce.p4java.common.function.Function;
import com.perforce.p4java.exception.AccessException;
import com.perforce.p4java.exception.ConnectionException;
import com.perforce.p4java.exception.P4JavaException;
import com.perforce.p4java.exception.RequestException;
import com.perforce.p4java.impl.mapbased.server.Parameters;
import com.perforce.p4java.impl.mapbased.server.cmd.BaseDelegator;
import com.perforce.p4java.impl.mapbased.server.cmd.ResultListBuilder;
import com.perforce.p4java.option.server.ExportRecordsOptions;
import com.perforce.p4java.server.CmdSpec;
import com.perforce.p4java.server.IOptionsServer;
import com.perforce.p4java.server.callback.IStreamingCallback;
import com.perforce.p4java.server.delegator.IExportDelegator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.Validate;

public class ExportDelegator
extends BaseDelegator
implements IExportDelegator {
    public ExportDelegator(IOptionsServer server) {
        super(server);
    }

    @Override
    public List<Map<String, Object>> getExportRecords(boolean useJournal, long maxRecs, int sourceNum, long offset, boolean format, String journalPrefix, String filter) throws ConnectionException, RequestException, AccessException {
        try {
            ExportRecordsOptions exportRecordsOptions = new ExportRecordsOptions().setFormat(format).setFilter(filter).setJournalPrefix(journalPrefix).setMaxRecs(maxRecs).setOffset(offset).setSourceNum(sourceNum).setUseJournal(useJournal);
            return this.getExportRecords(exportRecordsOptions);
        }
        catch (AccessException | ConnectionException | RequestException exc) {
            throw exc;
        }
        catch (P4JavaException exc) {
            throw new RequestException(exc.getMessage(), exc);
        }
    }

    @Override
    public List<Map<String, Object>> getExportRecords(ExportRecordsOptions opts) throws P4JavaException {
        HashMap<String, Object> inMap = new HashMap();
        if (Objects.nonNull(opts)) {
            inMap = opts.processFieldRules();
        }
        List<Map<String, Object>> resultMaps = this.execMapCmdList(CmdSpec.EXPORT, Parameters.processParameters(opts, this.server), inMap);
        return ResultListBuilder.buildNonNullObjectListFromCommandResultMaps(resultMaps, new Function<Map, Map<String, Object>>(){

            @Override
            public Map<String, Object> apply(Map map) {
                if (map.containsKey("func")) {
                    map.remove("func");
                }
                return map;
            }
        });
    }

    @Override
    public void getStreamingExportRecords(ExportRecordsOptions opts, @Nonnull IStreamingCallback callback, int key) throws P4JavaException {
        Validate.notNull((Object)callback);
        HashMap<String, Object> inMap = new HashMap();
        if (Objects.nonNull(opts)) {
            inMap = opts.processFieldRules();
        }
        this.server.execStreamingMapCommand(CmdSpec.EXPORT.toString(), Parameters.processParameters(opts, this.server), inMap, callback, key);
    }
}

