/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.impl.generic.core;

import com.perforce.p4java.core.IStreamSummary;
import com.perforce.p4java.impl.generic.core.ServerResource;
import java.util.Date;
import java.util.Map;

public class StreamSummary
extends ServerResource
implements IStreamSummary {
    public StreamSummary() {
        this.setDefaults();
    }

    public StreamSummary(boolean summaryOnly) {
        super(!summaryOnly, !summaryOnly);
    }

    public StreamSummary(boolean summaryOnly, String stream, Date accessed, Date updated, String name, String ownerName, String description, String parent, IStreamSummary.Type type, Options options) {
        super(!summaryOnly, !summaryOnly);
        this.setStream(stream);
        this.setAccessed(accessed);
        this.setUpdated(updated);
        this.setName(name);
        this.setOwnerName(ownerName);
        this.setDescription(description);
        this.setParent(parent);
        this.setType(type);
        this.setOptions(options);
    }

    public StreamSummary(Map<String, Object> map, boolean summaryOnly) {
        super(!summaryOnly, !summaryOnly);
        if (!summaryOnly) {
            this.setDefaults();
        }
        if (map != null) {
            this.setRawFields(map);
        }
    }

    private void setDefaults() {
        this.setDescription("");
        this.setOptions(new Options());
        this.setParent("none");
    }

    @Override
    public String getStream() {
        return (String)this.getRawField("Stream");
    }

    @Override
    public void setStream(String stream) {
        this.setRawField("Stream", stream);
        if (this.getName() == null) {
            stream = stream.substring(stream.lastIndexOf("/") + 1);
            this.setName(stream);
        }
    }

    @Override
    public Date getAccessed() {
        return this.parseDate((String)this.getRawField("Access"));
    }

    @Override
    public void setAccessed(Date accessed) {
        this.setRawField("Access", this.toDateString(accessed));
    }

    @Override
    public Date getUpdated() {
        return this.parseDate((String)this.getRawField("Update"));
    }

    @Override
    public void setUpdated(Date updated) {
        this.setRawField("Update", this.toDateString(updated));
    }

    @Override
    public String getName() {
        return (String)this.getRawField("Name");
    }

    @Override
    public void setName(String name) {
        this.setRawField("Name", name);
    }

    @Override
    public String getOwnerName() {
        return (String)this.getRawField("Owner");
    }

    @Override
    public void setOwnerName(String ownerName) {
        this.setRawField("Owner", ownerName);
    }

    @Override
    public String getDescription() {
        String desc = (String)this.getRawField("desc");
        String description = (String)this.getRawField("Description");
        return desc != null ? desc : description;
    }

    @Override
    public void setDescription(String description) {
        this.setRawField("Description", description);
    }

    @Override
    public String getParent() {
        if (!this.hasRawField("Parent")) {
            return null;
        }
        String value = (String)this.getRawField("Parent");
        value = value == null ? "none" : value;
        return value;
    }

    @Override
    public void setParent(String parent) {
        parent = parent == null ? "none" : parent;
        this.setRawField("Parent", parent);
    }

    @Override
    public IStreamSummary.Type getType() {
        String type = (String)this.getRawField("Type");
        if (type == null) {
            return null;
        }
        return IStreamSummary.Type.fromString(type.toUpperCase());
    }

    @Override
    public void setType(IStreamSummary.Type type) {
        this.setRawField("Type", type.toString().toLowerCase());
    }

    @Override
    public IStreamSummary.IOptions getOptions() {
        return new Options((String)this.getRawField("Options"));
    }

    @Override
    public void setOptions(IStreamSummary.IOptions options) {
        options = options == null ? new Options() : options;
        this.setRawField("Options", options.toString());
    }

    @Override
    public boolean isFirmerThanParent() {
        return new Boolean((String)this.getRawField("firmerThanParent"));
    }

    @Override
    public void setFirmerThanParent(boolean firmerThanParent) {
        this.setRawField("firmerThanParent", new Boolean(firmerThanParent).toString());
    }

    @Override
    public boolean isChangeFlowsToParent() {
        return new Boolean((String)this.getRawField("changeFlowsToParent"));
    }

    @Override
    public void setChangeFlowsToParent(boolean changeFlowsToParent) {
        this.setRawField("changeFlowsToParent", new Boolean(changeFlowsToParent).toString());
    }

    @Override
    public boolean isChangeFlowsFromParent() {
        return new Boolean((String)this.getRawField("changeFlowsFromParent"));
    }

    @Override
    public void setChangeFlowsFromParent(boolean changeFlowsFromParent) {
        this.setRawField("changeFlowsFromParent", new Boolean(changeFlowsFromParent).toString());
    }

    @Override
    @Deprecated
    public String getBaseParent() {
        return (String)this.getRawField("baseParent");
    }

    @Override
    @Deprecated
    public void setBaseParent(String baseParent) {
        this.setRawField("baseParent", baseParent);
    }

    @Override
    public boolean isUnloaded() {
        String value = (String)this.getRawField("IsUnloaded");
        return "1".equals(value);
    }

    public static class Options
    implements IStreamSummary.IOptions {
        private boolean ownerSubmit = false;
        private boolean locked = false;
        private boolean noToParent = false;
        private boolean noFromParent = false;

        public Options() {
        }

        public Options(boolean ownerSubmit, boolean locked, boolean noToParent, boolean noFromParent) {
            this.setOwnerSubmit(ownerSubmit);
            this.setLocked(locked);
            this.setNoToParent(noToParent);
            this.setNoFromParent(noFromParent);
        }

        public Options(String optionsString) {
            if (optionsString == null) {
                return;
            }
            for (String str : optionsString.split(" ")) {
                if (str.equalsIgnoreCase("ownersubmit")) {
                    this.setOwnerSubmit(true);
                    continue;
                }
                if (str.equalsIgnoreCase("locked")) {
                    this.setLocked(true);
                    continue;
                }
                if (str.equalsIgnoreCase("notoparent")) {
                    this.setNoToParent(true);
                    continue;
                }
                if (!str.equalsIgnoreCase("nofromparent")) continue;
                this.setNoFromParent(true);
            }
        }

        public String toString() {
            return (this.isOwnerSubmit() ? "ownersubmit" : "allsubmit") + (this.isLocked() ? " locked" : " unlocked") + (this.isNoToParent() ? " notoparent" : " toparent") + (this.isNoFromParent() ? " nofromparent" : " fromparent");
        }

        @Override
        public boolean isOwnerSubmit() {
            return this.ownerSubmit;
        }

        @Override
        public void setOwnerSubmit(boolean ownerSubmit) {
            this.ownerSubmit = ownerSubmit;
        }

        @Override
        public boolean isLocked() {
            return this.locked;
        }

        @Override
        public void setLocked(boolean locked) {
            this.locked = locked;
        }

        @Override
        public boolean isNoToParent() {
            return this.noToParent;
        }

        @Override
        public void setNoToParent(boolean noToParent) {
            this.noToParent = noToParent;
        }

        @Override
        public boolean isNoFromParent() {
            return this.noFromParent;
        }

        @Override
        public void setNoFromParent(boolean noFromParent) {
            this.noFromParent = noFromParent;
        }
    }
}

