/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.impl.mapbased.server.cmd;

import com.perforce.p4java.common.function.Function;
import com.perforce.p4java.core.IDepot;
import com.perforce.p4java.exception.P4JavaException;
import com.perforce.p4java.impl.generic.core.Depot;
import com.perforce.p4java.impl.generic.core.InputMapper;
import com.perforce.p4java.impl.mapbased.server.cmd.BaseDelegator;
import com.perforce.p4java.impl.mapbased.server.cmd.ResultListBuilder;
import com.perforce.p4java.impl.mapbased.server.cmd.ResultMapParser;
import com.perforce.p4java.server.CmdSpec;
import com.perforce.p4java.server.IOptionsServer;
import com.perforce.p4java.server.delegator.IDepotDelegator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.Validate;

public class DepotDelegator
extends BaseDelegator
implements IDepotDelegator {
    public DepotDelegator(IOptionsServer server) {
        super(server);
    }

    @Override
    public String createDepot(@Nonnull IDepot newDepot) throws P4JavaException {
        Validate.notNull((Object)newDepot);
        List<Map<String, Object>> resultMaps = this.execMapCmdList(CmdSpec.DEPOT, new String[]{"-i"}, InputMapper.map(newDepot));
        return ResultMapParser.parseCommandResultMapIfIsInfoMessageAsString(resultMaps);
    }

    @Override
    public String deleteDepot(String name) throws P4JavaException {
        Validate.notBlank((CharSequence)name, (String)"Delete depot name shouldn't null or empty", (Object[])new Object[0]);
        List<Map<String, Object>> resultMaps = this.execMapCmdList(CmdSpec.DEPOT, new String[]{"-d", name}, null);
        return ResultMapParser.parseCommandResultMapIfIsInfoMessageAsString(resultMaps);
    }

    @Override
    public IDepot getDepot(String name) throws P4JavaException {
        Validate.notBlank((CharSequence)name, (String)"Depot name shouldn't null or empty", (Object[])new Object[0]);
        List<Map<String, Object>> resultMaps = this.execMapCmdList(CmdSpec.DEPOT, new String[]{"-o", name}, null);
        return ResultListBuilder.buildNullableObjectFromNonInfoMessageCommandResultMaps(resultMaps, new Function<Map, IDepot>(){

            @Override
            public IDepot apply(Map map) {
                return new Depot(map);
            }
        });
    }
}

