/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.impl.generic.core.file;

import com.perforce.p4java.Log;
import com.perforce.p4java.common.base.ObjectUtils;
import com.perforce.p4java.common.base.P4ResultMapUtils;
import com.perforce.p4java.core.file.FileAction;
import com.perforce.p4java.core.file.FileSpecOpStatus;
import com.perforce.p4java.core.file.IExtendedFileSpec;
import com.perforce.p4java.core.file.IResolveRecord;
import com.perforce.p4java.impl.generic.core.file.FileSpec;
import com.perforce.p4java.impl.generic.core.file.ResolveRecord;
import com.perforce.p4java.server.IServer;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ExtendedFileSpec
extends FileSpec
implements IExtendedFileSpec {
    private boolean mapped = false;
    private FileAction headAction = null;
    private int headChange = 0;
    private int headRev = 0;
    private String headType = null;
    private Date headTime = null;
    private Date headModTime = null;
    private String headCharset = null;
    private int haveRev = 0;
    private String desc = null;
    private String digest = null;
    private long fileSize = 0L;
    private FileAction openAction = null;
    private String openType = null;
    private String openActionOwner = null;
    private int openChangelistId = 0;
    private boolean unresolved = false;
    private boolean resolved = false;
    private boolean reresolvable = false;
    private boolean otherLocked = false;
    private List<String> otherActionList = new ArrayList<String>();
    private List<String> otherChangelist = new ArrayList<String>();
    private List<String> otherOpenList = new ArrayList<String>();
    private String actionOwner = null;
    private String charset = null;
    private boolean shelved = false;
    private List<IResolveRecord> resolveRecords = new ArrayList<IResolveRecord>();
    private String movedFile = null;
    private Map<String, byte[]> attributes = new HashMap<String, byte[]>();
    private Map<String, byte[]> propagatingAttributes = new HashMap<String, byte[]>();
    private Map<String, byte[]> attributeTypes = new HashMap<String, byte[]>();
    private String verifyStatus = null;

    public ExtendedFileSpec() {
    }

    public ExtendedFileSpec(String pathStr) {
        super(pathStr);
    }

    public ExtendedFileSpec(FileSpecOpStatus status, String errStr) {
        super(status, errStr);
    }

    public ExtendedFileSpec(Map<String, Object> map, IServer server) {
        super(map, server, -1);
        if (ObjectUtils.isNull(map)) {
            return;
        }
        this.setHaveRev(ExtendedFileSpec.getRevFromString(P4ResultMapUtils.parseString(map, "haveRev")));
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            Object object = entry.getValue();
            String value = object == null ? null : object.toString();
            this.setEntry(entry.getKey(), value);
            if (ObjectUtils.nonNull(entry.getKey()) && (entry.getKey().startsWith("attr-") || entry.getKey().startsWith("openattr-"))) {
                this.updateAttr(entry, this.attributes);
            }
            if (ObjectUtils.nonNull(entry.getKey()) && (entry.getKey().startsWith("attrProp-") || entry.getKey().startsWith("openattrProp-"))) {
                this.updateAttr(entry, this.propagatingAttributes);
            }
            if (!ObjectUtils.nonNull(entry.getKey()) || !entry.getKey().startsWith("attrType-") && !entry.getKey().startsWith("openattrType-")) continue;
            this.updateAttr(entry, this.attributeTypes);
        }
        int i = 0;
        while (map.containsKey("resolveAction" + i)) {
            this.resolveRecords.add(new ResolveRecord(map, i));
            ++i;
        }
    }

    private void updateAttr(Map.Entry<String, Object> entry, Map<String, byte[]> mapToUpdate) {
        int i = entry.getKey().indexOf("-");
        if (i < entry.getKey().length()) {
            String name = entry.getKey().substring(i + 1);
            Object object = entry.getValue();
            if (object instanceof String) {
                mapToUpdate.put(name, ((String)object).getBytes());
            } else {
                mapToUpdate.put(name, (byte[])object);
            }
        }
    }

    private List<String> getStringList(Map<String, Object> map, String key) {
        ArrayList<String> strList = new ArrayList<String>();
        if (ObjectUtils.nonNull(map) && ObjectUtils.nonNull(key)) {
            int i = 0;
            while (map.containsKey(key + i)) {
                strList.add((String)map.get(key + i));
                ++i;
            }
        }
        return strList;
    }

    public ExtendedFileSpec(FileSpecOpStatus status, String errStr, String errCodeStr) {
        super(status, errStr, errCodeStr);
    }

    public ExtendedFileSpec(FileSpecOpStatus status, String errStr, int rawCode) {
        super(status, errStr, rawCode);
    }

    public ExtendedFileSpec(FileSpecOpStatus status, String errStr, int genericCode, int severityCode) {
        super(status, errStr, genericCode, severityCode);
    }

    @Override
    public String getActionOwner() {
        return this.actionOwner;
    }

    @Override
    public void setActionOwner(String actionOwner) {
        this.actionOwner = actionOwner;
    }

    public Map<String, byte[]> getAttributeTypes() {
        return this.attributeTypes;
    }

    @Override
    public Map<String, byte[]> getAttributes() {
        return this.attributes;
    }

    @Override
    public String getCharset() {
        return this.charset;
    }

    @Override
    public void setCharset(String charset) {
        this.charset = charset;
    }

    @Override
    public String getDesc() {
        return this.desc;
    }

    @Override
    public void setDesc(String desc) {
        this.desc = desc;
    }

    @Override
    public String getDigest() {
        return this.digest;
    }

    @Override
    public void setDigest(String digest) {
        this.digest = digest;
    }

    @Override
    public long getFileSize() {
        return this.fileSize;
    }

    @Override
    public void setFileSize(long fileSize) {
        this.fileSize = fileSize;
    }

    @Override
    public int getHaveRev() {
        return this.haveRev;
    }

    @Override
    public void setHaveRev(int haveRev) {
        this.haveRev = haveRev;
    }

    @Override
    public FileAction getHeadAction() {
        return this.headAction;
    }

    @Override
    public void setHeadAction(FileAction headAction) {
        this.headAction = headAction;
    }

    @Override
    public int getHeadChange() {
        return this.headChange;
    }

    @Override
    public void setHeadChange(int headChange) {
        this.headChange = headChange;
    }

    @Override
    public String getHeadCharset() {
        return this.headCharset;
    }

    @Override
    public void setHeadCharset(String headCharset) {
        this.headCharset = headCharset;
    }

    @Override
    public Date getHeadModTime() {
        return this.headModTime;
    }

    @Override
    public void setHeadModTime(Date headModTime) {
        this.headModTime = headModTime;
    }

    @Override
    public int getHeadRev() {
        return this.headRev;
    }

    @Override
    public void setHeadRev(int headRev) {
        this.headRev = headRev;
    }

    @Override
    public Date getHeadTime() {
        return this.headTime;
    }

    @Override
    public void setHeadTime(Date headTime) {
        this.headTime = headTime;
    }

    @Override
    public String getHeadType() {
        return this.headType;
    }

    @Override
    public void setHeadType(String headType) {
        this.headType = headType;
    }

    @Override
    public String getMovedFile() {
        return this.movedFile;
    }

    @Override
    public void setMovedFile(String movedFile) {
        this.movedFile = movedFile;
    }

    @Override
    public FileAction getOpenAction() {
        return this.openAction;
    }

    @Override
    public void setOpenAction(FileAction openAction) {
        this.openAction = openAction;
    }

    @Override
    public String getOpenActionOwner() {
        return this.openActionOwner;
    }

    @Override
    public void setOpenActionOwner(String openActionOwner) {
        this.openActionOwner = openActionOwner;
    }

    @Override
    public int getOpenChangelistId() {
        return this.openChangelistId;
    }

    @Override
    public void setOpenChangelistId(int openChangelistId) {
        this.openChangelistId = openChangelistId;
    }

    @Override
    public String getOpenType() {
        return this.openType;
    }

    @Override
    public void setOpenType(String openType) {
        this.openType = openType;
    }

    @Override
    public List<String> getOtherActionList() {
        return this.otherActionList;
    }

    @Override
    public void setOtherActionList(List<String> otherActionList) {
        this.otherActionList = otherActionList;
    }

    @Override
    public List<String> getOtherChangelist() {
        return this.otherChangelist;
    }

    @Override
    public void setOtherChangelist(List<String> otherChangelist) {
        this.otherChangelist = otherChangelist;
    }

    @Override
    public List<String> getOtherOpenList() {
        return this.otherOpenList;
    }

    @Override
    public void setOtherOpenList(List<String> otherOpenList) {
        this.otherOpenList = otherOpenList;
    }

    public Map<String, byte[]> getPropagatingAttributes() {
        return this.propagatingAttributes;
    }

    @Override
    public List<IResolveRecord> getResolveRecords() {
        return this.resolveRecords;
    }

    @Override
    public void setResolveRecords(List<IResolveRecord> resolveRecords) {
        this.resolveRecords = resolveRecords;
    }

    @Override
    public String getVerifyStatus() {
        return this.verifyStatus;
    }

    @Override
    public void setVerifyStatus(String verifyStatus) {
        this.verifyStatus = verifyStatus;
    }

    @Override
    public boolean isMapped() {
        return this.mapped;
    }

    @Override
    public void setMapped(boolean mapped) {
        this.mapped = mapped;
    }

    @Override
    public boolean isOtherLocked() {
        return this.otherLocked;
    }

    @Override
    public void setOtherLocked(boolean otherLocked) {
        this.otherLocked = otherLocked;
    }

    @Override
    public boolean isReresolvable() {
        return this.reresolvable;
    }

    @Override
    public void setReresolvable(boolean reresolvable) {
        this.reresolvable = reresolvable;
    }

    @Override
    public boolean isResolved() {
        return this.resolved;
    }

    @Override
    public void setResolved(boolean resolved) {
        this.resolved = resolved;
    }

    @Override
    public boolean isShelved() {
        return this.shelved;
    }

    @Override
    public boolean isUnresolved() {
        return this.unresolved;
    }

    @Override
    public void setUnresolved(boolean unresolved) {
        this.unresolved = unresolved;
    }

    @Override
    public void setEntry(String tag, String value) {
        switch (tag) {
            case "action": {
                this.setAction(FileAction.fromString(value));
                break;
            }
            case "digest": {
                this.setDigest(value);
                break;
            }
            case "rev": {
                this.setEndRevision(Integer.parseInt(value));
                break;
            }
            case "type": {
                this.setFileType(value);
                break;
            }
            case "depotFile": {
                this.setDepotPath(value);
                break;
            }
            case "fileSize": {
                this.setFileSize(value == null ? 0L : Long.parseLong(value));
                break;
            }
            case "headRev": {
                this.setHeadRev(value == null ? 0 : Integer.parseInt(value));
                break;
            }
            case "headType": {
                this.setHeadType(value);
                break;
            }
            case "headTime": {
                this.setHeadTime(value == null ? null : new Date(Long.parseLong(value) * 1000L));
                break;
            }
            case "headModTime": {
                this.setHeadModTime(value == null ? null : new Date(Long.parseLong(value) * 1000L));
                break;
            }
            case "headCharset": {
                this.setHeadCharset(value);
                break;
            }
            case "haveRev": {
                this.setHaveRev(ExtendedFileSpec.getRevFromString(value));
                break;
            }
            case "desc": {
                this.setDesc(value);
                break;
            }
            case "openAction": {
                this.setOpenAction(value == null ? null : FileAction.fromString(value));
                break;
            }
            case "openType": {
                this.setOpenType(value);
                break;
            }
            case "openActionOwner": {
                this.setOpenActionOwner(value);
                break;
            }
            case "openChangelist": {
                this.setOpenChangelistId(value == null ? 0 : Integer.parseInt(value));
                break;
            }
            case "resolved": {
                this.setResolved(ObjectUtils.nonNull(value));
                break;
            }
            case "unresolved": {
                this.setUnresolved(ObjectUtils.nonNull(Integer.parseInt(value)));
                break;
            }
            case "reresolvable": {
                this.setReresolvable(ObjectUtils.nonNull(value));
                break;
            }
            case "otherLock": {
                this.setOtherLocked(ObjectUtils.nonNull(value));
                break;
            }
            case "actionOwner": {
                this.setActionOwner(value);
                break;
            }
            case "charset": {
                this.setCharset(value);
                break;
            }
            case "shelved": {
                this.shelved = true;
                break;
            }
            case "movedFile": {
                this.movedFile = value;
                break;
            }
            case "status": {
                this.setVerifyStatus(value);
                break;
            }
            case "Client": {
                this.setClient(null);
                break;
            }
            case "headChange": {
                try {
                    if (!"default".equalsIgnoreCase("Client")) {
                        this.setHeadChange(Integer.parseInt(value));
                        break;
                    }
                    this.setHeadChange(0);
                }
                catch (NumberFormatException nfe) {
                    this.setHeadChange(-1);
                }
                break;
            }
            case "isMapped": {
                this.setMapped(ObjectUtils.nonNull(value));
                break;
            }
            case "headAction": {
                this.setHeadAction(FileAction.fromString(value));
                break;
            }
            case "change": {
                this.setChangelistId(Integer.parseInt(value));
                break;
            }
            case "clientFile": {
                this.setClientPath(value);
                break;
            }
            case "workRev": {
                this.setWorkRev(Integer.parseInt(value));
                break;
            }
            default: {
                if (tag.startsWith("resolve") || tag.startsWith("attr-") || tag.startsWith("openattr-") || tag.startsWith("attrProp-") || tag.startsWith("openattrProp-") || tag.startsWith("attrType-") || tag.startsWith("openattrType-")) break;
                Log.error("Unknown type: " + tag, new Object[0]);
            }
        }
    }
}

