/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.util;

import com.perforce.p4java.Log;
import com.perforce.p4java.impl.generic.sys.ISystemFileCommandsHelper;
import com.perforce.p4java.impl.mapbased.rpc.sys.helper.SysFileHelperBridge;
import com.perforce.p4java.server.ServerFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;

public class FilesHelper {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean copy(File source, File destination) throws IOException {
        boolean copied = false;
        if (source != null && destination != null) {
            FileInputStream reader = null;
            FileOutputStream writer = null;
            try {
                ISystemFileCommandsHelper helper = ServerFactory.getRpcFileSystemHelper();
                if (helper == null) {
                    helper = SysFileHelperBridge.getSysFileCommands();
                }
                if (helper != null) {
                    helper.setWritable(destination.getAbsolutePath(), true);
                }
                reader = new FileInputStream(source);
                writer = new FileOutputStream(destination, false);
                long targetCount = reader.getChannel().size();
                long transferCount = writer.getChannel().transferFrom(reader.getChannel(), 0L, targetCount);
                copied = transferCount == targetCount;
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException e) {
                        Log.warn("reader close error: " + e.getLocalizedMessage(), new Object[0]);
                        Log.exception(e);
                    }
                }
                if (writer != null) {
                    try {
                        writer.close();
                    }
                    catch (IOException e) {
                        Log.warn("writer close error: " + e.getLocalizedMessage(), new Object[0]);
                        Log.exception(e);
                    }
                }
            }
        }
        return copied;
    }

    public static boolean mkdirs(File file) {
        if (file != null) {
            File parentDir;
            String parent = file.getParent();
            if (parent != null && !(parentDir = new File(parent)).exists()) {
                if (parentDir.mkdirs()) {
                    return true;
                }
                return parentDir.exists();
            }
            return true;
        }
        return false;
    }
}

