/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.impl.mapbased.server.cmd;

import com.perforce.p4java.common.base.ObjectUtils;
import com.perforce.p4java.core.IJob;
import com.perforce.p4java.core.file.IFileSpec;
import com.perforce.p4java.exception.AccessException;
import com.perforce.p4java.exception.ConnectionException;
import com.perforce.p4java.exception.P4JavaException;
import com.perforce.p4java.exception.RequestException;
import com.perforce.p4java.impl.generic.core.Job;
import com.perforce.p4java.impl.mapbased.server.Parameters;
import com.perforce.p4java.impl.mapbased.server.cmd.BaseDelegator;
import com.perforce.p4java.impl.mapbased.server.cmd.ResultMapParser;
import com.perforce.p4java.option.server.GetJobsOptions;
import com.perforce.p4java.server.CmdSpec;
import com.perforce.p4java.server.IOptionsServer;
import com.perforce.p4java.server.delegator.IJobsDelegator;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class JobsDelegator
extends BaseDelegator
implements IJobsDelegator {
    public JobsDelegator(IOptionsServer server) {
        super(server);
    }

    @Override
    public List<IJob> getJobs(List<IFileSpec> fileSpecs, int maxJobs, boolean longDescriptions, boolean reverseOrder, boolean includeIntegrated, String jobView) throws ConnectionException, RequestException, AccessException {
        try {
            GetJobsOptions getJobsOptions = new GetJobsOptions().setIncludeIntegrated(includeIntegrated).setLongDescriptions(longDescriptions).setMaxJobs(maxJobs).setReverseOrder(reverseOrder).setJobView(jobView);
            return this.getJobs(fileSpecs, getJobsOptions);
        }
        catch (AccessException | ConnectionException | RequestException exc) {
            throw exc;
        }
        catch (P4JavaException exc) {
            throw new RequestException(exc.getMessage(), exc);
        }
    }

    @Override
    public List<IJob> getJobs(List<IFileSpec> fileSpecs, GetJobsOptions opts) throws P4JavaException {
        ArrayList<IJob> jobList = new ArrayList<IJob>();
        List<Map<String, Object>> resultMaps = this.execMapCmdList(CmdSpec.JOBS, Parameters.processParameters(opts, fileSpecs, this.server), null);
        if (ObjectUtils.nonNull(resultMaps)) {
            for (Map<String, Object> map : resultMaps) {
                if (!ObjectUtils.nonNull(map)) continue;
                ResultMapParser.throwRequestExceptionIfErrorMessageFound(map);
                jobList.add(new Job(this.server, map, ObjectUtils.nonNull(opts) && opts.isLongDescriptions()));
            }
        }
        return jobList;
    }
}

