/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.impl.generic.core;

import com.perforce.p4java.core.IServerResource;
import com.perforce.p4java.exception.AccessException;
import com.perforce.p4java.exception.ConnectionException;
import com.perforce.p4java.exception.RequestException;
import com.perforce.p4java.exception.UnimplementedError;
import com.perforce.p4java.option.Options;
import com.perforce.p4java.server.IServer;

public abstract class ServerResource
implements IServerResource {
    protected boolean refreshable = false;
    protected boolean updateable = false;
    protected IServer server = null;

    protected ServerResource() {
    }

    protected ServerResource(IServer server) {
        this.server = server;
    }

    protected ServerResource(boolean refreshable, boolean updateable) {
        this(refreshable, updateable, null);
    }

    protected ServerResource(boolean refreshable, boolean updateable, IServer server) {
        this(server);
        this.refreshable = refreshable;
        this.updateable = updateable;
    }

    @Override
    public boolean canRefresh() {
        return this.refreshable && this.server != null;
    }

    @Override
    public boolean canUpdate() {
        return this.updateable && this.server != null;
    }

    @Override
    public void complete() throws ConnectionException, RequestException, AccessException {
        throw new UnimplementedError("called default IServerResourceImpl.complete");
    }

    @Override
    public void refresh() throws ConnectionException, RequestException, AccessException {
        throw new UnimplementedError("called default IServerResourceImpl.refresh");
    }

    @Override
    public void update() throws ConnectionException, RequestException, AccessException {
        throw new UnimplementedError("called default IServerResourceImpl.update");
    }

    @Override
    public void update(boolean force) throws ConnectionException, RequestException, AccessException {
        throw new UnimplementedError("called IServerResourceImpl.update(force)");
    }

    @Override
    public void update(Options opts) throws ConnectionException, RequestException, AccessException {
        throw new UnimplementedError("called IServerResourceImpl.update(opts)");
    }

    public void setRefreshable(boolean refreshable) {
        this.refreshable = refreshable;
    }

    @Override
    public void setServer(IServer server) {
        this.server = server;
    }
}

