/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.io.apple;

import com.perforce.p4java.Log;
import com.perforce.p4java.exception.FileDecoderException;
import com.perforce.p4java.io.apple.AppleFile;
import com.perforce.p4java.io.apple.AppleFileData;

public class AppleFileDecoder
extends AppleFile {
    public AppleFileDecoder(AppleFileData fileData) {
        if (fileData != null) {
            this.fileData = fileData;
        }
    }

    public void extract() throws FileDecoderException {
        this.verify();
        byte[] data = this.fileData.getData();
        int offset = this.fileData.getOffset();
        int length = this.fileData.getLength();
        int contentPosition = 0;
        int entryId = 0;
        int entryOffset = 0;
        int entryLength = 0;
        block16: for (int i = 0; i < this.numEntries; ++i) {
            contentPosition = offset + 26 + i * 12;
            entryId = 0;
            entryId |= data[contentPosition++] & 0xFF;
            entryId <<= 8;
            entryId |= data[contentPosition++] & 0xFF;
            entryId <<= 8;
            entryId |= data[contentPosition++] & 0xFF;
            entryId <<= 8;
            entryId |= data[contentPosition++] & 0xFF;
            entryOffset = 0;
            entryOffset |= data[contentPosition++] & 0xFF;
            entryOffset <<= 8;
            entryOffset |= data[contentPosition++] & 0xFF;
            entryOffset <<= 8;
            entryOffset |= data[contentPosition++] & 0xFF;
            entryOffset <<= 8;
            entryOffset |= data[contentPosition++] & 0xFF;
            entryOffset &= Integer.MAX_VALUE;
            entryLength = 0;
            entryLength |= data[contentPosition++] & 0xFF;
            entryLength <<= 8;
            entryLength |= data[contentPosition++] & 0xFF;
            entryLength <<= 8;
            entryLength |= data[contentPosition++] & 0xFF;
            entryLength <<= 8;
            entryLength |= data[contentPosition++] & 0xFF;
            entryLength &= Integer.MAX_VALUE;
            switch (entryId) {
                case 1: {
                    this.dataFork = new AppleFileData(data, offset + entryOffset, entryLength);
                    continue block16;
                }
                case 2: {
                    this.resourceFork = new AppleFileData(data, offset + entryOffset, entryLength);
                    continue block16;
                }
                case 3: {
                    this.realName = new AppleFileData(data, offset + entryOffset, entryLength);
                    continue block16;
                }
                case 4: {
                    this.comment = new AppleFileData(data, offset + entryOffset, entryLength);
                    continue block16;
                }
                case 5: {
                    this.iconBW = new AppleFileData(data, offset + entryOffset, entryLength);
                    continue block16;
                }
                case 6: {
                    this.iconColor = new AppleFileData(data, offset + entryOffset, entryLength);
                    continue block16;
                }
                case 8: {
                    this.fileDatesInfo = new AppleFileData(data, offset + entryOffset, entryLength);
                    this.extractFileDates(data, offset + entryOffset, entryLength);
                    continue block16;
                }
                case 9: {
                    this.finderInfo = new AppleFileData(data, offset + entryOffset, entryLength);
                    continue block16;
                }
                case 10: {
                    this.macintoshInfo = new AppleFileData(data, offset + entryOffset, entryLength);
                }
                case 11: {
                    this.proDOSFileInfo = new AppleFileData(data, offset + entryOffset, entryLength);
                }
                case 12: {
                    this.msDOSFileInfo = new AppleFileData(data, offset + entryOffset, entryLength);
                }
                case 13: {
                    this.shortName = new AppleFileData(data, offset + entryOffset, entryLength);
                    continue block16;
                }
                case 14: {
                    this.afpFileInfo = new AppleFileData(data, offset + entryOffset, entryLength);
                    continue block16;
                }
                case 15: {
                    this.directoryID = new AppleFileData(data, offset + entryOffset, entryLength);
                    continue block16;
                }
                default: {
                    Log.warn("Apple file entry ID: " + entryId + " is not handled.", new Object[0]);
                }
            }
        }
    }
}

