/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.impl.mapbased.rpc.stream;

import com.perforce.p4java.Log;
import com.perforce.p4java.common.base.ObjectUtils;
import com.perforce.p4java.common.base.P4JavaExceptions;
import com.perforce.p4java.common.base.StringHelper;
import com.perforce.p4java.exception.ConnectionException;
import com.perforce.p4java.exception.P4JavaError;
import com.perforce.p4java.impl.mapbased.rpc.ExternalEnv;
import com.perforce.p4java.impl.mapbased.rpc.ServerStats;
import com.perforce.p4java.impl.mapbased.rpc.connection.RpcConnection;
import com.perforce.p4java.impl.mapbased.rpc.func.RpcFunctionSpec;
import com.perforce.p4java.impl.mapbased.rpc.func.client.ClientTrust;
import com.perforce.p4java.impl.mapbased.rpc.packet.RpcPacket;
import com.perforce.p4java.impl.mapbased.rpc.packet.RpcPacketDispatcher;
import com.perforce.p4java.impl.mapbased.rpc.packet.RpcPacketPreamble;
import com.perforce.p4java.impl.mapbased.rpc.packet.helper.RpcPacketFieldRule;
import com.perforce.p4java.impl.mapbased.rpc.stream.RpcGZIPInputStream;
import com.perforce.p4java.impl.mapbased.rpc.stream.RpcGZIPOutputStream;
import com.perforce.p4java.impl.mapbased.rpc.stream.RpcRshInputStream;
import com.perforce.p4java.impl.mapbased.rpc.stream.RpcRshOutputStream;
import com.perforce.p4java.impl.mapbased.rpc.stream.RpcSocketInputStream;
import com.perforce.p4java.impl.mapbased.rpc.stream.RpcSocketOutputStream;
import com.perforce.p4java.impl.mapbased.rpc.stream.RpcSocketPool;
import com.perforce.p4java.impl.mapbased.rpc.stream.helper.RpcSocketHelper;
import com.perforce.p4java.impl.mapbased.server.Server;
import com.perforce.p4java.server.P4Charset;
import com.perforce.p4java.server.callback.IFilterCallback;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.text.MessageFormat;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nonnull;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;

public class RpcStreamConnection
extends RpcConnection {
    public static final String TRACE_PREFIX = "RpcStreamConnection";
    protected static final int INITIAL_SENDBUF_SIZE = 2048;
    protected static final int SENDBUF_REALLOC_INCR = 1024;
    private RpcSocketPool pool = null;
    private Socket socket = null;
    private InputStream inputStream = null;
    private OutputStream outputStream = null;
    private InputStream topInputStream = null;
    private OutputStream topOutputStream = null;
    private String rsh = null;

    public RpcStreamConnection(String serverHost, int serverPort, Properties props, ServerStats stats, P4Charset p4Charset, boolean secure) throws ConnectionException {
        this(serverHost, serverPort, props, stats, p4Charset, null, secure);
    }

    private RpcStreamConnection(String serverHost, int serverPort, Properties props, ServerStats stats, P4Charset p4Charset, Socket socket, boolean secure) throws ConnectionException {
        this(serverHost, serverPort, props, stats, p4Charset, socket, null, secure);
    }

    private RpcStreamConnection(String serverHost, int serverPort, Properties props, ServerStats stats, P4Charset p4Charset, Socket socket, RpcSocketPool pool, boolean secure) throws ConnectionException {
        this(serverHost, serverPort, props, stats, p4Charset, socket, pool, secure, null);
    }

    public RpcStreamConnection(String serverHost, int serverPort, Properties props, ServerStats stats, P4Charset p4Charset, Socket socket, RpcSocketPool pool, boolean secure, String rsh) throws ConnectionException {
        super(serverHost, serverPort, props, stats, p4Charset, secure);
        this.socket = socket;
        this.pool = pool;
        this.rsh = rsh;
        this.init();
    }

    private void init() throws ConnectionException {
        if (StringUtils.isNotBlank((CharSequence)this.rsh)) {
            this.initRshModeServer();
        } else {
            this.initSocketBasedServer();
        }
        this.topInputStream = this.inputStream;
        this.topOutputStream = this.outputStream;
    }

    private void initRshModeServer() throws ConnectionException {
        try {
            String[] command = new String[]{Server.isRunningOnWindows() ? "cmd.exe" : "/bin/sh", Server.isRunningOnWindows() ? "/c" : "-c", this.rsh};
            ProcessBuilder builder = new ProcessBuilder(command);
            Process process = builder.start();
            InputStream in = process.getInputStream();
            OutputStream out = process.getOutputStream();
            this.inputStream = new RpcRshInputStream(in, this.stats);
            this.outputStream = new RpcRshOutputStream(out, this.stats);
        }
        catch (Throwable thr) {
            Log.error("Unexpected exception: %s", thr.getLocalizedMessage());
            Log.exception(thr);
            P4JavaExceptions.throwConnectionException(thr);
        }
    }

    private void initSocketBasedServer() throws ConnectionException {
        try {
            if (ObjectUtils.isNull(this.socket)) {
                this.socket = ObjectUtils.nonNull(this.pool) ? this.pool.acquire() : RpcSocketHelper.createSocket(this.hostName, this.hostPort, this.props, this.secure);
            }
        }
        catch (UnknownHostException exc) {
            P4JavaExceptions.throwConnectionException(exc, "Unable to resolve Perforce server host name '%s' for RPC connection", this.hostName);
        }
        catch (IOException exc) {
            P4JavaExceptions.throwConnectionException(exc, "Unable to connect to Perforce server at %s:%s", this.hostName, this.hostPort);
        }
        catch (Throwable thr) {
            Log.error("Unexpected exception: %s", thr.getLocalizedMessage());
            Log.exception(thr);
            P4JavaExceptions.throwConnectionException(thr);
        }
        this.getIpAddressFromSocketConnection();
        if (this.secure) {
            this.initSSL();
        }
        this.initRpcSocketInputAndOutputStreamIfSocketBasedServer();
    }

    private void getIpAddressFromSocketConnection() {
        if (ObjectUtils.nonNull(this.socket)) {
            InetAddress inetAddress = this.socket.getInetAddress();
            if (ObjectUtils.nonNull(inetAddress)) {
                String hostAddress = inetAddress.getHostAddress();
                this.hostIp = Inet6Address.class.isAssignableFrom(inetAddress.getClass()) ? "[" + hostAddress + "]" : hostAddress;
            }
            if (this.socket.isBound()) {
                InetAddress address = this.socket.getLocalAddress();
                this.ourIp = Inet6Address.class.isAssignableFrom(address.getClass()) ? "[" + address.getHostAddress() + "]" : address.getHostAddress();
                this.ourPort = this.socket.getLocalPort();
            }
        }
    }

    private void initSSL() throws ConnectionException {
        if (ObjectUtils.nonNull(this.socket)) {
            try {
                SSLSession sslSession = ((SSLSocket)this.socket).getSession();
                P4JavaExceptions.throwConnectionExceptionIfConditionFails(sslSession.isValid(), "Error occurred during the SSL handshake: invalid SSL session", new Object[0]);
                Certificate[] serverCerts = sslSession.getPeerCertificates();
                P4JavaExceptions.throwConnectionExceptionIfConditionFails(ObjectUtils.nonNull(serverCerts) && serverCerts.length != 0 && ObjectUtils.nonNull(serverCerts[0]), "Error occurred during the SSL handshake: no certificate retrieved from SSL session", new Object[0]);
                ((X509Certificate)serverCerts[0]).checkValidity();
                PublicKey serverPubKey = serverCerts[0].getPublicKey();
                P4JavaExceptions.throwConnectionExceptionIfConditionFails(ObjectUtils.nonNull(serverPubKey), "Error occurred during the SSL handshake: no public key retrieved from server certificate", new Object[0]);
                this.fingerprint = ClientTrust.generateFingerprint(serverPubKey);
            }
            catch (CertificateExpiredException e) {
                P4JavaExceptions.throwConnectionException(e, "Error occurred during the SSL handshake: certificate expired:", new Object[0]);
            }
            catch (CertificateNotYetValidException e) {
                P4JavaExceptions.throwConnectionException(e, "Error occurred during the SSL handshake: certificate not yet valid", new Object[0]);
            }
            catch (NoSuchAlgorithmException e) {
                P4JavaExceptions.throwConnectionException(e, "Error occurred while generating the fingerprint for the Perforce SSL connection", new Object[0]);
            }
            catch (IOException e) {
                String errorMessage = StringHelper.format("Error occurred during SSL hankshake. Please check the release notes for known SSL issues", new Object[0]);
                Log.error(errorMessage, new Object[0]);
                Log.exception(e);
                P4JavaExceptions.throwConnectionException(e, errorMessage, new Object[0]);
            }
        }
    }

    private void initRpcSocketInputAndOutputStreamIfSocketBasedServer() throws ConnectionException {
        try {
            this.inputStream = new RpcSocketInputStream(this.socket, this.stats);
            this.outputStream = new RpcSocketOutputStream(this.socket, this.stats);
        }
        catch (Throwable thr) {
            Log.error("Unexpected exception: %s", thr.getLocalizedMessage());
            Log.exception(thr);
            P4JavaExceptions.throwConnectionException(thr);
        }
    }

    @Override
    public String getServerIpPort() {
        String serverIpPort = null;
        if (!StringUtils.equals((CharSequence)this.hostIp, (CharSequence)UNKNOWN_SERVER_HOST)) {
            serverIpPort = this.hostIp;
            if (this.hostPort != -1) {
                serverIpPort = serverIpPort + ":" + String.valueOf(this.hostPort);
            }
        } else if (this.hostPort != -1) {
            serverIpPort = Integer.toString(this.hostPort);
        }
        return serverIpPort;
    }

    @Override
    public String getClientIpPort() {
        String clientIpPort = null;
        if (this.ourIp != UNKNOWN_SERVER_HOST) {
            clientIpPort = this.ourIp;
            if (this.ourPort != -1) {
                clientIpPort = clientIpPort + ":" + Integer.toString(this.ourPort);
            }
        } else if (this.ourPort != -1) {
            clientIpPort = Integer.toString(this.ourPort);
        }
        return clientIpPort;
    }

    @Override
    public void disconnect(final RpcPacketDispatcher dispatcher) throws ConnectionException {
        block8: {
            try {
                RpcSocketPool.ShutdownHandler handler = new RpcSocketPool.ShutdownHandler(){

                    @Override
                    public void shutdown(Socket theSocket) {
                        if (ObjectUtils.nonNull(dispatcher)) {
                            try {
                                dispatcher.shutdown(RpcStreamConnection.this);
                            }
                            catch (ConnectionException e) {
                                Log.exception(e);
                            }
                        }
                    }
                };
                if (StringUtils.isNotBlank((CharSequence)this.rsh)) {
                    try {
                        dispatcher.shutdown(this);
                    }
                    catch (ConnectionException e) {
                        Log.exception(e);
                    }
                    this.topInputStream.close();
                    this.topOutputStream.close();
                    break block8;
                }
                if (ObjectUtils.nonNull(this.pool)) {
                    this.pool.release(this.socket, handler);
                } else {
                    handler.shutdown(this.socket);
                    this.topInputStream.close();
                    this.topOutputStream.close();
                    if (ObjectUtils.nonNull(this.socket)) {
                        this.socket.close();
                    }
                }
            }
            catch (IOException exc) {
                P4JavaExceptions.throwConnectionException(exc, "RPC disconnection error: %s", exc.getLocalizedMessage());
            }
        }
    }

    @Override
    public RpcPacket getRpcPacket() throws ConnectionException {
        return this.getRpcPacket(null, null);
    }

    @Override
    public RpcPacket getRpcPacket(RpcPacketFieldRule fieldRule, IFilterCallback filterCallback) throws ConnectionException {
        byte[] preambleBytes = new byte[5];
        RpcPacket packet = null;
        try {
            int bytesRead = this.topInputStream.read(preambleBytes);
            P4JavaExceptions.throwConnectionExceptionIfConditionFails(bytesRead >= 0, "server connection unexpectedly closed", new Object[0]);
            AtomicLong streamRecvs = this.stats.streamRecvs;
            streamRecvs.incrementAndGet();
            bytesRead = this.continueReadIfGetPartialRead(preambleBytes, bytesRead, streamRecvs);
            P4JavaExceptions.throwConnectionExceptionIfConditionFails(bytesRead == preambleBytes.length, "Incomplete RPC packet preamble read from Perforce server; connection probably broken. bytes read: %s", bytesRead);
            this.stats.totalBytesRecv.getAndAdd(bytesRead);
            RpcPacketPreamble preamble = RpcPacketPreamble.retrievePreamble(preambleBytes);
            P4JavaExceptions.throwProtocolErrorIfConditionFails(preamble.isValidChecksum(), "Bad checksum in RPC preamble", new Object[0]);
            int payloadLength = preamble.getPayloadSize();
            P4JavaExceptions.throwProtocolErrorIfConditionFails(payloadLength > 0, "Bad payload size in RPC preamble: %s", payloadLength);
            byte[] packetBytes = new byte[payloadLength];
            int packetBytesRead = this.topInputStream.read(packetBytes, 0, payloadLength);
            P4JavaExceptions.throwConnectionExceptionIfConditionFails(packetBytesRead > 0, "Perforce server network connection closed unexpectedly", new Object[0]);
            streamRecvs.incrementAndGet();
            this.stats.totalBytesRecv.getAndAdd(packetBytesRead);
            packetBytesRead = this.continueReadIfIncompleteRead(streamRecvs, payloadLength, packetBytes, packetBytesRead);
            P4JavaExceptions.throwP4JavaErrorIfConditionFails(packetBytesRead == payloadLength, "RPC packet payload read size mismatch; expected: %s; got: %s", payloadLength, packetBytesRead);
            packet = RpcPacket.constructRpcPacket(preamble, packetBytes, this.unicodeServer, this.p4Charset.getCharset(), fieldRule, filterCallback);
            this.stats.packetsRecv.incrementAndGet();
            this.stats.largestRpcPacketRecv.set(Math.max(this.stats.largestRpcPacketRecv.get(), (long)packet.getPacketLength()));
        }
        catch (IOException exc) {
            P4JavaExceptions.throwConnectionException(exc);
        }
        catch (ConnectionException | P4JavaError p4jexc) {
            throw p4jexc;
        }
        catch (Throwable thr) {
            Log.error("Unexpected exception: %s", thr.getLocalizedMessage());
            Log.exception(thr);
            P4JavaExceptions.throwP4JavaError(thr, thr.getLocalizedMessage(), new Object[0]);
        }
        return packet;
    }

    private int continueReadIfGetPartialRead(@Nonnull byte[] preambleBytes, int bytesRead, @Nonnull AtomicLong streamRecvs) throws IOException, ConnectionException {
        int totalBytesRead;
        int moreBytesRead;
        for (totalBytesRead = bytesRead; totalBytesRead >= 0 && totalBytesRead < preambleBytes.length; totalBytesRead += moreBytesRead) {
            moreBytesRead = this.topInputStream.read(preambleBytes, totalBytesRead, preambleBytes.length - totalBytesRead);
            P4JavaExceptions.throwConnectionExceptionIfConditionFails(moreBytesRead >= 0, "server connection unexpectedly closed", new Object[0]);
            streamRecvs.incrementAndGet();
        }
        return totalBytesRead;
    }

    private int continueReadIfIncompleteRead(@Nonnull AtomicLong streamRecvs, int payloadLength, @Nonnull byte[] packetBytes, int packetBytesRead) throws IOException, ConnectionException {
        int totalPacketBytesRead;
        int moreBytesRead;
        for (totalPacketBytesRead = packetBytesRead; totalPacketBytesRead < payloadLength; totalPacketBytesRead += moreBytesRead) {
            this.stats.incompleteReads.incrementAndGet();
            moreBytesRead = this.topInputStream.read(packetBytes, totalPacketBytesRead, payloadLength - totalPacketBytesRead);
            P4JavaExceptions.throwConnectionExceptionIfConditionFails(moreBytesRead >= 0, "Perforce server network connection closed unexpectedly", new Object[0]);
            streamRecvs.incrementAndGet();
            this.stats.totalBytesRecv.getAndAdd(moreBytesRead);
        }
        return totalPacketBytesRead;
    }

    @Override
    public int getSystemRecvBufferSize() {
        if (ObjectUtils.nonNull(this.socket)) {
            try {
                return this.socket.getReceiveBufferSize();
            }
            catch (SocketException exc) {
                Log.error("unexpected exception: %s", exc.getLocalizedMessage());
                Log.exception(exc);
            }
        }
        return 0;
    }

    @Override
    public int getSystemSendBufferSize() {
        if (ObjectUtils.nonNull(this.socket)) {
            try {
                return this.socket.getSendBufferSize();
            }
            catch (SocketException exc) {
                Log.error("unexpected exception: %s", exc.getLocalizedMessage());
                Log.exception(exc);
            }
        }
        return 0;
    }

    @Override
    public long putRpcPackets(@Nonnull RpcPacket[] packets) throws ConnectionException {
        Validate.notNull((Object)packets);
        int retVal = 0;
        for (RpcPacket packet : packets) {
            if (!ObjectUtils.nonNull(packet)) continue;
            retVal = (int)((long)retVal + this.putRpcPacket(packet));
        }
        return retVal;
    }

    @Override
    public long putRpcPacket(@Nonnull RpcPacket packet) throws ConnectionException {
        Validate.notNull((Object)packet);
        P4JavaExceptions.throwP4JavaErrorIfConditionFails(ObjectUtils.nonNull(packet.getFuncNameString()), "Unmapped / unmappable function in RpcPacket.put()", new Object[0]);
        int startPos = 5;
        RpcPacketSupplier supplier = new RpcPacketSupplier();
        supplier.sendBytes(new byte[2048]).sendPos(startPos);
        this.processNameArgs(packet, supplier);
        this.processStringArgs(packet, supplier);
        this.processExternalEnv(packet, supplier);
        this.processFuncName(packet, supplier);
        this.calculatePreambleBytesAndSendtoDownstream(supplier);
        return 0L;
    }

    private void processNameArgs(@Nonnull RpcPacket packet, @Nonnull RpcPacketSupplier argsSupplier) {
        Map<String, Object> mapArgs = packet.getMapArgs();
        if (ObjectUtils.nonNull(mapArgs)) {
            for (Map.Entry<String, Object> entry : mapArgs.entrySet()) {
                this.reallocateSendBufferInPutPacketIfRunOut(argsSupplier, this.marshalPacketField(entry.getKey(), entry.getValue()), 1024);
            }
        }
    }

    private void reallocateSendBufferInPutPacketIfRunOut(@Nonnull RpcPacketSupplier supplier, @Nonnull byte[] fieldBytes, int reallocateIncrement) {
        byte[] sendBytes = supplier.sendBytes();
        int sendPos = supplier.sendPos();
        byte[] newSendBytes = sendBytes;
        if (sendBytes.length - sendPos <= fieldBytes.length) {
            this.stats.bufferCompacts.getAndIncrement();
            int newBytesLength = sendBytes.length + fieldBytes.length + reallocateIncrement;
            newSendBytes = new byte[newBytesLength];
            System.arraycopy(sendBytes, 0, newSendBytes, 0, sendPos);
        }
        System.arraycopy(fieldBytes, 0, newSendBytes, sendPos, fieldBytes.length);
        supplier.sendBytes(newSendBytes).sendPos(sendPos + fieldBytes.length);
    }

    private void processStringArgs(@Nonnull RpcPacket packet, @Nonnull RpcPacketSupplier argsSupplier) {
        String[] strArgs = packet.getStrArgs();
        if (ObjectUtils.nonNull(strArgs)) {
            for (String arg : strArgs) {
                if (!StringUtils.isNotBlank((CharSequence)arg)) continue;
                this.reallocateSendBufferInPutPacketIfRunOut(argsSupplier, this.marshalPacketField(null, arg), 1024);
            }
        }
    }

    private void processExternalEnv(@Nonnull RpcPacket packet, @Nonnull RpcPacketSupplier argsSupplier) {
        ExternalEnv externalEnv = packet.getEnv();
        if (ObjectUtils.nonNull(externalEnv)) {
            this.reallocateSendBufferInPutPacketIfRunOut(argsSupplier, externalEnv.marshal(), 1024);
        }
    }

    private void processFuncName(@Nonnull RpcPacket packet, @Nonnull RpcPacketSupplier supplier) {
        byte[] nameBytes = this.marshalPacketField("func", packet.getFuncNameString());
        this.reallocateSendBufferInPutPacketIfRunOut(supplier, nameBytes, nameBytes.length);
    }

    private void calculatePreambleBytesAndSendtoDownstream(@Nonnull RpcPacketSupplier argsSupplier) throws ConnectionException {
        byte[] sendBytes = argsSupplier.sendBytes();
        int sendPos = argsSupplier.sendPos();
        byte[] preambleBytes = RpcPacketPreamble.constructPreamble(sendPos - 5).marshalAsBytes();
        System.arraycopy(preambleBytes, 0, sendBytes, 0, preambleBytes.length);
        try {
            this.topOutputStream.write(sendBytes, 0, sendPos);
            this.topOutputStream.flush();
            this.stats.streamSends.incrementAndGet();
            this.stats.totalBytesSent.getAndAdd(sendPos);
            this.stats.packetsSent.incrementAndGet();
            if (this.stats.largestRpcPacketSent.get() < (long)sendPos) {
                this.stats.largestRpcPacketSent.set(sendPos);
            }
        }
        catch (IOException exc) {
            Log.exception(exc);
            StringBuilder message = new StringBuilder();
            if (exc instanceof SocketTimeoutException && this.secure) {
                message.append(MessageFormat.format("SSL connect to ssl:{0}:{1,number,#} failed.\nRemove SSL protocol prefix.\n", this.hostName, this.hostPort));
            } else {
                message.append("Unable to send command to Perforce server: ");
            }
            message.append(exc.getMessage());
            P4JavaExceptions.throwConnectionException(exc, message.toString(), new Object[0]);
        }
    }

    @Override
    public void useConnectionCompression() throws ConnectionException {
        if (!this.usingCompression) {
            super.useConnectionCompression();
            try {
                this.topOutputStream.flush();
                this.putRpcPacket(RpcPacket.constructRpcPacket(RpcFunctionSpec.PROTOCOL_COMPRESS2, "compress2", null, null));
                this.topOutputStream.flush();
                this.topOutputStream = new RpcGZIPOutputStream(this.outputStream);
                this.topInputStream = new RpcGZIPInputStream(this.inputStream);
            }
            catch (IOException exc) {
                Log.error("I/O exception encountered while setting up GZIP streaming: %s", exc.getLocalizedMessage());
                Log.exception(exc);
                P4JavaExceptions.throwConnectionException(exc, "unable to set up client compression streaming to Perforce server: %s", exc.getLocalizedMessage());
            }
        }
    }

    RpcStreamConnection rsh(String rsh) {
        this.rsh = rsh;
        return this;
    }

    RpcStreamConnection socket(Socket socket) {
        this.socket = socket;
        return this;
    }

    RpcStreamConnection topInputStream(InputStream topInputStream) {
        this.topInputStream = topInputStream;
        return this;
    }

    RpcStreamConnection topOutputStream(OutputStream topOutputStream) {
        this.topOutputStream = topOutputStream;
        return this;
    }

    static class RpcPacketSupplier {
        private byte[] sendBytes = new byte[2048];
        private int sendPos = 0;

        RpcPacketSupplier() {
        }

        RpcPacketSupplier sendBytes(byte[] sendBytes) {
            this.sendBytes = sendBytes;
            return this;
        }

        RpcPacketSupplier sendPos(int sendPos) {
            this.sendPos = sendPos;
            return this;
        }

        byte[] sendBytes() {
            return this.sendBytes;
        }

        int sendPos() {
            return this.sendPos;
        }
    }
}

