/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.impl.mapbased.rpc.func.client;

import com.perforce.p4java.Log;
import com.perforce.p4java.exception.NullPointerError;

public class ClientMessage {
    private static ClientMessage[] messages = new ClientMessage[]{new ClientMessage(ClientMessageId.UNKNOWN, 0, "Unknown client error.", null), new ClientMessage(ClientMessageId.CONNECT_FAILED, 1, "Connect to server failed; check server URI host and port specs.", null), new ClientMessage(ClientMessageId.FATAL_CLIENT_ERROR, 2, "Fatal client error; disconnecting!", null), new ClientMessage(ClientMessageId.CANT_CLOBBER, 4, "Can't clobber writable file %file%", new String[]{"file"}), new ClientMessage(ClientMessageId.CANT_CREATE_DIR, 5, "can't create directory for %file%", new String[]{"file"}), new ClientMessage(ClientMessageId.CANT_EDIT_FILE_TYPE, 7, "%type% - can't edit this type of file!", new String[]{"type"}), new ClientMessage(ClientMessageId.OUT_OF_RESOURCES, 14, "Out of memory, network, or system resources", null), new ClientMessage(ClientMessageId.ASSUMING_FILE_TYPE, 30, "%file% - %type%, assuming %type2%.", new String[]{"file", "type", "type2"}), new ClientMessage(ClientMessageId.SUBSTITUTING_FILE_TYPE, 31, "%file% - using %type% instead of %type2%", new String[]{"file", "type", "type2"}), new ClientMessage(ClientMessageId.CANT_ADD_FILE_TYPE, 32, "%file% - %type% file can't be added.", new String[]{"file", "type"}), new ClientMessage(ClientMessageId.CANT_OVERWRITE_FILE, 34, "%file% - can't overwrite existing file.", new String[]{"file"}), new ClientMessage(ClientMessageId.FILE_NONEXISTENT, 35, "%file% - file does not exist.", new String[]{"file"}), new ClientMessage(ClientMessageId.FILE_SEND_ERROR, 0, "%file% - missing on client, assuming type %type%.", new String[]{"file", "type"}), new ClientMessage(ClientMessageId.CANT_DELETE_FILE, 0, "operating system will not allow deletion of file %file% on client.", new String[]{"file"}), new ClientMessage(ClientMessageId.CANT_CREATE_FILE, 0, "operating system will not allow creation of file %file% on client: %reason%.", new String[]{"file", "reason"}), new ClientMessage(ClientMessageId.CANT_CREATE_FILE_TYPE, 0, "%type% file %file% can't be sync'd or created with this client program.", new String[]{"type", "file"}), new ClientMessage(ClientMessageId.FILE_WRITE_ERROR, 0, "file %file% operating system write error: %reason%.", new String[]{"file", "reason"}), new ClientMessage(ClientMessageId.FILE_SEND_ERROR, 0, "file send error for %file%: %reason%", new String[]{"file", "reason"}), new ClientMessage(ClientMessageId.FILE_MOVE_ERROR, 0, "file move error for %file%: %reason%", new String[]{"file", "reason"}), new ClientMessage(ClientMessageId.MERGE_MESSAGE3, 20, "Diff chunks: %yours% yours + %theirs% theirs + %both% both + %conflicting% conflicting", new String[]{"yours", "theirs", "both", "conflicting"}), new ClientMessage(ClientMessageId.OS_FILE_READ_ERROR, 0, "%context%: %osmsg%", new String[]{"context", "osmsg"}), new ClientMessage(ClientMessageId.CANT_CHMOD_FILE, 0, "can't change mode of file %file%: file does not exist locally", new String[]{"file"}), new ClientMessage(ClientMessageId.DIGEST_MISMATCH, 37, "%clientFile% corrupted during transfer (or bad on the server) %clientDigest% vs %serverDigest%", new String[]{"clientFile", "clientDigest", "serverDigest"}), new ClientMessage(ClientMessageId.FILE_OPEN_ERROR, 40, "Error opening file.", new String[0]), new ClientMessage(ClientMessageId.FILE_DECODER_ERROR, 0, "%file% - decoding error.", new String[]{"file"}), new ClientMessage(ClientMessageId.NO_MODIFIED_FILE, 0, "Can't %action% modified file %file%", new String[]{"action", "file"})};
    private ClientMessageId id = ClientMessageId.UNKNOWN;
    private int code = 0;
    private String[] msgs = null;
    private String[] msgParamNames = null;

    public static ClientMessage getClientMessage(ClientMessageId id) {
        if (id == null) {
            throw new NullPointerError("Null error ID spec passed to ClientMessage.getClientMessage()");
        }
        for (ClientMessage msg : messages) {
            if (msg.getId() != id) continue;
            return msg;
        }
        Log.warn("Unmatched error ID spec in ClientMessage.getClientMessage()", new Object[0]);
        return messages[0];
    }

    private ClientMessage(ClientMessageId id, int code, String msg, String[] msgParamNames) {
        this.id = id;
        this.code = code;
        this.msgs = new String[]{msg};
        this.msgParamNames = msgParamNames;
    }

    public ClientMessageId getId() {
        return this.id;
    }

    public void setId(ClientMessageId id) {
        this.id = id;
    }

    public String[] getMsgs() {
        return this.msgs;
    }

    public void setMsgs(String[] msgs) {
        this.msgs = msgs;
    }

    public String[] getMsgParamNames() {
        return this.msgParamNames;
    }

    public void setMsgParamNames(String[] msgParamNames) {
        this.msgParamNames = msgParamNames;
    }

    public int getCode() {
        return this.code;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public static enum ClientMessageId {
        UNKNOWN,
        CONNECT_FAILED,
        FATAL_CLIENT_ERROR,
        CANT_CLOBBER,
        CANT_CREATE_DIR,
        CANT_EDIT_FILE_TYPE,
        OUT_OF_RESOURCES,
        ASSUMING_FILE_TYPE,
        SUBSTITUTING_FILE_TYPE,
        CANT_ADD_FILE_TYPE,
        CANT_OVERWRITE_FILE,
        CANT_DELETE_FILE,
        CANT_CREATE_FILE,
        CANT_CREATE_FILE_TYPE,
        FILE_WRITE_ERROR,
        FILE_NONEXISTENT,
        FILE_MISSING_ASSUMING_TYPE,
        FILE_SEND_ERROR,
        FILE_MOVE_ERROR,
        MERGE_MESSAGE3,
        OS_FILE_READ_ERROR,
        CANT_CHMOD_FILE,
        DIGEST_MISMATCH,
        FILE_OPEN_ERROR,
        FILE_DECODER_ERROR,
        FILE_ENCODER_ERROR,
        NO_MODIFIED_FILE;

    }

    public static enum ClientMessageType {
        UNKNOWN,
        USAGE,
        CONNECTION,
        CLIENT,
        SERVER;

    }
}

