/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.common.base;

import com.perforce.p4java.common.base.StringHelper;
import com.perforce.p4java.common.function.Function;
import com.perforce.p4java.common.function.FunctionWithException;
import com.perforce.p4java.exception.AccessException;
import com.perforce.p4java.exception.ConnectionException;
import com.perforce.p4java.exception.OptionsException;
import com.perforce.p4java.exception.P4JavaError;
import com.perforce.p4java.exception.P4JavaException;
import com.perforce.p4java.exception.ProtocolError;
import com.perforce.p4java.exception.RequestException;
import java.io.IOException;

public final class P4JavaExceptions {
    private P4JavaExceptions() {
    }

    public static void throwConnectionExceptionIfConditionFails(boolean expression, String message, Object ... args) throws ConnectionException {
        if (!expression) {
            String exceptionMessage = StringHelper.format(message, args);
            throw new ConnectionException(exceptionMessage);
        }
    }

    public static void throwConnectionException(String message, Object ... args) throws ConnectionException {
        String exceptionMessage = StringHelper.format(message, args);
        throw new ConnectionException(exceptionMessage);
    }

    public static void throwConnectionException(Throwable cause) throws ConnectionException {
        throw new ConnectionException(cause);
    }

    public static void throwConnectionException(Throwable cause, String message, Object ... args) throws ConnectionException {
        String exceptionMessage = StringHelper.format(message, args);
        throw new ConnectionException(exceptionMessage, cause);
    }

    public static void throwProtocolErrorIfConditionFails(boolean expression, String message, Object ... args) throws ProtocolError {
        if (!expression) {
            String exceptionMessage = StringHelper.format(message, args);
            throw new ProtocolError(exceptionMessage);
        }
    }

    public static void throwP4JavaErrorIfConditionFails(boolean expression, String message, Object ... args) throws P4JavaError {
        if (!expression) {
            String exceptionMessage = StringHelper.format(message, args);
            throw new P4JavaError(exceptionMessage);
        }
    }

    public static void throwP4JavaError(Throwable cause, String message, Object ... args) throws P4JavaError {
        String exceptionMessage = StringHelper.format(message, args);
        throw new P4JavaError(exceptionMessage, cause);
    }

    public static void throwP4JavaError(String message, Object ... args) throws P4JavaError {
        String exceptionMessage = StringHelper.format(message, args);
        throw new P4JavaError(exceptionMessage);
    }

    public static void throwOptionsExceptionIfConditionFails(boolean expression, String message, Object ... args) throws OptionsException {
        if (!expression) {
            String exceptionMessage = StringHelper.format(message, args);
            throw new OptionsException(exceptionMessage);
        }
    }

    public static void throwOptionsException(Throwable cause, String message, Object ... args) throws OptionsException {
        String exceptionMessage = StringHelper.format(message, args);
        throw new OptionsException(exceptionMessage, cause);
    }

    public static void throwOptionsException(Throwable cause) throws OptionsException {
        throw new OptionsException(cause);
    }

    public static void throwOptionsException(String message, Object ... args) throws OptionsException {
        String exceptionMessage = StringHelper.format(message, args);
        throw new OptionsException(exceptionMessage);
    }

    public static void throwRequestExceptionIfConditionFails(boolean expression, String codeString, String message, Object ... args) throws RequestException {
        if (!expression) {
            String exceptionMessage = StringHelper.format(message, args);
            throw new RequestException(exceptionMessage, codeString);
        }
    }

    public static void throwRequestExceptionIfConditionFails(boolean expression, String message, Object ... args) throws RequestException {
        if (!expression) {
            String exceptionMessage = StringHelper.format(message, args);
            throw new RequestException(exceptionMessage);
        }
    }

    public static void throwRequestExceptionIfPerforceServerVersionOldThanExpected(boolean expression, String message, Object ... args) throws RequestException {
        if (!expression) {
            String exceptionMessage = StringHelper.format(message, args);
            throw new RequestException(exceptionMessage, 37, 3);
        }
    }

    public static void throwAccessExceptionIfConditionFails(boolean expression, String message, Object ... args) throws AccessException {
        if (!expression) {
            String exceptionMessage = StringHelper.format(message, args);
            throw new AccessException(exceptionMessage);
        }
    }

    public static void throwIOException(Throwable cause) throws IOException {
        throw new IOException(cause);
    }

    public static void throwIOException(Throwable cause, String message, Object ... args) throws IOException {
        String exceptionMessage = StringHelper.format(message, args);
        throw new IOException(exceptionMessage, cause);
    }

    public static void throwIOException(String message, Object ... args) throws IOException {
        String exceptionMessage = StringHelper.format(message, args);
        throw new IOException(exceptionMessage);
    }

    public static void throwIOExceptionIfConditionFails(boolean expression, String message, Object ... args) throws IOException {
        if (!expression) {
            String exceptionMessage = StringHelper.format(message, args);
            throw new IOException(exceptionMessage);
        }
    }

    public static <T, R> Function<T, R> rethrowFunction(final FunctionWithException<T, R> function) {
        return new Function<T, R>(){

            @Override
            public R apply(T t) throws RequestException {
                try {
                    return function.apply(t);
                }
                catch (P4JavaException e) {
                    throw new RequestException(e);
                }
            }
        };
    }
}

