/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.impl.mapbased.rpc.sys.helper;

import com.perforce.p4java.Log;
import com.perforce.p4java.common.base.ObjectUtils;
import com.perforce.p4java.impl.generic.sys.ISystemFileCommandsHelper;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;

public abstract class SymbolicLinkHelper
implements ISystemFileCommandsHelper {
    public static boolean isSymbolicLinkCapable() {
        return true;
    }

    public static boolean isSymbolicLink(String path) {
        if (ObjectUtils.nonNull(path)) {
            try {
                Path filePath = Paths.get(path, new String[0]);
                if (ObjectUtils.nonNull(filePath)) {
                    return Files.isSymbolicLink(filePath);
                }
            }
            catch (Throwable thr) {
                Log.exception(thr);
            }
        }
        return false;
    }

    public static String readSymbolicLink(String link) {
        if (ObjectUtils.nonNull(link)) {
            try {
                Path pathObject;
                Path linkPath = Paths.get(link, new String[0]);
                if (ObjectUtils.nonNull(linkPath) && ObjectUtils.nonNull(pathObject = Files.readSymbolicLink(linkPath))) {
                    return pathObject.toString();
                }
            }
            catch (Throwable thr) {
                Log.error("Unexpected exception invoking method: %s", thr.getLocalizedMessage());
                Log.exception(thr);
            }
        }
        return null;
    }

    public static long getLastModifiedTime(String link) {
        if (ObjectUtils.nonNull(link)) {
            try {
                FileTime fileTimeObject;
                Path linkPath = Paths.get(link, new String[0]);
                if (ObjectUtils.nonNull(linkPath) && ObjectUtils.nonNull(fileTimeObject = Files.getLastModifiedTime(linkPath, LinkOption.NOFOLLOW_LINKS))) {
                    return fileTimeObject.toMillis();
                }
            }
            catch (Throwable thr) {
                Log.error("Unexpected exception invoking method: %s", thr.getLocalizedMessage());
                Log.exception(thr);
            }
        }
        return 0L;
    }

    public static boolean exists(String path) {
        if (ObjectUtils.nonNull(path)) {
            try {
                Path filePath = Paths.get(path, new String[0]);
                if (ObjectUtils.nonNull(filePath)) {
                    return Files.exists(filePath, LinkOption.NOFOLLOW_LINKS);
                }
            }
            catch (Throwable thr) {
                Log.error("Unexpected exception invoking method: %s", thr.getLocalizedMessage());
                Log.exception(thr);
            }
        }
        return false;
    }

    public static String move(String source, String target) {
        return SymbolicLinkHelper.createSymbolicLink(source, target);
    }

    public static String createSymbolicLink(String link, String target) {
        if (StringUtils.isNotBlank((CharSequence)link) && StringUtils.isNotBlank((CharSequence)target)) {
            try {
                Path linkPath = Paths.get(link, new String[0]);
                Path targetPath = Paths.get(target, new String[0]);
                if (ObjectUtils.nonNull(linkPath) && ObjectUtils.nonNull(targetPath)) {
                    SymbolicLinkHelper.createParentDirsIfNotExist(linkPath);
                    Path pathObject = Files.createSymbolicLink(linkPath, targetPath, new FileAttribute[0]);
                    return pathObject.toString();
                }
            }
            catch (Throwable thr) {
                thr.printStackTrace();
                Log.error("Unexpected exception invoking method: %s", thr.getLocalizedMessage());
                Log.exception(thr);
            }
        }
        return null;
    }

    private static void createParentDirsIfNotExist(@Nonnull Path filePath) throws IOException {
        Path parent = filePath.getParent();
        if (Files.notExists(parent, new LinkOption[0])) {
            Files.createDirectories(parent, new FileAttribute[0]);
        }
    }
}

