/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.impl.mapbased.rpc.func.client;

import com.perforce.p4java.CharsetConverter;
import com.perforce.p4java.CharsetDefs;
import com.perforce.p4java.Log;
import com.perforce.p4java.core.IMapEntry;
import com.perforce.p4java.core.ViewMap;
import com.perforce.p4java.exception.ClientError;
import com.perforce.p4java.exception.ConnectionException;
import com.perforce.p4java.exception.FileDecoderException;
import com.perforce.p4java.exception.FileEncoderException;
import com.perforce.p4java.exception.NullPointerError;
import com.perforce.p4java.exception.P4JavaError;
import com.perforce.p4java.exception.ProtocolError;
import com.perforce.p4java.impl.generic.client.ClientLineEnding;
import com.perforce.p4java.impl.generic.core.MapEntry;
import com.perforce.p4java.impl.generic.sys.ISystemFileCommandsHelper;
import com.perforce.p4java.impl.mapbased.rpc.CommandEnv;
import com.perforce.p4java.impl.mapbased.rpc.RpcPropertyDefs;
import com.perforce.p4java.impl.mapbased.rpc.RpcServer;
import com.perforce.p4java.impl.mapbased.rpc.connection.RpcConnection;
import com.perforce.p4java.impl.mapbased.rpc.func.RpcFunctionSpec;
import com.perforce.p4java.impl.mapbased.rpc.func.client.ClientHelper;
import com.perforce.p4java.impl.mapbased.rpc.func.client.ClientIgnoreChecker;
import com.perforce.p4java.impl.mapbased.rpc.func.client.ClientMessage;
import com.perforce.p4java.impl.mapbased.rpc.func.helper.MD5Digester;
import com.perforce.p4java.impl.mapbased.rpc.msg.RpcMessage;
import com.perforce.p4java.impl.mapbased.rpc.packet.RpcPacket;
import com.perforce.p4java.impl.mapbased.rpc.packet.RpcPacketDispatcher;
import com.perforce.p4java.impl.mapbased.rpc.sys.RpcOutputStream;
import com.perforce.p4java.impl.mapbased.rpc.sys.RpcPerforceFile;
import com.perforce.p4java.impl.mapbased.rpc.sys.RpcPerforceFileType;
import com.perforce.p4java.impl.mapbased.rpc.sys.helper.AppleFileHelper;
import com.perforce.p4java.impl.mapbased.rpc.sys.helper.SymbolicLinkHelper;
import com.perforce.p4java.impl.mapbased.rpc.sys.helper.SysFileHelperBridge;
import com.perforce.p4java.util.FilesHelper;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class ClientSystemFileCommands {
    public static final String TRACE_PREFIX = "ClientSystemFileCommands";
    public static final String DEFAULT_TMPFILE_PFX = "p4j";
    public static final String DEFAULT_TMPFILE_SFX = ".p4j";
    public static final String SYSTEM_TMPDIR_PROPS_KEY = "java.io.tmpdir";
    public static final String SYSTEM_TMPDIR_DEFAULT = "/tmp";
    public static final String PERMS_RW = "rw";
    protected static final String FILE_DELETE_ON_ERR_KEY = "deleteOnError";
    protected static final String FILE_OPEN_PATH_KEY = "openFilePath";
    protected static final String FILE_OPEN_TARGET_FILE_KEY = "targetFile";
    protected static final String FILE_OPEN_TMP_FILE_KEY = "tmpFile";
    protected static final String FILE_OPEN_TMP_STREAM_KEY = "tmpFileStream";
    protected static final String FILE_OPEN_TARGET_STREAM_KEY = "targetFileStream";
    protected static final String FILE_OPEN_ORIG_ARGS_KEY = "origArgs";
    protected static final String FILE_OPEN_MODTIME_KEY = "modTime";
    protected static final String FILE_OPEN_IS_SYMBOLIC_LINK_KEY = "isSymbolicLink";
    protected static final String RECONCILE_HANDLER_SKIP_ADD_KEY = "skipAdd";
    private String reconcileHandle = null;
    private Properties props = null;
    private RpcServer server = null;
    private ClientIgnoreChecker checker = null;
    private String tmpDirName = null;
    private ISystemFileCommandsHelper fileCommands = SysFileHelperBridge.getSysFileCommands();
    private String filePath = null;
    private long fileSize = 0L;
    private long currentSize = 0L;

    protected ClientSystemFileCommands(Properties props, RpcServer server) {
        this.props = props;
        this.server = server;
        this.tmpDirName = RpcPropertyDefs.getProperty(this.props, "com.perforce.p4java.tmpDir", System.getProperty(SYSTEM_TMPDIR_PROPS_KEY));
        if (this.tmpDirName == null) {
            this.tmpDirName = SYSTEM_TMPDIR_DEFAULT;
            Log.warn("Unable to get tmp name from P4 props or System; using " + this.tmpDirName + " instead", new Object[0]);
        }
    }

    protected RpcPacketDispatcher.RpcPacketDispatcherResult chmodFile(RpcConnection rpcConnection, CommandEnv cmdEnv, Map<String, Object> resultsMap) throws ConnectionException {
        if (rpcConnection == null) {
            throw new NullPointerError("Null rpcConnection in chmodFile().");
        }
        if (cmdEnv == null) {
            throw new NullPointerError("Null cmdEnv in chmodFile().");
        }
        if (resultsMap == null) {
            throw new NullPointerError("Null resultsMap in chmodFile().");
        }
        String path = (String)resultsMap.get("path");
        String perms = (String)resultsMap.get("perms");
        String fileTypeStr = (String)resultsMap.get("type");
        String time = (String)resultsMap.get("time");
        RpcPerforceFileType fileType = RpcPerforceFileType.decodeFromServerString(fileTypeStr);
        boolean fstSymlink = fileType == RpcPerforceFileType.FST_SYMLINK;
        try {
            cmdEnv.newHandler();
            RpcPerforceFile targetFile = new RpcPerforceFile(path, fileTypeStr);
            if (this.fileExists(targetFile, fstSymlink)) {
                if (time != null) {
                    targetFile.setLastModified(new Long(time));
                }
                if (perms != null) {
                    if (perms.equalsIgnoreCase(PERMS_RW)) {
                        this.fileCommands.setWritable(path, true);
                    } else {
                        this.fileCommands.setWritable(path, false);
                    }
                }
                switch (fileType) {
                    case FST_XTEXT: 
                    case FST_XBINARY: {
                        this.fileCommands.setExecutable(path, true, true);
                        break;
                    }
                }
            } else {
                cmdEnv.handleResult(new RpcMessage(ClientMessage.ClientMessageId.CANT_CHMOD_FILE, 1, 34, new String[]{path}).toMap());
            }
        }
        catch (NumberFormatException nfe) {
            throw new ProtocolError("Unexpected conversion error in ClientSystemFileCommands.chmodFile: " + nfe.getLocalizedMessage());
        }
        catch (Exception exc) {
            Log.exception(exc);
            throw new ConnectionException(exc.getLocalizedMessage(), exc);
        }
        return RpcPacketDispatcher.RpcPacketDispatcherResult.CONTINUE_LOOP;
    }

    /*
     * Unable to fully structure code
     */
    protected RpcPacketDispatcher.RpcPacketDispatcherResult openFile(RpcConnection rpcConnection, CommandEnv cmdEnv, Map<String, Object> resultsMap) throws ConnectionException {
        if (rpcConnection == null) {
            throw new NullPointerError("Null rpcConnection in openFile().");
        }
        if (cmdEnv == null) {
            throw new NullPointerError("Null cmdEnv in openFile().");
        }
        if (resultsMap == null) {
            throw new NullPointerError("Null resultsMap in openFile().");
        }
        path = (String)resultsMap.get("path");
        clientHandle = (String)resultsMap.get("handle");
        modTime = (String)resultsMap.get("time");
        noClobber = (String)resultsMap.get("noclobber");
        perms = (String)resultsMap.get("perms");
        fileTypeStr = (String)resultsMap.get("type");
        fileSizeStr = (String)resultsMap.get("fileSize");
        digest = (String)resultsMap.get("digest");
        useLocalDigester = this.useLocalDigester(digest, cmdEnv);
        this.filePath = path != null ? path : null;
        this.fileSize = fileSizeStr != null ? new Long(fileSizeStr) : 0L;
        this.currentSize = 0L;
        fileType = RpcPerforceFileType.decodeFromServerString(fileTypeStr);
        fstSymlink = fileType == RpcPerforceFileType.FST_SYMLINK;
        try {
            targetFile = new RpcPerforceFile(path, fileTypeStr);
            tmpFile = null;
            handler = cmdEnv.getHandler(clientHandle);
            if (handler == null) {
                v0 = cmdEnv;
                v0.getClass();
                handler = new CommandEnv.RpcHandler(v0, clientHandle, false, targetFile);
                cmdEnv.addHandler(handler);
            } else {
                handler.getMap().remove("tmpFile");
                handler.getMap().remove("tmpFileStream");
                handler.getMap().remove("modTime");
                handler.getMap().remove("isSymbolicLink");
            }
            handler.setError(false);
            handler.getMap().put("origArgs", resultsMap);
            handler.getMap().put("modTime", modTime);
            if (targetFile.exists() && targetFile.isFile() && noClobber != null && targetFile.canWrite()) {
                handler.setError(true);
                cmdEnv.handleResult(new RpcMessage(ClientMessage.ClientMessageId.CANT_CLOBBER, 3, 34, new String[]{path}).toMap());
                return RpcPacketDispatcher.RpcPacketDispatcherResult.CONTINUE_LOOP;
            }
            if (fstSymlink) {
                if (!SymbolicLinkHelper.isSymbolicLinkCapable()) {
                    handler.setError(true);
                    cmdEnv.handleResult(new RpcMessage(ClientMessage.ClientMessageId.CANT_CREATE_FILE_TYPE, 3, 34, new String[]{"symlink", path}).toMap());
                    return RpcPacketDispatcher.RpcPacketDispatcherResult.CONTINUE_LOOP;
                }
                handler.getMap().put("isSymbolicLink", true);
                if (this.fileExists(targetFile, fstSymlink)) {
                    targetFile.delete();
                } else if (!FilesHelper.mkdirs(targetFile)) {
                    handler.setError(true);
                    cmdEnv.handleResult(new RpcMessage(ClientMessage.ClientMessageId.CANT_CREATE_DIR, 3, 34, new String[]{path}).toMap());
                    return RpcPacketDispatcher.RpcPacketDispatcherResult.CONTINUE_LOOP;
                }
                return RpcPacketDispatcher.RpcPacketDispatcherResult.CONTINUE_LOOP;
            }
            if (targetFile.exists() && targetFile.isFile() && !cmdEnv.isSyncInPlace()) {
                tmpFileName = RpcPerforceFile.createTempFileName(targetFile.getParent());
                tmpFile = new RpcPerforceFile(tmpFileName, fileTypeStr);
                handler.getMap().put("tmpFile", tmpFile);
                if (perms != null && perms.equalsIgnoreCase("rw")) {
                    this.fileCommands.setWritable(tmpFileName, true);
                }
            } else if (!targetFile.exists()) {
                targetFile.delete();
                if (!FilesHelper.mkdirs(targetFile)) {
                    handler.setError(true);
                    cmdEnv.handleResult(new RpcMessage(ClientMessage.ClientMessageId.CANT_CREATE_DIR, 3, 34, new String[]{path}).toMap());
                    return RpcPacketDispatcher.RpcPacketDispatcherResult.CONTINUE_LOOP;
                }
                try {
                    if (!targetFile.createNewFile()) {
                        Log.warn("ClientSystemFileCommands.openFile: unable to create new target file", new Object[0]);
                    }
                    if (targetFile.canCopyAsIs()) ** GOTO lbl98
                    tmpFileName = RpcPerforceFile.createTempFileName(this.tmpDirName);
                    tmpFile = new RpcPerforceFile(tmpFileName, fileTypeStr);
                    handler.getMap().put("tmpFile", tmpFile);
                }
                catch (IOException ioexc) {
                    handler.setError(true);
                    cmdEnv.handleResult(new RpcMessage(ClientMessage.ClientMessageId.CANT_CREATE_FILE, 3, 34, new String[]{path, ioexc.getLocalizedMessage()}).toMap());
                    return RpcPacketDispatcher.RpcPacketDispatcherResult.CONTINUE_LOOP;
                }
            } else if (targetFile.isFile()) {
                this.fileCommands.setWritable(path, true);
            }
lbl98:
            // 6 sources

            handler.getMap().put("targetFile", targetFile);
            if (perms != null && perms.equalsIgnoreCase("rw")) {
                this.fileCommands.setWritable(path, true);
            }
            if (fileType.isExecutable()) {
                this.fileCommands.setExecutable(path, true, true);
            }
            if (tmpFile != null) {
                tmpStream = new RpcOutputStream(tmpFile, rpcConnection.getClientCharset(), rpcConnection.isUnicodeServer(), useLocalDigester);
                if (useLocalDigester) {
                    tmpStream.setServerDigest(digest);
                }
                handler.getMap().put("tmpFileStream", tmpStream);
            } else if (targetFile != null) {
                targetStream = new RpcOutputStream(targetFile, rpcConnection.getClientCharset(), rpcConnection.isUnicodeServer(), useLocalDigester);
                if (useLocalDigester) {
                    targetStream.setServerDigest(digest);
                }
                handler.getMap().put("targetFileStream", targetStream);
            }
        }
        catch (P4JavaError p4je) {
            throw p4je;
        }
        catch (Exception exc) {
            Log.exception(exc);
            throw new P4JavaError("Unexpected exception in ClientSystemFileCommands.openFile: " + exc.getLocalizedMessage() + exc, exc);
        }
        return RpcPacketDispatcher.RpcPacketDispatcherResult.CONTINUE_LOOP;
    }

    protected RpcPacketDispatcher.RpcPacketDispatcherResult writeFile(RpcConnection rpcConnection, CommandEnv cmdEnv, Map<String, Object> resultsMap) throws ConnectionException {
        if (rpcConnection == null) {
            throw new NullPointerError("Null rpcConnection in writeFile().");
        }
        if (cmdEnv == null) {
            throw new NullPointerError("Null cmdEnv in writeFile().");
        }
        if (resultsMap == null) {
            throw new NullPointerError("Null resultsMap in writeFile().");
        }
        String clientHandle = (String)resultsMap.get("handle");
        CommandEnv.RpcHandler handler = cmdEnv.getHandler(clientHandle);
        Map<String, Object> stateMap = cmdEnv.getStateMap();
        if (handler == null) {
            throw new NullPointerError("Null client handler in writeFile().");
        }
        if (handler.isError()) {
            return RpcPacketDispatcher.RpcPacketDispatcherResult.CONTINUE_LOOP;
        }
        if (stateMap == null) {
            throw new NullPointerError("Null state map in ClientSystemFileCommands.writeFile().");
        }
        Map origArgs = (Map)handler.getMap().get(FILE_OPEN_ORIG_ARGS_KEY);
        if (origArgs == null) {
            throw new NullPointerError("Null original argument map ClientSystemFileCommands.writeFile() state map");
        }
        String path = (String)origArgs.get("path");
        if (handler.getMap().get(FILE_OPEN_IS_SYMBOLIC_LINK_KEY) != null && ((Boolean)handler.getMap().get(FILE_OPEN_IS_SYMBOLIC_LINK_KEY)).booleanValue() && path != null) {
            String link;
            this.convertFileDataMap(resultsMap, cmdEnv.getRpcConnection().getClientCharset(), cmdEnv.getRpcConnection().isUnicodeServer());
            String data = (String)resultsMap.get("data");
            if (data != null && (link = SymbolicLinkHelper.createSymbolicLink(path, data = data.replaceAll("(\\r|\\n)", ""))) == null) {
                handler.setError(true);
                cmdEnv.handleResult(new RpcMessage(ClientMessage.ClientMessageId.CANT_CREATE_FILE_TYPE, 3, 34, new String[]{"symlink", path}).toMap());
                return RpcPacketDispatcher.RpcPacketDispatcherResult.CONTINUE_LOOP;
            }
            return RpcPacketDispatcher.RpcPacketDispatcherResult.CONTINUE_LOOP;
        }
        RpcOutputStream outStream = (RpcOutputStream)handler.getMap().get(FILE_OPEN_TMP_STREAM_KEY);
        if (outStream == null) {
            outStream = (RpcOutputStream)handler.getMap().get(FILE_OPEN_TARGET_STREAM_KEY);
        }
        if (outStream == null) {
            throw new P4JavaError("No open file stream in ClientSystemFileCommands.writeFile()");
        }
        try {
            if (outStream.getFD() != null && outStream.getFD().valid()) {
                long bytesWritten = outStream.write(resultsMap);
                this.currentSize = ClientHelper.sendBackWrittenDataBytes(cmdEnv, this.filePath, this.fileSize, this.currentSize, bytesWritten);
            } else {
                Log.error("output stream unexpectedly closed in writeFile", new Object[0]);
                handler.setError(true);
            }
        }
        catch (Exception ioexc) {
            handler.setError(true);
            cmdEnv.handleResult(new RpcMessage(ClientMessage.ClientMessageId.FILE_WRITE_ERROR, 3, 34, new String[]{path == null ? "<unknown>" : path, ioexc.getLocalizedMessage()}).toMap());
            Log.error("failed write for file " + (path == null ? "<unknown>" : path) + "; exception follows...", new Object[0]);
            Log.exception(ioexc);
        }
        return RpcPacketDispatcher.RpcPacketDispatcherResult.CONTINUE_LOOP;
    }

    private void writeToStream(byte[] sourceBytes, int start, int length, OutputStream stream) throws IOException {
        if (ClientLineEnding.CONVERT_TEXT) {
            for (int i = start; i < length; ++i) {
                if (sourceBytes[i] == ClientLineEnding.FST_L_LF_BYTES[0]) {
                    stream.write(ClientLineEnding.FST_L_LOCAL_BYTES);
                    continue;
                }
                stream.write(sourceBytes[i]);
            }
        } else {
            stream.write(sourceBytes, start, length);
        }
    }

    private void translate(byte[] sourceBytes, CharsetConverter converter, int length, OutputStream stream) throws IOException, FileDecoderException, FileEncoderException {
        int start = 0;
        if (ClientLineEnding.CONVERT_TEXT) {
            ByteArrayOutputStream converted = new ByteArrayOutputStream();
            this.writeToStream(sourceBytes, start, length, converted);
            sourceBytes = converted.toByteArray();
            start = 0;
            length = sourceBytes.length;
        }
        ByteBuffer from = ByteBuffer.wrap(sourceBytes);
        if (length > 0) {
            ByteBuffer converted = converter.convert(from);
            if (converted != null) {
                sourceBytes = converted.array();
                start = converted.position();
                length = converted.limit();
            }
        } else {
            byte[] underflow = converter.clearUnderflow();
            if (underflow != null) {
                ByteBuffer converted = converter.convert(ByteBuffer.wrap(underflow));
                if (converted != null) {
                    sourceBytes = converted.array();
                    start = converted.position();
                    length = converted.limit();
                }
                if (converter.clearUnderflow() != null) {
                    throw new ClientError("Translation of text output failed to charset " + converter.getToCharsetName());
                }
            }
        }
        if (length > 0) {
            stream.write(sourceBytes, start, length);
        }
    }

    protected RpcPacketDispatcher.RpcPacketDispatcherResult writeText(RpcConnection rpcConnection, CommandEnv cmdEnv, Map<String, Object> resultsMap) throws ConnectionException {
        if (rpcConnection == null) {
            throw new NullPointerError("Null rpcConnection in writeText().");
        }
        if (cmdEnv == null) {
            throw new NullPointerError("Null cmdEnv in writeText().");
        }
        if (resultsMap == null) {
            throw new NullPointerError("Null resultsMap in writeText().");
        }
        String trans = (String)resultsMap.get("trans");
        if (trans != null && !trans.equalsIgnoreCase("no")) {
            throw new P4JavaError("trans arg not 'no' or null in writeText: " + trans);
        }
        String handlerName = "writeText";
        CommandEnv.RpcHandler handler = cmdEnv.getHandler("writeText");
        if (handler == null) {
            CommandEnv commandEnv = cmdEnv;
            commandEnv.getClass();
            handler = new CommandEnv.RpcHandler(commandEnv, "writeText", false, null);
            cmdEnv.addHandler(handler);
        }
        if (handler.isError()) {
            return RpcPacketDispatcher.RpcPacketDispatcherResult.CONTINUE_LOOP;
        }
        Map<String, Object> stateMap = cmdEnv.getStateMap();
        RpcOutputStream outStream = this.getTempOutputStream(cmdEnv);
        if (outStream == null) {
            throw new NullPointerError("Null output stream in writeText state map");
        }
        try {
            if (outStream.getFD() != null && outStream.getFD().valid()) {
                byte[] sourceBytes = (byte[])resultsMap.get("data");
                int len = sourceBytes.length;
                int start = 0;
                if (trans == null) {
                    CharsetConverter converter = (CharsetConverter)stateMap.get("RPC_TMP_CONVERTER_KEY");
                    if (converter == null) {
                        Charset charset = rpcConnection.getClientCharset();
                        for (Map<String, Object> map : cmdEnv.getResultMaps()) {
                            String type;
                            if (!map.containsKey("type") || !"utf16".equals(type = map.get("type").toString())) continue;
                            charset = CharsetDefs.UTF16;
                            break;
                        }
                        if (charset != CharsetDefs.UTF8) {
                            converter = new CharsetConverter(CharsetDefs.UTF8, charset);
                            stateMap.put("RPC_TMP_CONVERTER_KEY", converter);
                        }
                    }
                    if (converter != null) {
                        this.translate(sourceBytes, converter, len, outStream);
                    } else {
                        this.writeToStream(sourceBytes, start, len, outStream);
                    }
                } else if (len > 0) {
                    this.writeToStream(sourceBytes, start, len, outStream);
                }
            } else {
                Log.error("output stream unexpectedly closed in writeText", new Object[0]);
                handler.setError(true);
            }
        }
        catch (IOException ioexc) {
            handler.setError(true);
            cmdEnv.getResultMaps().add(new RpcMessage(ClientMessage.ClientMessageId.FILE_WRITE_ERROR, 3, 34, new String[]{"tmp file", ioexc.getLocalizedMessage()}).toMap());
        }
        catch (FileDecoderException e) {
            handler.setError(true);
            cmdEnv.getResultMaps().add(new RpcMessage(ClientMessage.ClientMessageId.FILE_WRITE_ERROR, 3, 34, new String[]{"tmp file", e.getLocalizedMessage()}).toMap());
        }
        catch (FileEncoderException e) {
            handler.setError(true);
            cmdEnv.getResultMaps().add(new RpcMessage(ClientMessage.ClientMessageId.FILE_WRITE_ERROR, 3, 34, new String[]{"tmp file", e.getLocalizedMessage()}).toMap());
        }
        return RpcPacketDispatcher.RpcPacketDispatcherResult.CONTINUE_LOOP;
    }

    protected RpcPacketDispatcher.RpcPacketDispatcherResult writeBinary(RpcConnection rpcConnection, CommandEnv cmdEnv, Map<String, Object> resultsMap) throws ConnectionException {
        if (rpcConnection == null) {
            throw new NullPointerError("Null rpcConnection in writeBinary().");
        }
        if (cmdEnv == null) {
            throw new NullPointerError("Null cmdEnv in writeBinary().");
        }
        if (resultsMap == null) {
            throw new NullPointerError("Null resultsMap in writeBinary().");
        }
        String handlerName = "writeBinary";
        CommandEnv.RpcHandler handler = cmdEnv.getHandler("writeBinary");
        if (handler == null) {
            CommandEnv commandEnv = cmdEnv;
            commandEnv.getClass();
            handler = new CommandEnv.RpcHandler(commandEnv, "writeBinary", false, null);
            cmdEnv.addHandler(handler);
        }
        if (handler.isError()) {
            return RpcPacketDispatcher.RpcPacketDispatcherResult.CONTINUE_LOOP;
        }
        Map<String, Object> stateMap = cmdEnv.getStateMap();
        RpcOutputStream outStream = this.getTempOutputStream(cmdEnv);
        if (outStream == null) {
            throw new NullPointerError("Null output stream in writeText state map");
        }
        try {
            if (outStream.getFD() != null && outStream.getFD().valid()) {
                outStream.write(resultsMap);
            } else {
                Log.error("output stream unexpectedly closed in writeBinary", new Object[0]);
                handler.setError(true);
            }
        }
        catch (IOException ioexc) {
            handler.setError(true);
            cmdEnv.handleResult(new RpcMessage(ClientMessage.ClientMessageId.FILE_WRITE_ERROR, 3, 34, new String[]{"tmp file", ioexc.getLocalizedMessage()}).toMap());
        }
        catch (FileDecoderException e) {
            handler.setError(true);
            cmdEnv.handleResult(new RpcMessage(ClientMessage.ClientMessageId.FILE_WRITE_ERROR, 3, 34, new String[]{"tmp file", e.getLocalizedMessage()}).toMap());
        }
        catch (FileEncoderException e) {
            handler.setError(true);
            cmdEnv.handleResult(new RpcMessage(ClientMessage.ClientMessageId.FILE_WRITE_ERROR, 3, 34, new String[]{"tmp file", e.getLocalizedMessage()}).toMap());
        }
        return RpcPacketDispatcher.RpcPacketDispatcherResult.CONTINUE_LOOP;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected RpcPacketDispatcher.RpcPacketDispatcherResult closeFile(RpcConnection rpcConnection, CommandEnv cmdEnv, Map<String, Object> resultsMap) throws ConnectionException {
        if (rpcConnection == null) {
            throw new NullPointerError("Null rpcConnection in closeFile().");
        }
        if (cmdEnv == null) {
            throw new NullPointerError("Null cmdEnv in closeFile().");
        }
        if (resultsMap == null) {
            throw new NullPointerError("Null resultsMap in closeFile().");
        }
        String commit = (String)resultsMap.get("commit");
        String clientHandle = (String)resultsMap.get("handle");
        CommandEnv.RpcHandler handler = cmdEnv.getHandler(clientHandle);
        Map<String, Object> stateMap = cmdEnv.getStateMap();
        String serverDigest = null;
        String localDigest = null;
        this.filePath = null;
        this.fileSize = 0L;
        this.currentSize = 0L;
        if (handler == null) {
            throw new NullPointerError("Null client handler in closeFile().");
        }
        if (handler.isError()) {
            return RpcPacketDispatcher.RpcPacketDispatcherResult.CONTINUE_LOOP;
        }
        if (stateMap == null) {
            throw new NullPointerError("Null state map in ClientSystemFileCommands.closeFile().");
        }
        if (handler.getMap().get(FILE_OPEN_IS_SYMBOLIC_LINK_KEY) != null && ((Boolean)handler.getMap().get(FILE_OPEN_IS_SYMBOLIC_LINK_KEY)).booleanValue()) {
            return RpcPacketDispatcher.RpcPacketDispatcherResult.CONTINUE_LOOP;
        }
        RpcOutputStream tmpStream = (RpcOutputStream)handler.getMap().get(FILE_OPEN_TMP_STREAM_KEY);
        RpcOutputStream targetStream = (RpcOutputStream)handler.getMap().get(FILE_OPEN_TARGET_STREAM_KEY);
        RpcPerforceFile tmpFile = (RpcPerforceFile)handler.getMap().get(FILE_OPEN_TMP_FILE_KEY);
        RpcPerforceFile targetFile = (RpcPerforceFile)handler.getMap().get(FILE_OPEN_TARGET_FILE_KEY);
        if (targetFile == null) {
            throw new NullPointerError("Null target file ClientSystemFileCommands.closeFile() state map");
        }
        if (commit != null) {
            Map origArgs = (Map)handler.getMap().get(FILE_OPEN_ORIG_ARGS_KEY);
            if (origArgs == null) {
                throw new NullPointerError("Null original argument map ClientSystemFileCommands.closeFile() state map");
            }
            String perms = (String)origArgs.get("perms");
            String modTimeStr = null;
            if (handler.getMap().containsKey(FILE_OPEN_MODTIME_KEY)) {
                modTimeStr = (String)handler.getMap().get(FILE_OPEN_MODTIME_KEY);
            }
            try {
                if (tmpStream != null) {
                    if (tmpFile == null) {
                        throw new NullPointerError("Null tmp file ClientSystemFileCommands.writeFile() state map");
                    }
                    try {
                        tmpStream.flush();
                        tmpStream.close();
                    }
                    catch (IOException e) {
                        Log.error("Flushing or closing stream failed in closeFile(); tmp file: " + tmpFile.getName(), new Object[0]);
                    }
                    try {
                        if (!tmpFile.renameTo(targetFile)) {
                            Log.warn("Rename file failed in closeFile(); so, now will try to copy the file...", new Object[0]);
                            FilesHelper.copy(tmpFile, targetFile);
                            Log.warn("Copy file succeeded in closeFile().", new Object[0]);
                        }
                    }
                    catch (IOException e) {
                        Log.error("Rename/copy failed completely in closeFile(); tmp file: " + tmpFile.getName() + "; target file: " + targetFile.getName(), new Object[0]);
                    }
                } else if (targetStream != null) {
                    try {
                        targetStream.flush();
                    }
                    catch (IOException e) {
                        Log.error("Flushing stream failed in closeFile(); tmp file: " + tmpFile.getName(), new Object[0]);
                    }
                }
                if (tmpStream != null) {
                    serverDigest = tmpStream.getServerDigest();
                    if (tmpStream.getLocalDigester() != null) {
                        try {
                            tmpStream.flush();
                        }
                        catch (IOException e) {
                            Log.error("Flushing stream failed in closeFile(); tmp file: " + tmpFile.getName(), new Object[0]);
                        }
                        localDigest = tmpStream.getLocalDigester().digestAs32ByteHex();
                    }
                } else if (targetStream != null) {
                    serverDigest = targetStream.getServerDigest();
                    if (targetStream.getLocalDigester() != null) {
                        try {
                            targetStream.flush();
                        }
                        catch (IOException e) {
                            Log.error("Flushing stream failed in closeFile(); target file: " + targetFile.getName(), new Object[0]);
                        }
                        localDigest = targetStream.getLocalDigester().digestAs32ByteHex();
                        try {
                            targetStream.close();
                        }
                        catch (IOException ioexc) {
                            Log.warn("target file close error in ClientSystemFileCommands.closeFile(): " + ioexc.getLocalizedMessage(), new Object[0]);
                        }
                    }
                }
                if (serverDigest != null && !cmdEnv.isNonCheckedSyncs() && !serverDigest.equals(localDigest)) {
                    handler.setError(true);
                    cmdEnv.handleResult(new RpcMessage(ClientMessage.ClientMessageId.DIGEST_MISMATCH, 3, 34, new String[]{targetFile.getPath(), serverDigest, localDigest}).toMap());
                    RpcPacketDispatcher.RpcPacketDispatcherResult ioexc = RpcPacketDispatcher.RpcPacketDispatcherResult.CONTINUE_LOOP;
                    return ioexc;
                }
                if (targetFile.getFileType() == RpcPerforceFileType.FST_APPLEFILE) {
                    AppleFileHelper.extractFile(targetFile);
                }
                if (modTimeStr != null) {
                    try {
                        long modTime = new Long(modTimeStr);
                        if (modTime > 0L) {
                            targetFile.setLastModified(modTime * 1000L);
                        }
                    }
                    catch (Exception exc) {
                        Log.warn("Unable to set target file modification time: " + exc, new Object[0]);
                    }
                }
                if (perms.equalsIgnoreCase(PERMS_RW)) {
                    this.fileCommands.setWritable(targetFile.getPath(), true);
                } else {
                    this.fileCommands.setWritable(targetFile.getPath(), false);
                }
                if (targetFile.getFileType().isExecutable()) {
                    this.fileCommands.setExecutable(targetFile.getPath(), true, false);
                }
            }
            finally {
                try {
                    if (tmpStream != null) {
                        tmpStream.close();
                    }
                }
                catch (IOException ioexc) {
                    Log.warn("tmp file close error in ClientSystemFileCommands.closeFile(): " + ioexc.getLocalizedMessage(), new Object[0]);
                }
                try {
                    if (targetStream != null) {
                        targetStream.close();
                    }
                }
                catch (IOException ioexc) {
                    Log.warn("target file close error in ClientSystemFileCommands.closeFile(): " + ioexc.getLocalizedMessage(), new Object[0]);
                }
                if (tmpFile != null && tmpFile.exists() && !tmpFile.delete()) {
                    Log.warn("Unable to delete tmp file '" + tmpFile.getPath() + "' in ClientSystemFileCommands.closeFile() -- unknown cause", new Object[0]);
                }
            }
        }
        return RpcPacketDispatcher.RpcPacketDispatcherResult.CONTINUE_LOOP;
    }

    protected RpcPacketDispatcher.RpcPacketDispatcherResult moveFile(RpcConnection rpcConnection, CommandEnv cmdEnv, Map<String, Object> resultsMap) throws ConnectionException {
        boolean caseSensitive;
        if (rpcConnection == null) {
            throw new NullPointerError("Null rpcConnection in moveFile().");
        }
        if (cmdEnv == null) {
            throw new NullPointerError("Null cmdEnv in moveFile().");
        }
        if (resultsMap == null) {
            throw new NullPointerError("Null resultsMap in moveFile().");
        }
        String clientPath = (String)resultsMap.get("path");
        String targetPath = (String)resultsMap.get("path2");
        String type = (String)resultsMap.get("type");
        String targetType = (String)resultsMap.get("type2");
        String clientHandle = (String)resultsMap.get("handle");
        String confirm = (String)resultsMap.get("confirm");
        String rmdir = (String)resultsMap.get("rmdir");
        RpcPerforceFileType fromFileType = RpcPerforceFileType.decodeFromServerString(type);
        RpcPerforceFileType targetFileType = RpcPerforceFileType.decodeFromServerString(targetType);
        boolean fromFstSymlink = fromFileType == RpcPerforceFileType.FST_SYMLINK;
        boolean toFstSymlink = targetFileType == RpcPerforceFileType.FST_SYMLINK;
        RpcPerforceFile fromFile = new RpcPerforceFile(clientPath, type);
        RpcPerforceFile toFile = new RpcPerforceFile(targetPath, targetType);
        CommandEnv.RpcHandler handler = cmdEnv.getHandler(clientHandle);
        if (handler == null) {
            CommandEnv commandEnv = cmdEnv;
            commandEnv.getClass();
            handler = new CommandEnv.RpcHandler(commandEnv, clientHandle, false, toFile);
            cmdEnv.addHandler(handler);
        }
        handler.setError(false);
        if (!this.fileExists(fromFile, fromFstSymlink)) {
            cmdEnv.handleResult(new RpcMessage(ClientMessage.ClientMessageId.FILE_NONEXISTENT, 1, 34, new String[]{clientPath}).toMap());
            return RpcPacketDispatcher.RpcPacketDispatcherResult.CONTINUE_LOOP;
        }
        boolean bl = caseSensitive = !cmdEnv.getServerProtocolSpecsMap().containsKey("nocase");
        if (!(!this.fileExists(toFile, toFstSymlink) || caseSensitive && clientPath.equalsIgnoreCase(targetPath))) {
            cmdEnv.handleResult(new RpcMessage(ClientMessage.ClientMessageId.CANT_CLOBBER, 3, 34, new String[]{targetPath}).toMap());
            return RpcPacketDispatcher.RpcPacketDispatcherResult.CONTINUE_LOOP;
        }
        if (!FilesHelper.mkdirs(toFile)) {
            handler.setError(true);
            cmdEnv.handleResult(new RpcMessage(ClientMessage.ClientMessageId.CANT_CREATE_DIR, 3, 34, new String[]{targetPath}).toMap());
            return RpcPacketDispatcher.RpcPacketDispatcherResult.CONTINUE_LOOP;
        }
        if (fromFile.renameTo(toFile, true)) {
            resultsMap.remove("func");
            RpcPacket respPacket = RpcPacket.constructRpcPacket(confirm, resultsMap, null);
            rpcConnection.putRpcPacket(respPacket);
        } else {
            Log.error("Rename failed completely in moveFile (cause unknown); source file: " + clientPath + "; target file: " + targetPath, new Object[0]);
            cmdEnv.handleResult(new RpcMessage(ClientMessage.ClientMessageId.FILE_MOVE_ERROR, 3, 34, new String[]{clientPath, "(cause unknown)"}).toMap());
        }
        if (rmdir != null) {
            File dir = fromFile.getParentFile();
            if (dir != null) {
                if (!SymbolicLinkHelper.isSymbolicLink(dir.getAbsolutePath()) && !dir.delete()) {
                    Log.stats("Unable to delete parent directory for delete for file '" + clientPath + "'; (unknown cause)", new Object[0]);
                }
            } else {
                Log.warn("Unable to open parent directory for delete for file '" + clientPath + "'; (no parent directory)", new Object[0]);
            }
        }
        return RpcPacketDispatcher.RpcPacketDispatcherResult.CONTINUE_LOOP;
    }

    protected RpcPacketDispatcher.RpcPacketDispatcherResult deleteFile(RpcConnection rpcConnection, CommandEnv cmdEnv, Map<String, Object> resultsMap) throws ConnectionException {
        if (rpcConnection == null) {
            throw new NullPointerError("Null rpcConnection in deleteFile().");
        }
        if (cmdEnv == null) {
            throw new NullPointerError("Null cmdEnv in deleteFile().");
        }
        if (resultsMap == null) {
            throw new NullPointerError("Null resultsMap in deleteFile().");
        }
        String clientPath = (String)resultsMap.get("path");
        String noClobber = (String)resultsMap.get("noclobber");
        String rmDir = (String)resultsMap.get("rmdir");
        File file = new File(clientPath);
        String fileTypeStr = (String)resultsMap.get("type");
        RpcPerforceFileType fileType = RpcPerforceFileType.decodeFromServerString(fileTypeStr);
        boolean fstSymlink = fileType == RpcPerforceFileType.FST_SYMLINK;
        if (!this.fileExists(file, fstSymlink)) {
            return RpcPacketDispatcher.RpcPacketDispatcherResult.CONTINUE_LOOP;
        }
        if (file.exists() && file.isFile() && noClobber != null && file.canWrite()) {
            cmdEnv.handleResult(new RpcMessage(ClientMessage.ClientMessageId.CANT_CLOBBER, 3, 34, new String[]{clientPath}).toMap());
            return RpcPacketDispatcher.RpcPacketDispatcherResult.CONTINUE_LOOP;
        }
        boolean deleteFailed = false;
        if (!file.delete()) {
            deleteFailed = true;
            if (!file.canWrite() && this.fileCommands.setWritable(clientPath, true)) {
                boolean bl = deleteFailed = !file.delete();
            }
        }
        if (deleteFailed) {
            cmdEnv.handleResult(new RpcMessage(ClientMessage.ClientMessageId.CANT_DELETE_FILE, 3, 34, new String[]{clientPath}).toMap());
            return RpcPacketDispatcher.RpcPacketDispatcherResult.CONTINUE_LOOP;
        }
        if (rmDir != null) {
            File clientRootDir = new File(this.server.getCurrentClient().getRoot());
            File dir = file;
            do {
                if ((dir = dir.getParentFile()) != null) {
                    if (SymbolicLinkHelper.isSymbolicLink(dir.getAbsolutePath()) || dir.delete()) continue;
                    Log.stats("Unable to delete parent directory for delete for file '" + clientPath + "'; (unknown cause)", new Object[0]);
                    break;
                }
                Log.warn("Unable to open parent directory for delete for file '" + clientPath + "' (unknown cause)", new Object[0]);
                break;
            } while (!dir.getAbsoluteFile().equals(clientRootDir));
        }
        return RpcPacketDispatcher.RpcPacketDispatcherResult.CONTINUE_LOOP;
    }

    /*
     * WARNING - void declaration
     */
    protected RpcPacketDispatcher.RpcPacketDispatcherResult checkFile(RpcConnection rpcConnection, CommandEnv cmdEnv, Map<String, Object> resultsMap) throws ConnectionException {
        if (rpcConnection == null) {
            throw new NullPointerError("Null rpcConnection in checkFile().");
        }
        if (cmdEnv == null) {
            throw new NullPointerError("Null cmdEnv in checkFile().");
        }
        if (resultsMap == null) {
            throw new NullPointerError("Null resultsMap in checkFile().");
        }
        String clientPath = (String)resultsMap.get("path");
        String clientType = (String)resultsMap.get("type");
        String forceType = (String)resultsMap.get("forceType");
        String digest = (String)resultsMap.get("digest");
        String confirm = (String)resultsMap.get("confirm");
        String ignore = (String)resultsMap.get("ignore");
        String fileSize = (String)resultsMap.get("fileSize");
        String scanSize = (String)resultsMap.get("scanSize");
        if (ignore != null) {
            RpcFunctionSpec funcSpec;
            if (this.isIgnore(new File(clientPath), rpcConnection.getClientCharset(), cmdEnv)) {
                return RpcPacketDispatcher.RpcPacketDispatcherResult.CONTINUE_LOOP;
            }
            if (ignore.length() > 0 && (funcSpec = RpcFunctionSpec.decode(ignore)) == RpcFunctionSpec.CLIENT_ACK) {
                HashMap<String, Object> respMap = new HashMap<String, Object>();
                for (Map.Entry<String, Object> entry : resultsMap.entrySet()) {
                    if (entry.getKey() == null || entry.getKey().equalsIgnoreCase("func")) continue;
                    respMap.put(entry.getKey(), entry.getValue());
                }
                RpcPacket respPacket = RpcPacket.constructRpcPacket(confirm, respMap, null);
                rpcConnection.putRpcPacket(respPacket);
                return RpcPacketDispatcher.RpcPacketDispatcherResult.CONTINUE_LOOP;
            }
        }
        String status = "exists";
        String nType = clientType == null ? "text" : clientType;
        RpcPerforceFileType fileType = null;
        boolean fstSymlink = false;
        if (clientType != null) {
            MD5Digester digester;
            RpcPerforceFile file = new RpcPerforceFile(clientPath, clientType);
            fileType = RpcPerforceFileType.decodeFromServerString(clientType);
            boolean bl = fstSymlink = fileType == RpcPerforceFileType.FST_SYMLINK;
            if (!this.fileExists(file, fstSymlink)) {
                status = "missing";
            } else if (digest != null && (digester = new MD5Digester()) != null) {
                void var18_27;
                Object var18_23 = null;
                boolean convertLineEndings = false;
                switch (fileType) {
                    case FST_UTF16: {
                        Charset charset = CharsetDefs.UTF16;
                    }
                    case FST_UNICODE: {
                        void var18_25;
                        if (var18_25 == null) {
                            Charset charset = rpcConnection.getClientCharset();
                        }
                    }
                    case FST_XTEXT: 
                    case FST_TEXT: {
                        convertLineEndings = true;
                        break;
                    }
                }
                String digestStr = digester.digestFileAs32ByteHex(file, (Charset)var18_27, convertLineEndings, file.getLineEnding());
                if (digestStr != null && digestStr.equals(digest)) {
                    status = "same";
                }
            }
        } else {
            RpcPerforceFileType.RpcServerTypeStringSpec spec;
            Object file;
            int scan = -1;
            if (scanSize != null) {
                try {
                    scan = Integer.parseInt(scanSize);
                }
                catch (NumberFormatException digester) {
                    // empty catch block
                }
            }
            boolean bl = fstSymlink = (fileType = RpcPerforceFileType.inferFileType((File)(file = new File(clientPath)), scan, cmdEnv.getRpcConnection().isUnicodeServer(), cmdEnv.getRpcConnection().getClientCharset())) == RpcPerforceFileType.FST_SYMLINK;
            if (!this.fileExists((File)file, fstSymlink)) {
                status = "missing";
                cmdEnv.handleResult(new RpcMessage(ClientMessage.ClientMessageId.FILE_MISSING_ASSUMING_TYPE, 1, 34, new String[]{clientPath, nType}).toMap());
            }
            String string = (String)cmdEnv.getServerProtocolSpecsMap().get("xfiles");
            int serverXLevel = 0;
            if (string != null) {
                try {
                    serverXLevel = new Integer(string);
                }
                catch (NumberFormatException nfe) {
                    throw new ProtocolError("Unexpected number conversion exception in ClientSystemFileCommands.checkFile: " + nfe.getLocalizedMessage(), nfe);
                }
            }
            boolean overSize = false;
            if (fileSize != null) {
                try {
                    long checkSize = Long.parseLong(fileSize);
                    overSize = ((File)file).length() > checkSize;
                }
                catch (NumberFormatException checkSize) {
                    // empty catch block
                }
            }
            if ((spec = RpcPerforceFileType.getServerFileTypeString(clientPath, overSize, fileType, forceType, serverXLevel)).getServerTypeString() == null) {
                cmdEnv.handleResult(spec.getMsg().toMap());
                return RpcPacketDispatcher.RpcPacketDispatcherResult.CONTINUE_LOOP;
            }
            if (spec.getMsg() != null) {
                cmdEnv.handleResult(spec.getMsg().toMap());
            }
            nType = spec.getServerTypeString();
        }
        HashMap<String, Object> respMap = new HashMap<String, Object>();
        respMap.put("type", nType);
        respMap.put("status", status);
        for (Map.Entry entry : resultsMap.entrySet()) {
            if (entry.getKey() == null || ((String)entry.getKey()).equalsIgnoreCase("func") || ((String)entry.getKey()).equalsIgnoreCase("type") || ((String)entry.getKey()).equalsIgnoreCase("status")) continue;
            respMap.put((String)entry.getKey(), entry.getValue());
        }
        RpcPacket respPacket = RpcPacket.constructRpcPacket(confirm, respMap, null);
        rpcConnection.putRpcPacket(respPacket);
        return RpcPacketDispatcher.RpcPacketDispatcherResult.CONTINUE_LOOP;
    }

    protected RpcPacketDispatcher.RpcPacketDispatcherResult reconcileEdit(RpcConnection rpcConnection, CommandEnv cmdEnv, Map<String, Object> resultsMap) throws ConnectionException {
        HashMap<String, File> skipFilesMap;
        String handle;
        if (rpcConnection == null) {
            throw new NullPointerError("Null rpcConnection in reconcileEdit().");
        }
        if (cmdEnv == null) {
            throw new NullPointerError("Null cmdEnv in reconcileEdit().");
        }
        if (resultsMap == null) {
            throw new NullPointerError("Null resultsMap in reconcileEdit().");
        }
        String clientPath = (String)resultsMap.get("path");
        String clientType = (String)resultsMap.get("type");
        String digest = (String)resultsMap.get("digest");
        String confirm = (String)resultsMap.get("confirm");
        this.reconcileHandle = handle = (String)resultsMap.get("handle");
        CommandEnv.RpcHandler handler = cmdEnv.getHandler(handle);
        if (handler == null) {
            CommandEnv commandEnv = cmdEnv;
            commandEnv.getClass();
            handler = new CommandEnv.RpcHandler(commandEnv, handle, false, null);
            cmdEnv.addHandler(handler);
        }
        if ((skipFilesMap = (HashMap<String, File>)handler.getMap().get(RECONCILE_HANDLER_SKIP_ADD_KEY)) == null) {
            skipFilesMap = new HashMap<String, File>();
        }
        String status = "exists";
        String nType = clientType == null ? "text" : clientType;
        File file = new File(clientPath);
        RpcPerforceFileType fileType = RpcPerforceFileType.decodeFromServerString(clientType);
        boolean fstSymlink = fileType == RpcPerforceFileType.FST_SYMLINK;
        if (!this.fileExists(file, fstSymlink)) {
            status = "missing";
        } else if (RpcPerforceFileType.isProbablySymLink(file)) {
            skipFilesMap.put(file.getAbsolutePath(), file);
        } else if (digest != null) {
            MD5Digester digester = new MD5Digester();
            if (digester != null) {
                boolean bl;
                Object digestCharset = null;
                boolean bl2 = false;
                switch (fileType) {
                    case FST_UTF16: {
                        digestCharset = CharsetDefs.UTF16;
                    }
                    case FST_UNICODE: {
                        if (digestCharset == null) {
                            digestCharset = rpcConnection.getClientCharset();
                        }
                    }
                    case FST_XTEXT: 
                    case FST_TEXT: {
                        bl = true;
                        break;
                    }
                }
                String digestStr = digester.digestFileAs32ByteHex(file, (Charset)digestCharset, bl);
                if (digestStr != null && digestStr.equals(digest)) {
                    status = "same";
                }
            }
        } else {
            skipFilesMap.put(file.getAbsolutePath(), file);
        }
        handler.getMap().put(RECONCILE_HANDLER_SKIP_ADD_KEY, skipFilesMap);
        HashMap<String, Object> respMap = new HashMap<String, Object>();
        respMap.put("type", nType);
        respMap.put("status", status);
        for (Map.Entry entry : resultsMap.entrySet()) {
            if (entry.getKey() == null || ((String)entry.getKey()).equalsIgnoreCase("func") || ((String)entry.getKey()).equalsIgnoreCase("type") || ((String)entry.getKey()).equalsIgnoreCase("status")) continue;
            respMap.put((String)entry.getKey(), entry.getValue());
        }
        RpcPacket respPacket = RpcPacket.constructRpcPacket(confirm, respMap, null);
        rpcConnection.putRpcPacket(respPacket);
        return RpcPacketDispatcher.RpcPacketDispatcherResult.CONTINUE_LOOP;
    }

    protected RpcPacketDispatcher.RpcPacketDispatcherResult reconcileAdd(RpcConnection rpcConnection, CommandEnv cmdEnv, Map<String, Object> resultsMap) throws ConnectionException {
        Map skipFilesMap;
        if (rpcConnection == null) {
            throw new NullPointerError("Null rpcConnection in reconcileAdd().");
        }
        if (cmdEnv == null) {
            throw new NullPointerError("Null cmdEnv in reconcileAdd().");
        }
        if (resultsMap == null) {
            throw new NullPointerError("Null resultsMap in reconcileAdd().");
        }
        String dir = (String)resultsMap.get("dir");
        String traverse = (String)resultsMap.get("traverse");
        String skipIgnore = (String)resultsMap.get("skipIgnore");
        String confirm = (String)resultsMap.get("confirm");
        String handle = (String)resultsMap.get("handle");
        ViewMap<IMapEntry> viewMap = new ViewMap<IMapEntry>();
        int i = 0;
        while (resultsMap.get("mapTable" + i) != null) {
            String entry = (String)resultsMap.get("mapTable" + i);
            if (entry != null) {
                if (entry.contains(" ") || entry.contains("\t")) {
                    if (!entry.startsWith("\"")) {
                        entry = "\"" + entry;
                    }
                    if (!entry.endsWith("\"")) {
                        entry = entry + "\"";
                    }
                }
                MapEntry mapEntry = new MapEntry(i, entry);
                viewMap.addEntry(mapEntry);
            }
            ++i;
        }
        boolean isTraverse = traverse != null && !traverse.equalsIgnoreCase("0");
        boolean isSkipIgnore = skipIgnore != null && !skipIgnore.equalsIgnoreCase("0");
        HashMap<String, File> addFilesMap = new HashMap<String, File>();
        this.traverseDirs(new File(dir), isTraverse, isSkipIgnore, addFilesMap, viewMap, rpcConnection.isUnicodeServer(), rpcConnection.getClientCharset(), cmdEnv);
        CommandEnv.RpcHandler handler = cmdEnv.getHandler(handle);
        if (handler != null && (skipFilesMap = (Map)handler.getMap().get(RECONCILE_HANDLER_SKIP_ADD_KEY)) != null) {
            for (Map.Entry entry : skipFilesMap.entrySet()) {
                String string = (String)entry.getKey();
                addFilesMap.remove(string);
            }
        }
        HashMap<String, Object> respMap = new HashMap<String, Object>();
        int i2 = 0;
        for (Map.Entry entry : addFilesMap.entrySet()) {
            if (entry.getKey() == null) continue;
            respMap.put("file" + i2++, entry.getKey());
        }
        for (Map.Entry<String, Object> entry : resultsMap.entrySet()) {
            if (entry.getKey() == null || entry.getKey().equalsIgnoreCase("func")) continue;
            respMap.put(entry.getKey(), entry.getValue());
        }
        RpcPacket rpcPacket = RpcPacket.constructRpcPacket(confirm, respMap, null);
        rpcConnection.putRpcPacket(rpcPacket);
        return RpcPacketDispatcher.RpcPacketDispatcherResult.CONTINUE_LOOP;
    }

    protected RpcPacketDispatcher.RpcPacketDispatcherResult reconcileFlush(RpcConnection rpcConnection, CommandEnv cmdEnv, Map<String, Object> resultsMap) throws ConnectionException {
        if (rpcConnection == null) {
            throw new NullPointerError("Null rpcConnection in reconcileFlush().");
        }
        if (cmdEnv == null) {
            throw new NullPointerError("Null cmdEnv in reconcileFlush().");
        }
        if (resultsMap == null) {
            throw new NullPointerError("Null resultsMap in reconcileFlush().");
        }
        CommandEnv.RpcHandler handler = cmdEnv.getHandler(this.reconcileHandle);
        if (handler != null) {
            handler.getMap().remove(RECONCILE_HANDLER_SKIP_ADD_KEY);
            handler = null;
        }
        return RpcPacketDispatcher.RpcPacketDispatcherResult.CONTINUE_LOOP;
    }

    private void traverseDirs(File file, boolean traverse, boolean skipIgnore, Map<String, File> addFilesMap, ViewMap<IMapEntry> viewMap, boolean unicode, Charset charset, CommandEnv cmdEnv) {
        File[] files;
        if (addFilesMap == null) {
            throw new IllegalArgumentException("Must pass in a non-null 'files' list as a parameter.");
        }
        if (file == null || !file.exists()) {
            return;
        }
        if (file.isFile()) {
            if (skipIgnore || !this.isIgnore(file, charset, cmdEnv)) {
                addFilesMap.put(file.getAbsolutePath(), file);
            }
            return;
        }
        if (file.isDirectory() && RpcPerforceFileType.isProbablySymLink(file)) {
            if (skipIgnore || !this.isIgnore(file, charset, cmdEnv)) {
                addFilesMap.put(file.getAbsolutePath(), file);
            }
            return;
        }
        if (file.isDirectory() && (files = file.listFiles()) != null) {
            for (File f : files) {
                if (f.isDirectory()) {
                    if (RpcPerforceFileType.isProbablySymLink(file)) {
                        if (!skipIgnore && this.isIgnore(f, charset, cmdEnv)) continue;
                        addFilesMap.put(f.getAbsolutePath(), f);
                        continue;
                    }
                    if (!traverse) continue;
                    this.traverseDirs(f, traverse, skipIgnore, addFilesMap, viewMap, unicode, charset, cmdEnv);
                    continue;
                }
                if (!skipIgnore && this.isIgnore(f, charset, cmdEnv)) continue;
                addFilesMap.put(f.getAbsolutePath(), f);
            }
        }
    }

    private boolean fileExists(File file, boolean fstSymlink) {
        if (file != null) {
            if (file.exists()) {
                return true;
            }
            if (fstSymlink) {
                return SymbolicLinkHelper.exists(file.getPath());
            }
        }
        return false;
    }

    private boolean isIgnore(File file, Charset charset, CommandEnv cmdEnv) {
        if (this.getChecker(charset) != null) {
            try {
                if (this.checker.match(file)) {
                    cmdEnv.handleResult(new RpcMessage(ClientMessage.ClientMessageId.CANT_ADD_FILE_TYPE, 1, 34, new String[]{file.getAbsolutePath(), "ignored"}).toMap());
                    return true;
                }
            }
            catch (FileNotFoundException e) {
                Log.error("Exception occurred during ignore files checking: " + e, new Object[0]);
            }
            catch (IOException e) {
                Log.error("Exception occurred during ignore files checking: " + e, new Object[0]);
            }
        }
        return false;
    }

    public RpcOutputStream getTempOutputStream(CommandEnv cmdEnv) throws ConnectionException {
        if (cmdEnv == null) {
            throw new NullPointerError("Null command env in ClientSystemFileCommands.getTempOutputStream()");
        }
        if (cmdEnv.getStateMap() == null) {
            throw new NullPointerError("Null command env state map in ClientSystemFileCommands.getTempOutputStream()");
        }
        if (cmdEnv.getProtocolSpecs() == null) {
            throw new NullPointerError("Null command env protocol specs in ClientSystemFileCommands.getTempOutputStream()");
        }
        RpcOutputStream outStream = (RpcOutputStream)cmdEnv.getStateMap().get("");
        if (outStream == null && (cmdEnv.isStreamCmd() || cmdEnv.getProtocolSpecs().isEnableTracking())) {
            try {
                String tmpFileName = RpcPerforceFile.createTempFileName(RpcPropertyDefs.getProperty(this.server.getProperties(), "com.perforce.p4java.tmpDir", System.getProperty(SYSTEM_TMPDIR_PROPS_KEY)));
                RpcPerforceFile tmpFile = new RpcPerforceFile(tmpFileName, RpcPerforceFileType.FST_BINARY);
                outStream = new RpcOutputStream(tmpFile);
                cmdEnv.getStateMap().put("", outStream);
            }
            catch (IOException ioexc) {
                Log.error("tmp file creation error: " + ioexc.getLocalizedMessage(), new Object[0]);
                Log.exception(ioexc);
                throw new ConnectionException("Unable to create temporary file for Perforce file retrieval; reason: " + ioexc.getLocalizedMessage(), ioexc);
            }
        }
        return outStream;
    }

    public Map<String, Object> convertFileDataMap(Map<String, Object> map, Charset charset, boolean isUnicodeServer) {
        if (map != null) {
            String dataString = null;
            byte[] dataBytes = null;
            try {
                dataBytes = (byte[])map.get("data");
            }
            catch (Throwable thr) {
                Log.exception(thr);
            }
            if (dataBytes != null) {
                try {
                    dataString = new String(dataBytes, charset == null ? RpcConnection.NON_UNICODE_SERVER_CHARSET_NAME : (isUnicodeServer ? CharsetDefs.UTF8_NAME : charset.name()));
                    map.put("data", dataString);
                }
                catch (UnsupportedEncodingException e) {
                    Log.exception(e);
                }
            }
        }
        return map;
    }

    public static void getFiles(File dir, FilenameFilter filter, List<File> files) {
        if (files == null) {
            throw new IllegalArgumentException("Must pass in a non-null 'files' list as a parameter.");
        }
        if (dir != null) {
            if (dir.isDirectory()) {
                String[] children = dir.list(filter);
                if (children != null) {
                    for (int i = 0; i < children.length; ++i) {
                        ClientSystemFileCommands.getFiles(new File(dir, children[i]), filter, files);
                    }
                }
            } else {
                files.add(dir);
            }
        }
    }

    private boolean useLocalDigester(String serverDigest, CommandEnv cmdEnv) {
        return serverDigest != null && !cmdEnv.isNonCheckedSyncs();
    }

    private ClientIgnoreChecker getChecker(Charset charset) {
        if (this.checker == null && this.server != null && this.server.getCurrentClient() != null && this.server.getIgnoreFileName() != null) {
            this.checker = new ClientIgnoreChecker(this.server.getCurrentClient().getRoot(), this.server.getIgnoreFileName(), charset);
        }
        return this.checker;
    }
}

