/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.impl.mapbased.rpc.stream;

import com.perforce.p4java.Log;
import com.perforce.p4java.exception.ConnectionException;
import com.perforce.p4java.exception.NullPointerError;
import com.perforce.p4java.exception.P4JavaError;
import com.perforce.p4java.exception.ProtocolError;
import com.perforce.p4java.impl.mapbased.rpc.ServerStats;
import com.perforce.p4java.impl.mapbased.rpc.connection.RpcConnection;
import com.perforce.p4java.impl.mapbased.rpc.func.RpcFunctionSpec;
import com.perforce.p4java.impl.mapbased.rpc.packet.RpcPacket;
import com.perforce.p4java.impl.mapbased.rpc.packet.RpcPacketDispatcher;
import com.perforce.p4java.impl.mapbased.rpc.packet.RpcPacketPreamble;
import com.perforce.p4java.impl.mapbased.rpc.stream.RpcGZIPInputStream;
import com.perforce.p4java.impl.mapbased.rpc.stream.RpcGZIPOutputStream;
import com.perforce.p4java.impl.mapbased.rpc.stream.RpcSocketInputStream;
import com.perforce.p4java.impl.mapbased.rpc.stream.RpcSocketOutputStream;
import com.perforce.p4java.impl.mapbased.rpc.stream.RpcSocketPool;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.Properties;

public class RpcStreamConnection
extends RpcConnection {
    public static final String TRACE_PREFIX = "RpcStreamConnection";
    protected static final int INITIAL_SENDBUF_SIZE = 2048;
    protected static final int SENDBUF_REALLOC_INCR = 1024;
    private RpcSocketPool pool = null;
    private Socket socket = null;
    private InputStream sockInputStream = null;
    private OutputStream sockOutputStream = null;
    private InputStream topInputStream = null;
    private OutputStream topOutputStream = null;

    public RpcStreamConnection(String serverHost, int serverPort, Properties props, ServerStats stats, Charset charset) throws ConnectionException {
        this(serverHost, serverPort, props, stats, charset, (Socket)null);
    }

    public RpcStreamConnection(String serverHost, int serverPort, Properties props, ServerStats stats, Charset charset, Socket socket) throws ConnectionException {
        super(serverHost, serverPort, props, stats, charset);
        try {
            this.socket = socket;
            if (this.socket == null) {
                this.socket = this.createSocket(serverHost, serverPort);
            }
            this.init();
        }
        catch (UnknownHostException exc) {
            throw new ConnectionException("Unable to resolve Perforce server host name '" + this.hostName + "' for RPC connection");
        }
        catch (IOException exc) {
            throw new ConnectionException("Unable to connect to Perforce server at " + this.hostName + ":" + this.hostPort);
        }
        catch (Throwable thr) {
            Log.error("Unexpected exception: " + thr.getLocalizedMessage());
            Log.exception(thr);
            throw new ConnectionException(thr.getLocalizedMessage());
        }
    }

    public RpcStreamConnection(String serverHost, int serverPort, Properties props, ServerStats stats, Charset charset, RpcSocketPool pool) throws ConnectionException {
        super(serverHost, serverPort, props, stats, charset);
        try {
            this.pool = pool;
            this.socket = this.pool != null ? this.pool.acquire() : this.createSocket(serverHost, serverPort);
            this.init();
        }
        catch (UnknownHostException exc) {
            throw new ConnectionException("Unable to resolve Perforce server host name '" + this.hostName + "' for RPC connection");
        }
        catch (IOException exc) {
            throw new ConnectionException("Unable to connect to Perforce server at " + this.hostName + ":" + this.hostPort);
        }
        catch (Throwable thr) {
            Log.error("Unexpected exception: " + thr.getLocalizedMessage());
            Log.exception(thr);
            throw new ConnectionException(thr.getLocalizedMessage());
        }
    }

    private Socket createSocket(String host, int port) throws UnknownHostException, IOException {
        Socket socket = new Socket(host, port);
        RpcSocketPool.configureSocket(socket, this.props);
        return socket;
    }

    private void init() throws ConnectionException {
        try {
            this.sockInputStream = new RpcSocketInputStream(this.socket, this.stats);
            this.sockOutputStream = new RpcSocketOutputStream(this.socket, this.stats);
            this.topInputStream = this.sockInputStream;
            this.topOutputStream = this.sockOutputStream;
        }
        catch (Throwable thr) {
            Log.error("Unexpected exception: " + thr.getLocalizedMessage());
            Log.exception(thr);
            throw new ConnectionException(thr.getLocalizedMessage());
        }
    }

    public void disconnect(final RpcPacketDispatcher dispatcher) throws ConnectionException {
        try {
            RpcSocketPool.ShutdownHandler handler = new RpcSocketPool.ShutdownHandler(){

                public void shutdown(Socket socket) {
                    if (dispatcher != null) {
                        try {
                            dispatcher.shutdown(RpcStreamConnection.this);
                        }
                        catch (ConnectionException e) {
                            Log.exception(e);
                        }
                    }
                }
            };
            if (this.pool != null) {
                this.pool.release(this.socket, handler);
            } else {
                handler.shutdown(this.socket);
                this.topInputStream.close();
                this.topOutputStream.close();
                this.socket.close();
            }
        }
        catch (IOException exc) {
            throw new ConnectionException("RPC disconnection error: " + exc.getLocalizedMessage(), exc);
        }
    }

    public void useConnectionCompression() throws ConnectionException {
        if (!this.usingCompression) {
            super.useConnectionCompression();
            try {
                this.topOutputStream.flush();
                this.putRpcPacket(RpcPacket.constructRpcPacket(RpcFunctionSpec.PROTOCOL_COMPRESS2, (String[])null, null));
                this.topOutputStream.flush();
                this.topOutputStream = new RpcGZIPOutputStream(this.sockOutputStream);
                this.topInputStream = new RpcGZIPInputStream(this.sockInputStream);
            }
            catch (IOException exc) {
                Log.error("I/O exception encountered while setting up GZIP streaming: " + exc.getLocalizedMessage());
                Log.exception(exc);
                throw new ConnectionException("unable to set up client compression streaming to Perforce server: " + exc.getLocalizedMessage(), exc);
            }
        }
    }

    public RpcPacket getRpcPacket() throws ConnectionException {
        byte[] preambleBytes = new byte[5];
        RpcPacket packet = null;
        try {
            int moreBytesRead;
            int packetBytesRead;
            int moreBytesRead2;
            int bytesRead;
            this.stats.streamRecvs.incrementAndGet();
            if (bytesRead < 0) {
                throw new ConnectionException("server connection unexpectedly closed");
            }
            for (bytesRead = this.topInputStream.read(preambleBytes); bytesRead >= 0 && bytesRead < preambleBytes.length; bytesRead += moreBytesRead2) {
                moreBytesRead2 = this.topInputStream.read(preambleBytes, bytesRead, preambleBytes.length - bytesRead);
                this.stats.streamRecvs.incrementAndGet();
                if (moreBytesRead2 >= 0) continue;
                throw new ConnectionException("server connection unexpectedly closed");
            }
            this.stats.totalBytesRecv.getAndAdd(bytesRead);
            if (bytesRead != preambleBytes.length) {
                throw new ConnectionException("Incomplete RPC packet preamble read from Perforce server; connection probably broken. bytes read: " + bytesRead);
            }
            RpcPacketPreamble preamble = RpcPacketPreamble.retrievePreamble(preambleBytes);
            if (preamble == null) {
                throw new ProtocolError("Null RPC packet preamble in byte buffer");
            }
            if (!preamble.isValidChecksum()) {
                throw new ProtocolError("Bad checksum in RPC preamble");
            }
            int payloadLength = preamble.getPayloadSize();
            if (payloadLength <= 0) {
                throw new ProtocolError("Bad payload size in RPC preamble: " + payloadLength);
            }
            byte[] packetBytes = new byte[payloadLength];
            this.stats.streamRecvs.incrementAndGet();
            this.stats.totalBytesRecv.getAndAdd(packetBytesRead);
            if (packetBytesRead <= 0) {
                throw new ConnectionException("Perforce server network connection closed unexpectedly");
            }
            for (packetBytesRead = this.topInputStream.read(packetBytes, 0, payloadLength); packetBytesRead < payloadLength; packetBytesRead += moreBytesRead) {
                this.stats.incompleteReads.incrementAndGet();
                moreBytesRead = this.topInputStream.read(packetBytes, packetBytesRead, payloadLength - packetBytesRead);
                this.stats.streamRecvs.incrementAndGet();
                this.stats.totalBytesRecv.getAndAdd(moreBytesRead);
                if (moreBytesRead >= 0) continue;
                throw new ConnectionException("Perforce server network connection closed unexpectedly");
            }
            if (packetBytesRead != payloadLength) {
                throw new P4JavaError("RPC packet payload read size mismatch; expected: " + payloadLength + "; got: " + packetBytesRead);
            }
            packet = RpcPacket.constructRpcPacket(preamble, packetBytes, this.isUnicodeServer, this.clientCharset);
        }
        catch (IOException exc) {
            throw new ConnectionException(exc);
        }
        catch (ConnectionException p4jexc) {
            throw p4jexc;
        }
        catch (P4JavaError p4je) {
            throw p4je;
        }
        catch (Throwable thr) {
            Log.error("Unexpected exception: " + thr.getLocalizedMessage());
            Log.exception(thr);
            throw new P4JavaError(thr.getLocalizedMessage(), thr);
        }
        if (packet != null && this.stats != null) {
            this.stats.packetsRecv.incrementAndGet();
            this.stats.largestRpcPacketRecv.set(Math.max(this.stats.largestRpcPacketRecv.get(), (long)packet.getPacketLength()));
        }
        return packet;
    }

    public long putRpcPacket(RpcPacket packet) throws ConnectionException {
        byte[] nameBytes;
        byte[] sendBytes = new byte[2048];
        int sendPos = 0;
        if (packet == null) {
            throw new NullPointerError("null RPC packet passed to RpcStreamConnection.putPacket");
        }
        if (packet.getFuncNameString() == null) {
            throw new P4JavaError("Unmapped / unmappable function in RpcPacket.put()");
        }
        sendPos += 5;
        Map<String, Object> mapArgs = packet.getMapArgs();
        String[] strArgs = packet.getStrArgs();
        if (mapArgs != null) {
            for (String key : mapArgs.keySet()) {
                byte[] fieldBytes = this.marshalPacketField(key, mapArgs.get(key));
                if (sendBytes.length - sendPos <= fieldBytes.length) {
                    this.stats.bufferCompacts.getAndIncrement();
                    int newBytesLength = sendBytes.length + fieldBytes.length + 1024;
                    byte[] newBytes = new byte[newBytesLength];
                    System.arraycopy(sendBytes, 0, newBytes, 0, sendPos);
                    sendBytes = newBytes;
                }
                System.arraycopy(fieldBytes, 0, sendBytes, sendPos, fieldBytes.length);
                sendPos += fieldBytes.length;
            }
        }
        if (strArgs != null) {
            for (String arg : strArgs) {
                if (arg == null) continue;
                byte[] fieldBytes = this.marshalPacketField(null, arg);
                if (sendBytes.length - sendPos <= fieldBytes.length) {
                    this.stats.bufferCompacts.getAndIncrement();
                    int newBytesLength = sendBytes.length + fieldBytes.length + 1024;
                    byte[] newBytes = new byte[newBytesLength];
                    System.arraycopy(sendBytes, 0, newBytes, 0, sendPos);
                    sendBytes = newBytes;
                }
                System.arraycopy(fieldBytes, 0, sendBytes, sendPos, fieldBytes.length);
                sendPos += fieldBytes.length;
            }
        }
        if (packet.getEnv() != null) {
            byte[] envBytes = packet.getEnv().marshal();
            if (sendBytes.length - sendPos <= envBytes.length) {
                this.stats.bufferCompacts.getAndIncrement();
                int newBytesLength = sendBytes.length + envBytes.length + 1024;
                byte[] newBytes = new byte[newBytesLength];
                System.arraycopy(sendBytes, 0, newBytes, 0, sendPos);
                sendBytes = newBytes;
            }
            System.arraycopy(envBytes, 0, sendBytes, sendPos, envBytes.length);
            sendPos += envBytes.length;
        }
        if (sendBytes.length - sendPos <= (nameBytes = this.marshalPacketField("func", packet.getFuncNameString())).length) {
            this.stats.bufferCompacts.getAndIncrement();
            int newBytesLength = sendBytes.length + nameBytes.length;
            byte[] newBytes = new byte[newBytesLength];
            System.arraycopy(sendBytes, 0, newBytes, 0, sendPos);
            sendBytes = newBytes;
        }
        System.arraycopy(nameBytes, 0, sendBytes, sendPos, nameBytes.length);
        byte[] preambleBytes = RpcPacketPreamble.constructPreamble((sendPos += nameBytes.length) - 5).marshalAsBytes();
        System.arraycopy(preambleBytes, 0, sendBytes, 0, preambleBytes.length);
        try {
            this.topOutputStream.write(sendBytes, 0, sendPos);
            this.topOutputStream.flush();
            this.stats.streamSends.incrementAndGet();
            this.stats.totalBytesSent.getAndAdd(sendPos);
            this.stats.packetsSent.incrementAndGet();
            if (this.stats.largestRpcPacketSent.get() < (long)sendPos) {
                this.stats.largestRpcPacketSent.set(sendPos);
            }
        }
        catch (IOException exc) {
            Log.exception(exc);
            throw new ConnectionException("Unable to send command to Perforce server: " + exc.getMessage(), exc);
        }
        return 0L;
    }

    public long putRpcPackets(RpcPacket[] packets) throws ConnectionException {
        int retVal = 0;
        if (packets == null) {
            throw new NullPointerError("Null RPC packets passed to RpcStreamConnection.putPacket");
        }
        for (RpcPacket packet : packets) {
            if (packet == null) continue;
            retVal = (int)((long)retVal + this.putRpcPacket(packet));
        }
        return retVal;
    }

    public int getSystemSendBufferSize() {
        if (this.socket != null) {
            try {
                return this.socket.getSendBufferSize();
            }
            catch (SocketException exc) {
                Log.error("unexpected exception: " + exc.getLocalizedMessage());
                Log.exception(exc);
            }
        }
        return 0;
    }

    public int getSystemRecvBufferSize() {
        if (this.socket != null) {
            try {
                return this.socket.getReceiveBufferSize();
            }
            catch (SocketException exc) {
                Log.error("unexpected exception: " + exc.getLocalizedMessage());
                Log.exception(exc);
            }
        }
        return 0;
    }
}

