/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.impl.mapbased.rpc.connection;

import com.perforce.p4java.CharsetDefs;
import com.perforce.p4java.Log;
import com.perforce.p4java.exception.ConnectionException;
import com.perforce.p4java.exception.NullPointerError;
import com.perforce.p4java.exception.P4JavaError;
import com.perforce.p4java.impl.mapbased.rpc.ServerStats;
import com.perforce.p4java.impl.mapbased.rpc.connection.RpcConnectionFlowControl;
import com.perforce.p4java.impl.mapbased.rpc.packet.RpcPacket;
import com.perforce.p4java.impl.mapbased.rpc.packet.RpcPacketDispatcher;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.Properties;

public abstract class RpcConnection {
    public static final String TRACE_PREFIX = "RpcConnection";
    public static final Charset UNICODE_SERVER_CHARSET = CharsetDefs.UTF8;
    public static final String UNICODE_SERVER_CHARSET_NAME = CharsetDefs.UTF8_NAME;
    public static final Charset NON_UNICODE_SERVER_CHARSET = CharsetDefs.DEFAULT;
    public static final String NON_UNICODE_SERVER_CHARSET_NAME = CharsetDefs.DEFAULT_NAME;
    protected Properties props = null;
    protected RpcConnectionFlowControl flowController = new RpcConnectionFlowControl();
    protected ServerStats stats = null;
    protected Charset clientCharset = null;
    protected String hostName = null;
    protected int hostPort = 0;
    protected boolean usingCompression = false;
    protected boolean isUnicodeServer = false;

    public RpcConnection(String serverHost, int serverPort, Properties props, ServerStats stats, Charset clientCharset) throws ConnectionException {
        this.hostName = serverHost;
        this.hostPort = serverPort;
        this.clientCharset = clientCharset == null ? CharsetDefs.DEFAULT : clientCharset;
        this.stats = stats == null ? new ServerStats() : stats;
        this.props = props == null ? new Properties() : props;
        stats.serverConnections.incrementAndGet();
        this.isUnicodeServer = clientCharset != null;
    }

    public abstract void disconnect(RpcPacketDispatcher var1) throws ConnectionException;

    public abstract long putRpcPacket(RpcPacket var1) throws ConnectionException;

    public abstract long putRpcPackets(RpcPacket[] var1) throws ConnectionException;

    public abstract RpcPacket getRpcPacket() throws ConnectionException;

    public abstract int getSystemSendBufferSize();

    public abstract int getSystemRecvBufferSize();

    public byte[] marshalPacketField(String key, Object value) {
        byte[] retBytes = null;
        byte[] keyBytes = null;
        byte[] valBytes = null;
        byte[] valLengthBytes = null;
        if (key != null) {
            keyBytes = this.getNormalizedBytes(key);
        }
        valLengthBytes = RpcPacket.encodeInt4((valBytes = this.marshalPacketValue(value)) == null ? 0 : valBytes.length);
        int fieldLength = 2 + (keyBytes == null ? 0 : keyBytes.length) + valLengthBytes.length + (valBytes == null ? 0 : valBytes.length);
        retBytes = new byte[fieldLength];
        int retBytesPos = 0;
        if (keyBytes != null) {
            System.arraycopy(keyBytes, 0, retBytes, retBytesPos, keyBytes.length);
            retBytesPos += keyBytes.length;
        }
        retBytes[retBytesPos++] = 0;
        System.arraycopy(valLengthBytes, 0, retBytes, retBytesPos, valLengthBytes.length);
        retBytesPos += valLengthBytes.length;
        if (valBytes != null) {
            System.arraycopy(valBytes, 0, retBytes, retBytesPos, valBytes.length);
            retBytesPos += valBytes.length;
        }
        retBytes[retBytesPos++] = 0;
        return retBytes;
    }

    protected byte[] marshalPacketValue(Object value) {
        byte[] valBytes;
        block7: {
            valBytes = null;
            try {
                if (value == null) break block7;
                if (value.getClass() == String.class) {
                    valBytes = this.getNormalizedBytes((String)value);
                    break block7;
                }
                if (value instanceof byte[]) {
                    valBytes = (byte[])value;
                    break block7;
                }
                if (value instanceof StringBuffer) {
                    valBytes = this.getNormalizedBytes(((StringBuffer)value).toString());
                    break block7;
                }
                if (value instanceof ByteBuffer) {
                    int valLength = ((ByteBuffer)value).limit();
                    valBytes = new byte[valLength];
                    ((ByteBuffer)value).get(valBytes);
                    break block7;
                }
                throw new P4JavaError("Unmarshalable value in RpcStreamConnection.marshal; type: " + value.getClass().getCanonicalName());
            }
            catch (P4JavaError p4jerr) {
                throw p4jerr;
            }
            catch (Throwable thr) {
                Log.error("Unexpected exception in RpcStreamConnection.marshalValue: " + thr.getLocalizedMessage());
                Log.exception(thr);
                throw new P4JavaError("Unexpected exception in RpcStreamConnection.marshalValue: " + thr.getLocalizedMessage());
            }
        }
        return valBytes;
    }

    public void useConnectionCompression() throws ConnectionException {
        if (!this.usingCompression) {
            this.usingCompression = true;
        }
    }

    protected byte[] getNormalizedBytes(String str) {
        if (str == null) {
            throw new NullPointerError("null string passed to RpcConnection.getNormalizedBytes");
        }
        try {
            if (this.isUnicodeServer) {
                return str.getBytes(UNICODE_SERVER_CHARSET_NAME);
            }
            return str.getBytes(this.clientCharset.name());
        }
        catch (UnsupportedEncodingException e) {
            Log.exception(e);
            return null;
        }
    }

    protected String getNormalizedString(byte[] bytes) {
        if (bytes == null) {
            throw new NullPointerError("null bytes passed to RpcConnection.getNormalizedString");
        }
        try {
            if (this.isUnicodeServer) {
                return new String(bytes, UNICODE_SERVER_CHARSET_NAME);
            }
            return new String(bytes, this.clientCharset.name());
        }
        catch (UnsupportedEncodingException e) {
            Log.exception(e);
            return null;
        }
    }

    public boolean isUsingCompression() {
        return this.usingCompression;
    }

    public RpcConnectionFlowControl getFlowController() {
        return this.flowController;
    }

    public void setFlowController(RpcConnectionFlowControl flowController) {
        this.flowController = flowController;
    }

    public Properties getProps() {
        return this.props;
    }

    public void setProps(Properties props) {
        this.props = props;
    }

    public Charset getClientCharset() {
        return this.clientCharset;
    }

    public void setClientCharset(Charset charset) {
        this.clientCharset = charset;
        this.isUnicodeServer = this.clientCharset != null;
    }

    public ServerStats getStats() {
        return this.stats;
    }

    public void setStats(ServerStats stats) {
        this.stats = stats;
    }

    public String getHostName() {
        return this.hostName;
    }

    public void setHostName(String hostName) {
        this.hostName = hostName;
    }

    public int getHostPort() {
        return this.hostPort;
    }

    public void setHostPort(int hostPort) {
        this.hostPort = hostPort;
    }

    public void setUsingCompression(boolean usingCompression) {
        this.usingCompression = usingCompression;
    }

    public boolean isUnicodeServer() {
        return this.isUnicodeServer;
    }

    public void setUnicodeServer(boolean isUnicodeServer) {
        this.isUnicodeServer = isUnicodeServer;
    }
}

