/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.impl.generic.core;

import com.perforce.p4java.Log;
import com.perforce.p4java.core.IUserSummary;
import com.perforce.p4java.impl.generic.core.ServerResource;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserSummary
extends ServerResource
implements IUserSummary {
    private String loginName = null;
    private String email = null;
    private String fullName = null;
    private Date access = null;
    private Date update = null;

    public UserSummary() {
    }

    public UserSummary(String loginName, String email, String fullName, Date access, Date update) {
        this.loginName = loginName;
        this.email = email;
        this.fullName = fullName;
        this.access = access;
        this.update = update;
    }

    public UserSummary(Map<String, Object> map, boolean summaryOnly) {
        super(!summaryOnly, !summaryOnly);
        if (map != null) {
            try {
                this.loginName = (String)map.get("User");
                this.email = (String)map.get("Email");
                this.fullName = (String)map.get("FullName");
                if (summaryOnly) {
                    this.update = new Date(Long.parseLong((String)map.get("Update")) * 1000L);
                    this.access = new Date(Long.parseLong((String)map.get("Access")) * 1000L);
                } else {
                    String DATE_FORMAT = "yyyy/MM/dd HH:mm:ss";
                    if (map.containsKey("Update")) {
                        this.update = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss").parse((String)map.get("Update"));
                    }
                    if (map.containsKey("Access")) {
                        this.access = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss").parse((String)map.get("Access"));
                    }
                }
            }
            catch (Throwable thr) {
                Log.error("Unexpected exception in UserSummary constructor: " + thr.getLocalizedMessage());
                Log.exception(thr);
            }
        }
    }

    @Override
    public Date getAccess() {
        return this.access;
    }

    @Override
    public String getEmail() {
        return this.email;
    }

    @Override
    public String getFullName() {
        return this.fullName;
    }

    @Override
    public String getLoginName() {
        return this.loginName;
    }

    @Override
    public Date getUpdate() {
        return this.update;
    }

    @Override
    public void setAccess(Date access) {
        this.access = access;
    }

    @Override
    public void setEmail(String email) {
        this.email = email;
    }

    @Override
    public void setFullName(String fullName) {
        this.fullName = fullName;
    }

    @Override
    public void setLoginName(String loginName) {
        this.loginName = loginName;
    }

    @Override
    public void setUpdate(Date update) {
        this.update = update;
    }
}

