/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.server;

import com.perforce.p4java.impl.generic.sys.ISystemFileCommandsHelper;
import com.perforce.p4java.impl.mapbased.rpc.sys.helper.SysFileHelperBridge;
import com.perforce.p4java.server.AuthTicket;
import com.perforce.p4java.server.ServerFactory;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.ArrayList;

public class AuthTicketsHelper {
    private static final AuthTicket[] EMPTY = new AuthTicket[0];

    public static String getTicketValue(String userName, String serverAddress, String ticketsFilePath) throws IOException {
        String ticketValue = null;
        AuthTicket ticket = AuthTicketsHelper.getTicket(userName, serverAddress, ticketsFilePath);
        if (ticket != null) {
            ticketValue = ticket.getTicketValue();
        }
        return ticketValue;
    }

    public static AuthTicket[] getTickets(String ticketsFilePath) throws IOException {
        AuthTicket[] tickets = EMPTY;
        if (ticketsFilePath != null) {
            File ticketsFile = new File(ticketsFilePath);
            tickets = AuthTicketsHelper.getTickets(ticketsFile);
        }
        return tickets;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AuthTicket[] getTickets(File ticketsFile) throws IOException {
        AuthTicket[] tickets = EMPTY;
        if (ticketsFile != null) {
            ArrayList<AuthTicket> ticketList = new ArrayList<AuthTicket>();
            BufferedReader reader = new BufferedReader(new FileReader(ticketsFile));
            try {
                String ticketLine = reader.readLine();
                while (ticketLine != null) {
                    int colon;
                    int equals = ticketLine.indexOf(61);
                    if (equals != -1 && (colon = ticketLine.indexOf(58, equals)) != -1 && colon + 1 < ticketLine.length()) {
                        String serverAddress = ticketLine.substring(0, equals);
                        String userName = ticketLine.substring(equals + 1, colon);
                        String ticketValue = ticketLine.substring(colon + 1);
                        AuthTicket ticket = new AuthTicket(serverAddress, userName, ticketValue);
                        ticketList.add(ticket);
                    }
                    ticketLine = reader.readLine();
                }
            }
            finally {
                reader.close();
            }
            tickets = ticketList.toArray(new AuthTicket[0]);
        }
        return tickets;
    }

    public static AuthTicket getTicket(String userName, String serverAddress, String ticketsFilePath) throws IOException {
        AuthTicket foundTicket = null;
        if (serverAddress != null) {
            if (serverAddress.indexOf(58) == -1) {
                serverAddress = serverAddress + "localhost:" + serverAddress;
            }
            for (AuthTicket ticket : AuthTicketsHelper.getTickets(ticketsFilePath)) {
                if (!serverAddress.equals(ticket.getServerAddress()) || userName != null && !userName.equals(ticket.getUserName())) continue;
                foundTicket = ticket;
                break;
            }
        }
        return foundTicket;
    }

    public static AuthTicket getTicket(String serverAddress, String ticketsFilePath) throws IOException {
        return AuthTicketsHelper.getTicket(null, serverAddress, ticketsFilePath);
    }

    public static void saveTicket(AuthTicket ticket, String ticketsFilePath) throws IOException {
        if (ticketsFilePath != null) {
            AuthTicketsHelper.saveTicket(ticket, new File(ticketsFilePath));
        }
    }

    public static void saveTicket(AuthTicket ticket, File ticketsFile) throws IOException {
        if (ticket != null) {
            AuthTicketsHelper.saveTicket(ticket.getUserName(), ticket.getServerAddress(), ticket.getTicketValue(), ticketsFile);
        }
    }

    public static void saveTicket(String userName, String serverAddress, String ticketValue, String ticketsFilePath) throws IOException {
        if (ticketsFilePath != null) {
            AuthTicketsHelper.saveTicket(userName, serverAddress, ticketValue, new File(ticketsFilePath));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveTicket(String userName, String serverAddress, String ticketValue, File ticketsFile) throws IOException {
        if (userName != null && serverAddress != null && ticketsFile != null) {
            if (serverAddress.indexOf(58) == -1) {
                serverAddress = serverAddress + "localhost:" + serverAddress;
            }
            String prefix = serverAddress + "=" + userName + ":";
            String value = null;
            if (ticketValue != null) {
                value = prefix + ticketValue;
            }
            BufferedReader reader = null;
            try {
                reader = new BufferedReader(new FileReader(ticketsFile));
            }
            catch (FileNotFoundException fnfe) {
                reader = null;
            }
            File tempTicket = File.createTempFile("p4tickets", ".txt");
            tempTicket.deleteOnExit();
            PrintWriter writer = new PrintWriter(tempTicket, "utf-8");
            try {
                boolean processed = false;
                if (reader != null) {
                    String ticketLine = reader.readLine();
                    while (ticketLine != null) {
                        if (!processed && ticketLine.startsWith(prefix)) {
                            if (value != null) {
                                writer.println(value);
                            }
                            processed = true;
                        } else {
                            writer.println(ticketLine);
                        }
                        ticketLine = reader.readLine();
                    }
                }
                if (!processed && value != null) {
                    writer.println(value);
                }
            }
            finally {
                writer.flush();
                writer.close();
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException e) {}
                }
            }
            boolean renamed = tempTicket.renameTo(ticketsFile);
            if (!renamed) {
                renamed = AuthTicketsHelper.copy(tempTicket, ticketsFile);
            }
            AuthTicketsHelper.updateReadBit(ticketsFile);
            if (!renamed) {
                throw new IOException("P4 tickets file: " + ticketsFile.getAbsolutePath() + " could not be overwritten.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean copy(File source, File destination) throws IOException {
        boolean copied = false;
        if (source != null && destination != null) {
            FileChannel reader = null;
            AbstractInterruptibleChannel writer = null;
            try {
                long targetCount;
                long transferCount;
                reader = new FileInputStream(source).getChannel();
                ISystemFileCommandsHelper helper = ServerFactory.getRpcFileSystemHelper();
                if (helper == null) {
                    helper = SysFileHelperBridge.getSysFileCommands();
                }
                if (helper != null) {
                    helper.setWritable(destination.getAbsolutePath(), true);
                }
                copied = (transferCount = ((FileChannel)(writer = new FileOutputStream(destination, false).getChannel())).transferFrom(reader, 0L, targetCount = reader.size())) == targetCount;
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException e) {}
                }
                if (writer != null) {
                    try {
                        writer.close();
                    }
                    catch (IOException e) {}
                }
            }
        }
        return copied;
    }

    private static void updateReadBit(File file) throws IOException {
        if (file != null) {
            file.setReadOnly();
            ISystemFileCommandsHelper helper = ServerFactory.getRpcFileSystemHelper();
            if (helper == null) {
                helper = SysFileHelperBridge.getSysFileCommands();
            }
            if (helper != null) {
                helper.setOwnerReadOnly(file.getAbsolutePath());
            }
        }
    }
}

