/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.impl.mapbased.rpc.func.helper;

import com.perforce.p4java.CharsetDefs;
import com.perforce.p4java.Log;
import com.perforce.p4java.exception.NullPointerError;
import com.perforce.p4java.exception.P4JavaError;
import com.perforce.p4java.impl.generic.client.ClientLineEnding;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CodingErrorAction;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class MD5Digester {
    public static final String DIGEST_TYPE = "MD5";
    private MessageDigest md = null;

    public MD5Digester() {
        try {
            this.md = MessageDigest.getInstance(DIGEST_TYPE);
            this.md.reset();
        }
        catch (NoSuchAlgorithmException exc) {
            throw new P4JavaError("Unable to create an MD5 digester for P4Java: " + exc.getLocalizedMessage());
        }
    }

    public void reset() {
        this.md.reset();
    }

    public void update(String str) {
        if (str != null) {
            try {
                this.md.update(str.getBytes(CharsetDefs.UTF8.name()));
            }
            catch (UnsupportedEncodingException uee) {
                Log.exception(uee);
                throw new P4JavaError(uee);
            }
        }
    }

    public void update(byte[] bytes) {
        if (bytes != null) {
            this.md.update(bytes);
        }
    }

    public void update(byte[] bytes, int off, int len) {
        if (bytes != null) {
            this.md.update(bytes, off, len);
        }
    }

    public void update(ByteBuffer byteBuf) {
        if (byteBuf != null) {
            byte[] bytes = new byte[byteBuf.limit()];
            byteBuf.get(bytes);
            this.update(bytes);
        }
    }

    public byte[] digestAsBytes() {
        return this.md.digest();
    }

    public String digestAs32ByteHex() {
        String retStr = new BigInteger(1, this.md.digest()).toString(16).toUpperCase();
        if (retStr.length() != 32) {
            if (retStr.length() > 0 && retStr.length() < 32) {
                for (int i = retStr.length(); i < 32; ++i) {
                    retStr = "0" + retStr;
                }
            } else {
                throw new P4JavaError("Bad 32 byte digest string size in MD5Digester.digestAs32ByteHex; string: " + retStr + "; length: " + retStr.length());
            }
        }
        return retStr;
    }

    private ByteBuffer convertEndings(byte[] sourceBytes, int start, int length) {
        ByteBuffer converted = null;
        if (ClientLineEnding.CONVERT_TEXT) {
            converted = ByteBuffer.allocate(length);
            byte replace = ClientLineEnding.FST_L_LF_BYTES[0];
            byte[] convert = ClientLineEnding.FST_L_LOCAL_BYTES;
            for (int i = start; i < length; ++i) {
                boolean fix = false;
                if (sourceBytes[i] == convert[0] && i + convert.length - 1 < length) {
                    fix = true;
                    for (int c = 1; c < convert.length; ++c) {
                        if (sourceBytes[i + c] == convert[c]) continue;
                        fix = false;
                        break;
                    }
                }
                if (!fix) {
                    converted.put(sourceBytes[i]);
                    continue;
                }
                converted.put(replace);
                i += convert.length - 1;
            }
            converted.flip();
        } else {
            converted = ByteBuffer.wrap(sourceBytes, start, length);
        }
        return converted;
    }

    private int readMore(byte lastByte) {
        int more = -1;
        if (ClientLineEnding.CONVERT_TEXT && lastByte == ClientLineEnding.FST_L_LOCAL_BYTES[0]) {
            return ClientLineEnding.FST_L_LOCAL_BYTES.length - 1;
        }
        return more;
    }

    private void digestStream(InputStream inStream, boolean convertLineEndings) throws IOException {
        byte[] sourceBytes = new byte[10240];
        int inBytesRead = 0;
        while ((inBytesRead = inStream.read(sourceBytes)) > 0) {
            int start = 0;
            int len = inBytesRead;
            if (convertLineEndings) {
                byte[] allBytes = sourceBytes;
                int more = this.readMore(allBytes[inBytesRead - 1]);
                while (more > 0) {
                    byte[] moreBytes = new byte[more];
                    if ((more = inStream.read(moreBytes)) <= 0) continue;
                    byte[] joinedBytes = new byte[allBytes.length + more];
                    System.arraycopy(allBytes, 0, joinedBytes, 0, inBytesRead);
                    System.arraycopy(moreBytes, 0, joinedBytes, inBytesRead, moreBytes.length);
                    allBytes = joinedBytes;
                    len = allBytes.length;
                    more = this.readMore(allBytes[allBytes.length - 1]);
                }
                ByteBuffer convert = this.convertEndings(allBytes, start, len);
                sourceBytes = convert.array();
                start = convert.arrayOffset();
                len = convert.limit();
            }
            this.update(sourceBytes, start, len);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void digestEncodedStream(InputStream inStream, Charset charset, boolean convertLineEndings) throws CharacterCodingException, IOException {
        InputStreamReader reader = new InputStreamReader(inStream, charset);
        try {
            char[] inBytes = new char[10240];
            int inBytesRead = 0;
            CharsetEncoder encoder = CharsetDefs.UTF8.newEncoder().onMalformedInput(CodingErrorAction.REPORT).onUnmappableCharacter(CodingErrorAction.REPORT);
            while ((inBytesRead = reader.read(inBytes)) > 0) {
                ByteBuffer byteBuffer = encoder.encode(CharBuffer.wrap(inBytes, 0, inBytesRead));
                if (convertLineEndings) {
                    int more = this.readMore(byteBuffer.get(byteBuffer.limit() - 1));
                    while (more > 0) {
                        char[] moreChars = new char[more];
                        if ((more = reader.read(moreChars)) <= 0) continue;
                        ByteBuffer moreBuffer = encoder.encode(CharBuffer.wrap(moreChars, 0, more));
                        byteBuffer.limit(byteBuffer.limit() + moreBuffer.limit());
                        byteBuffer.put(moreBuffer);
                        more = this.readMore(byteBuffer.get(byteBuffer.limit() - 1));
                    }
                }
                byte[] sourceBytes = byteBuffer.array();
                int start = byteBuffer.arrayOffset();
                int len = byteBuffer.limit();
                if (convertLineEndings) {
                    ByteBuffer convert = this.convertEndings(sourceBytes, start, len);
                    sourceBytes = convert.array();
                    start = convert.arrayOffset();
                    len = convert.limit();
                }
                this.update(sourceBytes, start, len);
            }
        }
        finally {
            reader.close();
        }
    }

    public String digestFileAs32ByteHex(File file, Charset charset) {
        return this.digestFileAs32ByteHex(file, charset, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String digestFileAs32ByteHex(File file, Charset charset, boolean convertLineEndings) {
        if (file == null) {
            throw new NullPointerError("Null file passed to MD5Digester.digestFileAs32ByteHex()");
        }
        try {
            if (!file.exists()) return null;
            if (!file.canRead()) return null;
            FileInputStream inStream = new FileInputStream(file);
            try {
                if (inStream == null) return null;
                this.reset();
                if (charset != null) {
                    this.digestEncodedStream(inStream, charset, convertLineEndings);
                } else {
                    this.digestStream(inStream, convertLineEndings);
                }
                String string = this.digestAs32ByteHex();
                return string;
            }
            finally {
                try {
                    inStream.close();
                }
                catch (IOException e) {}
            }
        }
        catch (CharacterCodingException mie) {
            Log.error("error digesting file: " + file.getPath() + "; exception follows...");
            Log.exception(mie);
            return null;
        }
        catch (IOException ioexc) {
            Log.error("error digesting file: " + file.getPath() + "; exception follows...");
            Log.exception(ioexc);
        }
        return null;
    }

    public String digestFileAs32ByteHex(File file) {
        if (file == null) {
            throw new NullPointerError("Null file passed to MD5Digester.digestFileAs32ByteHex()");
        }
        try {
            FileInputStream inStream;
            if (file.exists() && file.canRead() && (inStream = new FileInputStream(file)) != null) {
                this.reset();
                byte[] inBytes = new byte[10240];
                int inBytesRead = 0;
                while ((inBytesRead = inStream.read(inBytes)) > 0) {
                    this.update(inBytes, 0, inBytesRead);
                }
                return this.digestAs32ByteHex();
            }
        }
        catch (IOException ioexc) {
            Log.error("error digesting file: " + file.getPath() + "; exception follows...");
            Log.exception(ioexc);
        }
        return null;
    }
}

