/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.impl.mapbased.rpc.sys.helper;

import com.perforce.p4java.P4JLog;
import com.perforce.p4java.impl.generic.sys.P4JSystemFileCommandsHelper;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class P4JRpcSystemFileCommandsImpl
implements P4JSystemFileCommandsHelper {
    public static final String IMPL_CLASS_NAME = "java.io.File";
    private static final String CAN_EXECUTE_METHOD_NAME = "canExecute";
    private static final String SET_EXECUTABLE_METHOD_NAME = "setExecutable";
    private static final String SET_WRITABLE_METHOD_NAME = "setWritable";
    private static final String SET_READABLE_METHOD_NAME = "setReadable";
    private static Class<P4JSystemFileCommandsHelper> implClass = null;
    private static Constructor<P4JSystemFileCommandsHelper> implClassConstructor = null;
    private static Method canExecuteMethod = null;
    private static Method setWritableMethod = null;
    private static Method setExecutableMethod = null;
    private static Method setReadableMethod = null;

    public boolean canExecute(String fileName) {
        if (canExecuteMethod != null) {
            try {
                P4JSystemFileCommandsHelper implObj = implClassConstructor.newInstance(fileName);
                return (Boolean)canExecuteMethod.invoke((Object)implObj, (Object[])null);
            }
            catch (InvocationTargetException ite) {
            }
            catch (Throwable thr) {
                P4JLog.error("Unexpected exception in P4JRpcSystemFileCommandsImpl.canExecute: " + thr.getLocalizedMessage());
                P4JLog.exception(thr);
            }
        }
        return false;
    }

    public boolean setExecutable(String fileName, boolean executable, boolean ownerOnly) {
        if (setExecutableMethod != null) {
            try {
                P4JSystemFileCommandsHelper implObj = implClassConstructor.newInstance(fileName);
                return (Boolean)setExecutableMethod.invoke((Object)implObj, executable, ownerOnly);
            }
            catch (Throwable thr) {
                P4JLog.error("Unexpected exception in P4JRpcSystemFileCommandsImpl.setExecutable: " + thr.getLocalizedMessage());
                P4JLog.exception(thr);
            }
        }
        return false;
    }

    public boolean setWritable(String fileName, boolean writable) {
        if (setWritableMethod != null) {
            try {
                P4JSystemFileCommandsHelper implObj = implClassConstructor.newInstance(fileName);
                return (Boolean)setWritableMethod.invoke((Object)implObj, writable);
            }
            catch (Throwable thr) {
                P4JLog.error("Unexpected exception in P4JRpcSystemFileCommandsImpl.setWritable: " + thr.getLocalizedMessage());
                P4JLog.exception(thr);
            }
        }
        return false;
    }

    public boolean isSymlink(String fileName) {
        return false;
    }

    public boolean setReadable(String fileName, boolean readable, boolean ownerOnly) {
        if (setReadableMethod != null) {
            try {
                P4JSystemFileCommandsHelper implObj = implClassConstructor.newInstance(fileName);
                return (Boolean)setReadableMethod.invoke((Object)implObj, readable, ownerOnly);
            }
            catch (Throwable thr) {
                P4JLog.error("Unexpected exception in P4JRpcSystemFileCommandsImpl.setReadOnly: " + thr.getLocalizedMessage());
                P4JLog.exception(thr);
            }
        }
        return false;
    }

    public boolean setOwnerReadOnly(String fileName) {
        boolean set = this.setReadable(fileName, false, false);
        set &= this.setReadable(fileName, true, true);
        return false;
    }

    static {
        P4JLog.info("initializing system file command helper class: java.io.File");
        try {
            implClass = Class.forName(IMPL_CLASS_NAME);
        }
        catch (ClassNotFoundException cnfe) {
            P4JLog.error("Unable to find class 'java.io.File': " + cnfe.getLocalizedMessage());
            P4JLog.exception(cnfe);
        }
        catch (Throwable thr) {
            P4JLog.error("Unable to load class 'java.io.File': " + thr.getLocalizedMessage());
            P4JLog.exception(thr);
        }
        if (implClass != null) {
            try {
                implClassConstructor = implClass.getConstructor(String.class);
                setWritableMethod = implClass.getDeclaredMethod(SET_WRITABLE_METHOD_NAME, Boolean.TYPE);
            }
            catch (NoSuchMethodException nsme) {
                P4JLog.error("No such method for helper class: " + nsme.getLocalizedMessage());
                P4JLog.exception(nsme);
            }
            catch (Throwable thr) {
                P4JLog.error("Unexpected exception introspecting helper class: " + thr.getLocalizedMessage());
                P4JLog.exception(thr);
            }
            try {
                canExecuteMethod = implClass.getDeclaredMethod(CAN_EXECUTE_METHOD_NAME, new Class[0]);
                setExecutableMethod = implClass.getDeclaredMethod(SET_EXECUTABLE_METHOD_NAME, Boolean.TYPE, Boolean.TYPE);
            }
            catch (NoSuchMethodException nsme) {
                P4JLog.warn("No such method for helper class: " + nsme.getLocalizedMessage());
                P4JLog.exception(nsme);
            }
            catch (Throwable thr) {
                P4JLog.warn("Unexpected exception introspecting helper class: " + thr.getLocalizedMessage());
                P4JLog.exception(thr);
            }
            try {
                setReadableMethod = implClass.getDeclaredMethod(SET_READABLE_METHOD_NAME, Boolean.TYPE, Boolean.TYPE);
            }
            catch (NoSuchMethodException nsme) {
                P4JLog.error("No such method for helper class: " + nsme.getLocalizedMessage());
                P4JLog.exception(nsme);
            }
            catch (Throwable thr) {
                P4JLog.error("Unexpected exception introspecting helper class: " + thr.getLocalizedMessage());
                P4JLog.exception(thr);
            }
        }
    }
}

