/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.impl.mapbased.rpc.sys;

import com.perforce.p4java.exception.P4JUnimplementedError;
import com.perforce.p4java.impl.generic.client.P4JClientLineEnding;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class P4JRpcLineEndFilterInputStream
extends FilterInputStream {
    private P4JClientLineEnding lineEnding = null;
    private static byte[] localLineEndBytes = P4JClientLineEnding.FST_L_LOCAL_BYTES;
    private byte[] inBytes = new byte[10240];
    private int inBytesPos = 0;
    private int inBytesRead = 0;
    private int matchPos = 0;
    private byte[] inLineEnd = null;

    public P4JRpcLineEndFilterInputStream(InputStream inStream, P4JClientLineEnding lineEnding) {
        super(inStream);
        this.lineEnding = lineEnding;
        if (this.lineEnding == null) {
            this.lineEnding = P4JClientLineEnding.FST_L_LOCAL;
        }
        switch (this.lineEnding) {
            case FST_L_LF: {
                this.inLineEnd = P4JClientLineEnding.FST_L_LF_BYTES;
                break;
            }
            case FST_L_CR: {
                this.inLineEnd = P4JClientLineEnding.FST_L_CR_BYTES;
                break;
            }
            case FST_L_CRLF: {
                this.inLineEnd = P4JClientLineEnding.FST_L_CRLF_BYTES;
                break;
            }
            case FST_L_LFCRLF: {
                this.inLineEnd = P4JClientLineEnding.FST_L_LFCRLF_BYTES;
                break;
            }
            default: {
                this.inLineEnd = localLineEndBytes;
            }
        }
    }

    public int read() throws IOException {
        throw new P4JUnimplementedError("P4JRpcLineEndFilterInputStream.read()");
    }

    public int read(byte[] targetBytes, int off, int len) throws IOException {
        int bytesOut = 0;
        int outPos = off;
        while (bytesOut < len) {
            if (this.inBytesPos == this.inBytesRead) {
                this.inBytesRead = this.in.read(this.inBytes);
                this.inBytesPos = 0;
            }
            if (this.inBytesRead <= 0) break;
            if (this.inBytes[this.inBytesPos] == this.inLineEnd[this.matchPos]) {
                ++this.inBytesPos;
                ++this.matchPos;
                if (this.matchPos < this.inLineEnd.length) continue;
                targetBytes[outPos++] = 10;
                ++bytesOut;
                this.matchPos = 0;
                continue;
            }
            if (this.matchPos != 0) {
                for (int i = 0; i < this.matchPos; ++i) {
                    targetBytes[outPos++] = this.inLineEnd[i];
                    ++bytesOut;
                }
                this.matchPos = 0;
                continue;
            }
            this.matchPos = 0;
            targetBytes[outPos++] = this.inBytes[this.inBytesPos++];
            ++bytesOut;
        }
        return bytesOut == 0 ? -1 : bytesOut;
    }

    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    public int available() throws IOException {
        throw new P4JUnimplementedError("P4JRpcLineEndFilterInputStream.available()");
    }

    public synchronized void mark(int readlimit) {
        throw new P4JUnimplementedError("P4JRpcLineEndFilterInputStream.mark()");
    }

    public boolean markSupported() {
        throw new P4JUnimplementedError("P4JRpcLineEndFilterInputStream.read()");
    }

    public synchronized void reset() throws IOException {
        throw new P4JUnimplementedError("P4JRpcLineEndFilterInputStream.markSupported()");
    }

    public long skip(long n) throws IOException {
        throw new P4JUnimplementedError("P4JRpcLineEndFilterInputStream.skip()");
    }
}

