/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.impl.mapbased.rpc.stream;

import com.perforce.p4java.P4JLog;
import com.perforce.p4java.exception.P4JError;
import com.perforce.p4java.exception.P4JNullPointerError;
import com.perforce.p4java.impl.mapbased.rpc.P4JRpcServerStats;
import java.io.IOException;
import java.io.OutputStream;
import java.net.Socket;

public class P4JRpcSocketOutputStream
extends OutputStream {
    public static final String TRACE_PREFIX = "P4JRpcSocketOutputStream";
    private Socket socket = null;
    private OutputStream socketStream = null;
    private P4JRpcServerStats stats = null;

    public P4JRpcSocketOutputStream(Socket socket, P4JRpcServerStats stats) {
        if (socket == null) {
            throw new P4JNullPointerError("null RPC socket passed to P4JRpcSocketInputStream constructor");
        }
        this.socket = socket;
        this.stats = stats;
        try {
            this.socketStream = socket.getOutputStream();
        }
        catch (IOException ioexc) {
            P4JLog.error("Unexpected I/O exception thrown during output stream retrieval in P4JRpcSocketInputStream constructor: " + ioexc.getLocalizedMessage());
            P4JLog.exception(ioexc);
            throw new P4JError("Unexpected I/O exception thrown during output stream retrieval in P4JRpcSocketInputStream constructor: " + ioexc.getLocalizedMessage());
        }
    }

    public void write(int b) throws IOException {
        if (this.socketStream == null) {
            throw new P4JNullPointerError("null socket stream in P4JRpcSocketOutputStream.write()");
        }
        this.socketStream.write(b);
    }

    public void write(byte[] bytes) throws IOException {
        if (this.socketStream == null) {
            throw new P4JNullPointerError("null socket stream in P4JRpcSocketOutputStream.write()");
        }
        if (bytes == null) {
            throw new P4JNullPointerError("null byte array in P4JRpcSocketOutputStream.write()");
        }
        if (this.stats != null && this.stats.largestSend.get() < (long)bytes.length) {
            this.stats.largestSend.set(bytes.length);
        }
        this.socketStream.write(bytes);
    }

    public void write(byte[] bytes, int offset, int len) throws IOException {
        if (this.socketStream == null) {
            throw new P4JNullPointerError("null socket stream in P4JRpcSocketOutputStream.write()");
        }
        if (bytes == null) {
            throw new P4JNullPointerError("null byte array in P4JRpcSocketOutputStream.write()");
        }
        if (this.stats != null && this.stats.largestSend.get() < (long)len) {
            this.stats.largestSend.set(len);
        }
        this.socketStream.write(bytes, offset, len);
    }

    protected Socket getSocket() {
        return this.socket;
    }

    protected void setSocket(Socket socket) {
        this.socket = socket;
    }

    protected OutputStream getSocketStream() {
        return this.socketStream;
    }

    protected void setSocketStream(OutputStream socketStream) {
        this.socketStream = socketStream;
    }
}

