/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.impl.mapbased.rpc.func.client;

import com.perforce.p4java.P4JCharset;
import com.perforce.p4java.P4JLog;
import com.perforce.p4java.P4JTracer;
import com.perforce.p4java.exception.P4JConfigException;
import com.perforce.p4java.exception.P4JConnectionException;
import com.perforce.p4java.exception.P4JError;
import com.perforce.p4java.exception.P4JNullPointerError;
import com.perforce.p4java.impl.mapbased.rpc.P4JRpcCommandEnv;
import com.perforce.p4java.impl.mapbased.rpc.P4JRpcServerImpl;
import com.perforce.p4java.impl.mapbased.rpc.connection.P4JRpcConnection;
import com.perforce.p4java.impl.mapbased.rpc.func.P4JRpcFunctionSpec;
import com.perforce.p4java.impl.mapbased.rpc.func.client.P4JMangle;
import com.perforce.p4java.impl.mapbased.rpc.func.helper.P4JRpcMD5Digester;
import com.perforce.p4java.impl.mapbased.rpc.func.helper.P4JRpcMapUnmapper;
import com.perforce.p4java.impl.mapbased.rpc.packet.P4JRpcPacket;
import com.perforce.p4java.impl.mapbased.rpc.packet.P4JRpcPacketDispatcher;
import com.perforce.p4java.server.callback.P4JSSOCallback;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class P4JRpcClientUserInteraction {
    public static final String TRACE_PREFIX = "P4JRpcClientUserInteraction";
    protected static final int RESP_LENGTH = 32;
    protected static final int TRUNCATE_LENGTH = 16;
    private Properties props = null;
    private P4JRpcServerImpl server = null;

    protected P4JRpcClientUserInteraction(Properties props, P4JRpcServerImpl server) {
        this.props = props;
        this.server = server;
    }

    protected P4JRpcPacketDispatcher.P4JRpcPacketDispatcherResult clientPrompt(P4JRpcConnection rpcConnection, P4JRpcCommandEnv cmdEnv, Map<String, Object> resultsMap) throws P4JConnectionException {
        String digest = null;
        String func2 = null;
        String state = null;
        String userName = null;
        String confirm = null;
        String mangle = null;
        boolean truncate = false;
        boolean noecho = false;
        P4JRpcMD5Digester digester = null;
        String passwd = null;
        String resp = null;
        P4JTracer.fine("P4JRpcClientUserInteraction.clientPrompt: ");
        try {
            digest = (String)resultsMap.get("digest");
            truncate = resultsMap.containsKey("truncate");
            func2 = (String)resultsMap.get("func2");
            userName = (String)resultsMap.get("user");
            state = (String)resultsMap.get("state");
            confirm = (String)resultsMap.get("confirm");
            noecho = resultsMap.containsKey("noecho");
            mangle = (String)resultsMap.get("mangle");
            Map<String, Object> inMap = cmdEnv.getCmdSpec().getInMap();
            if (inMap == null || inMap.size() < 1 || inMap.get("password") == null) {
                throw new P4JNullPointerError("No login password passed to client login");
            }
            passwd = ((String)inMap.get("password")).trim();
            if (truncate && passwd.length() > 16) {
                passwd = passwd.substring(0, 16);
            }
            if (digest != null) {
                digester = new P4JRpcMD5Digester();
                digester.update(passwd.getBytes(P4JCharset.UTF8.name()));
                resp = digester.digestAs32ByteHex();
                digester.reset();
                digester.update(resp.getBytes(P4JCharset.UTF8.name()));
                digester.update(digest.getBytes(P4JCharset.UTF8.name()));
                resp = digester.digestAs32ByteHex();
            }
            HashMap<String, Object> respMap = new HashMap<String, Object>();
            respMap.put("digest", digest);
            if (mangle != null) {
                respMap.put("mangle", mangle);
                P4JRpcMD5Digester mangleDigester = new P4JRpcMD5Digester();
                mangleDigester.update(mangle);
                mangleDigester.update(userName);
                P4JMangle jMangle = new P4JMangle();
                String toMangle = resp;
                if (toMangle == null) {
                    toMangle = passwd;
                }
                String digestedMangle = mangleDigester.digestAs32ByteHex();
                resp = jMangle.mangle(toMangle, digestedMangle);
            }
            respMap.put("data", resp);
            if (truncate) {
                respMap.put("truncate", "");
            }
            respMap.put("func2", func2);
            respMap.put("state", state);
            if (noecho) {
                respMap.put("noecho", "");
            }
            respMap.put("user", userName);
            respMap.put("confirm", confirm);
            P4JRpcPacket respPacket = P4JRpcPacket.constructRpcPacket(P4JRpcFunctionSpec.SERVER_DM_LOGIN, respMap, null);
            rpcConnection.putRpcPacket(respPacket);
        }
        catch (Exception exc) {
            P4JLog.exception(exc);
            throw new P4JError("Unexpected exception in P4JRpcClientCommandDispatcher.clientPrompt:" + exc.getLocalizedMessage(), exc);
        }
        return P4JRpcPacketDispatcher.P4JRpcPacketDispatcherResult.CONTINUE;
    }

    protected P4JRpcPacketDispatcher.P4JRpcPacketDispatcherResult clientSetPassword(P4JRpcConnection rpcConnection, P4JRpcCommandEnv cmdEnv, Map<String, Object> resultsMap) throws P4JConnectionException {
        if (this.server != null) {
            byte[] data;
            String data2 = (String)resultsMap.get("data2");
            String serverId = (String)resultsMap.get("serverAddress");
            if (serverId != null) {
                this.server.setServerId(serverId);
            }
            if ("logout".equals(data2)) {
                try {
                    this.server.saveTicket(null);
                }
                catch (P4JConfigException e) {
                    throw new P4JConnectionException(e);
                }
            }
            if ("login".equals(data2) && (data = (byte[])resultsMap.get("data")) != null) {
                String ticket = new String(data);
                resultsMap.put("authTicket", ticket);
                try {
                    this.server.saveTicket(ticket);
                }
                catch (P4JConfigException e) {
                    throw new P4JConnectionException(e);
                }
            }
        }
        return P4JRpcPacketDispatcher.P4JRpcPacketDispatcherResult.CONTINUE_LOOP;
    }

    protected P4JRpcPacketDispatcher.P4JRpcPacketDispatcherResult clientSingleSignon(P4JRpcConnection rpcConnection, P4JRpcCommandEnv cmdEnv, Map<String, Object> resultsMap) throws P4JConnectionException {
        String confirm = (String)resultsMap.get("confirm");
        P4JTracer.superfine("P4JRpcClientUserInteraction.clientSingleSignon: confirm: " + (confirm == null ? "<null>" : confirm));
        P4JSSOCallback.Status status = null;
        StringBuffer credBuf = new StringBuffer();
        if (this.server != null) {
            P4JSSOCallback ssoCallback = this.server.getSSOCallback();
            if (ssoCallback != null) {
                status = ssoCallback.getSSOCredentials(credBuf, this.server.getSSOKey(), this.server.getUserName());
            }
        } else {
            P4JLog.error("null server object in P4JRpcClientUserInteraction.clientSingleSignon method");
        }
        if (status == null) {
            status = P4JSSOCallback.Status.UNSET;
        }
        if (confirm != null) {
            HashMap<String, Object> respMap = new HashMap<String, Object>();
            for (String key : resultsMap.keySet()) {
                if (key == null || key.equalsIgnoreCase("func")) continue;
                respMap.put(key, resultsMap.get(key));
            }
            respMap.put("status", status.toString().toLowerCase());
            String sso = null;
            if (status != P4JSSOCallback.Status.UNSET) {
                sso = credBuf != null && credBuf.length() > 131072 ? credBuf.substring(0, 131072) : credBuf.toString();
            }
            respMap.put("sso", sso);
            P4JRpcPacket respPacket = P4JRpcPacket.constructRpcPacket(confirm, respMap, null);
            rpcConnection.putRpcPacket(respPacket);
        }
        return P4JRpcPacketDispatcher.P4JRpcPacketDispatcherResult.CONTINUE_LOOP;
    }

    protected P4JRpcPacketDispatcher.P4JRpcPacketDispatcherResult clientAck(P4JRpcConnection rpcConnection, P4JRpcCommandEnv cmdEnv, Map<String, Object> resultsMap) throws P4JConnectionException {
        String confirm = (String)resultsMap.get("confirm");
        String decline = (String)resultsMap.get("decline");
        String handle = (String)resultsMap.get("handle");
        P4JTracer.superfine("P4JRpcClientUserInteraction.clientAck: confirm: " + (confirm == null ? "<null>" : confirm));
        P4JTracer.superfine("P4JRpcClientUserInteraction.clientAck: decline: " + (decline == null ? "<null>" : decline));
        P4JTracer.superfine("P4JRpcClientUserInteraction.clientAck: handle: " + (handle == null ? "<null>" : handle));
        P4JRpcCommandEnv.P4JRpcHandler handler = cmdEnv.getHandler(handle);
        if (handler != null && handler.isError()) {
            confirm = decline;
        }
        if (confirm != null) {
            HashMap<String, Object> respMap = new HashMap<String, Object>();
            for (String key : resultsMap.keySet()) {
                if (key == null || key.equalsIgnoreCase("func")) continue;
                respMap.put(key, resultsMap.get(key));
            }
            P4JRpcPacket respPacket = P4JRpcPacket.constructRpcPacket(confirm, respMap, null);
            rpcConnection.putRpcPacket(respPacket);
        }
        return P4JRpcPacketDispatcher.P4JRpcPacketDispatcherResult.CONTINUE_LOOP;
    }

    protected P4JRpcPacketDispatcher.P4JRpcPacketDispatcherResult clientCrypto(P4JRpcConnection rpcConnection, P4JRpcCommandEnv cmdEnv, Map<String, Object> resultsMap) throws P4JConnectionException {
        String ticketStr = cmdEnv.getCmdSpec().getCmdTicket();
        P4JRpcMD5Digester digester = null;
        String token = null;
        String resp = null;
        HashMap<String, Object> respMap = null;
        try {
            if (ticketStr == null && this.server != null) {
                String serverId = (String)resultsMap.get("serverAddress");
                if (serverId != null) {
                    this.server.setServerId(serverId);
                }
                if ((ticketStr = this.server.loadTicket(serverId)) != null) {
                    this.server.setAuthTicket(ticketStr);
                }
            }
            if (ticketStr == null) {
                ticketStr = "";
            }
            P4JTracer.superfine("P4JRpcClientUserInteraction.clientCrypto: using ticket: " + ticketStr);
            token = (String)resultsMap.get("token");
            digester = new P4JRpcMD5Digester();
            digester.reset();
            digester.update(token.getBytes(P4JCharset.UTF8.name()));
            digester.update(ticketStr.getBytes());
            resp = digester.digestAs32ByteHex();
            respMap = new HashMap<String, Object>();
            respMap.put("token", resp);
            P4JRpcPacket respPacket = P4JRpcPacket.constructRpcPacket(P4JRpcFunctionSpec.PROTOCOL_CRYPTO, respMap, null);
            rpcConnection.putRpcPacket(respPacket);
        }
        catch (Exception exc) {
            P4JLog.exception(exc);
            throw new P4JError("Unexpected exception in P4JRpcClientCommandDispatcher.clientCrypto:" + exc.getLocalizedMessage(), exc);
        }
        return P4JRpcPacketDispatcher.P4JRpcPacketDispatcherResult.CONTINUE_LOOP;
    }

    protected P4JRpcPacketDispatcher.P4JRpcPacketDispatcherResult clientInputData(P4JRpcConnection rpcConnection, P4JRpcCommandEnv cmdEnv, Map<String, Object> resultsMap) throws P4JConnectionException {
        String JOB_CMD_NAME = "job";
        String CHANGE_CMD_NAME = "change";
        String SUBMIT_CMD_NAME = "submit";
        String LABEL_CMD_NAME = "label";
        String CLIENT_CMD_NAME = "client";
        P4JTracer.fine("P4JRpcClientUserInteraction.clientInputData");
        cmdEnv.newHandler();
        String confirm = (String)resultsMap.get("confirm");
        Map<String, Object> inMap = cmdEnv.getCmdSpec().getInMap();
        HashMap<String, Object> respMap = new HashMap<String, Object>();
        StringBuffer strBuf = new StringBuffer();
        if (cmdEnv.getCmdSpec().getCmdName().equalsIgnoreCase("job")) {
            P4JRpcMapUnmapper.unmapJobMap(inMap, strBuf);
        } else if (cmdEnv.getCmdSpec().getCmdName().equalsIgnoreCase("change")) {
            P4JRpcMapUnmapper.unmapChangeListMap(inMap, strBuf);
        } else if (cmdEnv.getCmdSpec().getCmdName().equalsIgnoreCase("submit")) {
            P4JRpcMapUnmapper.unmapChangeListMap(inMap, strBuf);
        } else if (cmdEnv.getCmdSpec().getCmdName().equalsIgnoreCase("label")) {
            P4JRpcMapUnmapper.unmapLabelMap(inMap, strBuf);
        } else if (cmdEnv.getCmdSpec().getCmdName().equalsIgnoreCase("client")) {
            P4JRpcMapUnmapper.unmapClientMap(inMap, strBuf);
        }
        respMap.put("data", strBuf);
        if (resultsMap != null) {
            for (String key : resultsMap.keySet()) {
                if (key == null || key.equalsIgnoreCase("func")) continue;
                respMap.put(key, resultsMap.get(key));
            }
            P4JTracer.superfine("P4JRpcClientUserInteraction.clientInputFile respMap: " + respMap);
        }
        P4JRpcPacket respPacket = P4JRpcPacket.constructRpcPacket(confirm, respMap, null);
        rpcConnection.putRpcPacket(respPacket);
        return P4JRpcPacketDispatcher.P4JRpcPacketDispatcherResult.CONTINUE_LOOP;
    }
}

