/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.impl.mapbased.rpc.func.client;

import com.perforce.p4java.P4JCharset;
import com.perforce.p4java.P4JLog;
import com.perforce.p4java.exception.P4JNullPointerError;
import com.perforce.p4java.impl.mapbased.rpc.func.client.P4JRpcClientMerge;
import com.perforce.p4java.impl.mapbased.rpc.func.helper.P4JRpcMD5Digester;
import com.perforce.p4java.impl.mapbased.rpc.sys.P4JRpcOutputStream;
import com.perforce.p4java.impl.mapbased.rpc.sys.P4JRpcPerforceFile;
import com.perforce.p4java.impl.mapbased.rpc.sys.P4JRpcPerforceFileType;
import java.io.FileDescriptor;
import java.io.IOException;
import java.nio.charset.Charset;

public class P4JRpcClientMergeState {
    public static final String TRACE_PREFIX = "P4JRpcClientMergeState";
    public static final String DEFAULT_TMPFILE_PFX = "p4j";
    public static final String DEFAULT_TMPFILE_SFX = ".mrg";
    private boolean externalStreamMerge = false;
    private String externalTmpFilename = null;
    private String tmpDir = null;
    private String clientPath = null;
    private String baseName = null;
    private String theirName = null;
    private String yourName = null;
    private String baseTmpFilename = null;
    private String theirTmpFilename = null;
    private String yourTmpFilename = null;
    private String resultTmpFilename = null;
    private P4JRpcPerforceFile baseTmpFile = null;
    private P4JRpcPerforceFile theirTmpFile = null;
    private P4JRpcPerforceFile yourTmpFile = null;
    private P4JRpcPerforceFile resultTmpFile = null;
    private P4JRpcOutputStream baseTmpFileStream = null;
    private P4JRpcOutputStream yourTmpFileStream = null;
    private P4JRpcOutputStream theirTmpFileStream = null;
    private P4JRpcOutputStream resultTmpFileStream = null;
    private int yourChunks = 0;
    private int theirChunks = 0;
    private int conflictChunks = 0;
    private int bothChunks = 0;
    private int bits = 0;
    private int oldBits = 0;
    private boolean safeMerge = false;
    private boolean autoMerge = false;
    private P4JRpcPerforceFileType clientType = null;
    private P4JRpcPerforceFileType resultType = null;
    private Charset charset = null;
    private boolean showAll = false;

    protected P4JRpcClientMergeState(String clientPath, boolean externalStreamMerge, P4JRpcPerforceFileType clientType, P4JRpcPerforceFileType resultType, String tmpDir, Charset charset) {
        this.externalStreamMerge = externalStreamMerge;
        this.clientPath = clientPath;
        this.clientType = clientType;
        this.resultType = resultType;
        this.charset = charset;
        if (tmpDir == null) {
            throw new P4JNullPointerError("null tmpdir passed to P4JRpcClientMergeState constructor");
        }
        this.tmpDir = tmpDir;
    }

    protected void openMergeFiles() throws IOException {
        this.baseTmpFilename = P4JRpcPerforceFile.createTempFileName(this.tmpDir);
        this.baseTmpFile = new P4JRpcPerforceFile(this.baseTmpFilename, this.clientType);
        this.baseTmpFileStream = new P4JRpcOutputStream(this.baseTmpFile, this.charset);
        this.theirTmpFilename = P4JRpcPerforceFile.createTempFileName(this.tmpDir);
        this.theirTmpFile = new P4JRpcPerforceFile(this.theirTmpFilename, this.resultType);
        this.theirTmpFileStream = new P4JRpcOutputStream(this.theirTmpFile, this.charset);
        this.yourTmpFilename = this.clientPath;
        this.yourTmpFile = new P4JRpcPerforceFile(this.yourTmpFilename, this.clientType);
        this.resultTmpFilename = P4JRpcPerforceFile.createTempFileName(this.tmpDir);
        this.resultTmpFile = new P4JRpcPerforceFile(this.resultTmpFilename, this.resultType);
        this.resultTmpFileStream = new P4JRpcOutputStream(this.resultTmpFile, this.charset);
    }

    protected void writeMarker(String markerString) throws IOException {
        if (!this.checkStream(this.resultTmpFileStream)) {
            throw new P4JNullPointerError("bad stream in writeResultChunk");
        }
        this.resultTmpFileStream.writeConverted(markerString.getBytes(P4JCharset.UTF8_NAME));
    }

    protected void writeBaseChunk(byte[] bytes) throws IOException {
        if (!this.checkStream(this.baseTmpFileStream)) {
            throw new P4JNullPointerError("bad stream in writeBaseChunk");
        }
        this.baseTmpFileStream.writeConverted(bytes);
    }

    protected void writeTheirChunk(byte[] bytes) throws IOException {
        if (!this.checkStream(this.theirTmpFileStream)) {
            throw new P4JNullPointerError("bad stream in writeTheirChunk");
        }
        this.theirTmpFileStream.writeConverted(bytes);
    }

    protected void writeYourChunk(byte[] bytes) throws IOException {
    }

    protected void writeResultChunk(byte[] bytes) throws IOException {
        if (!this.checkStream(this.resultTmpFileStream)) {
            throw new P4JNullPointerError("bad stream in writeResultChunk");
        }
        this.resultTmpFileStream.writeConverted(bytes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean finishMerge(P4JRpcClientMerge.ResolveChoice choice) throws IOException {
        boolean succeeded = false;
        try {
            if (this.checkStream(this.resultTmpFileStream)) {
                this.resultTmpFileStream.close();
            }
            if (this.checkStream(this.baseTmpFileStream)) {
                this.baseTmpFileStream.close();
            }
            if (this.checkStream(this.theirTmpFileStream)) {
                this.theirTmpFileStream.close();
            }
            switch (choice) {
                case THEIRS: {
                    succeeded = this.theirTmpFile.renameTo(this.yourTmpFile);
                    break;
                }
                case MERGED: {
                    succeeded = this.resultTmpFile.renameTo(this.yourTmpFile);
                    break;
                }
                case EDIT: {
                    succeeded = this.resultTmpFile.renameTo(this.yourTmpFile);
                    break;
                }
                default: {
                    succeeded = true;
                }
            }
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            try {
                if (this.baseTmpFile != null) {
                    this.baseTmpFile.delete();
                }
                if (this.theirTmpFile != null) {
                    this.theirTmpFile.delete();
                }
                if (this.resultTmpFile != null) {
                    this.resultTmpFile.delete();
                }
            }
            catch (Throwable thr) {
                P4JLog.warn("unexpected exception in closeMerge: " + thr.getLocalizedMessage());
                P4JLog.exception(thr);
            }
            throw throwable;
        }
        try {
            if (this.baseTmpFile != null) {
                this.baseTmpFile.delete();
            }
            if (this.theirTmpFile != null) {
                this.theirTmpFile.delete();
            }
            if (this.resultTmpFile != null) {
                this.resultTmpFile.delete();
            }
        }
        catch (Throwable thr) {
            P4JLog.warn("unexpected exception in closeMerge: " + thr.getLocalizedMessage());
            P4JLog.exception(thr);
        }
        return succeeded;
    }

    protected String getMergeDigestString() {
        if (this.conflictChunks == 0) {
            return new P4JRpcMD5Digester().digestFileAs32ByteHex(this.resultTmpFile, this.charset, true);
        }
        return null;
    }

    protected String getTheirDigestString() {
        return new P4JRpcMD5Digester().digestFileAs32ByteHex(this.theirTmpFile, this.charset, true);
    }

    protected String getYourDigestString() {
        return new P4JRpcMD5Digester().digestFileAs32ByteHex(this.yourTmpFile, this.charset, true);
    }

    protected int incrYourChunks() {
        return ++this.yourChunks;
    }

    protected int theirYourChunks() {
        return ++this.theirChunks;
    }

    protected int incrConflictChunks() {
        return ++this.conflictChunks;
    }

    protected int incrTheirChunks() {
        return ++this.theirChunks;
    }

    protected int incrBothChunks() {
        return ++this.bothChunks;
    }

    protected String getClientPath() {
        return this.clientPath;
    }

    protected void setClientPath(String clientPath) {
        this.clientPath = clientPath;
    }

    protected String getBaseName() {
        return this.baseName;
    }

    protected void setBaseName(String baseName) {
        this.baseName = baseName;
    }

    protected String getTheirName() {
        return this.theirName;
    }

    protected void setTheirName(String theirName) {
        this.theirName = theirName;
    }

    protected String getYourName() {
        return this.yourName;
    }

    protected void setYourName(String yourName) {
        this.yourName = yourName;
    }

    protected String getBaseTmpFilename() {
        return this.baseTmpFilename;
    }

    protected void setBaseTmpFilename(String baseTmpFilename) {
        this.baseTmpFilename = baseTmpFilename;
    }

    protected String getTheirTmpFilename() {
        return this.theirTmpFilename;
    }

    protected void setTheirTmpFilename(String theirTmpFilename) {
        this.theirTmpFilename = theirTmpFilename;
    }

    protected String getYourTmpFilename() {
        return this.yourTmpFilename;
    }

    protected void setYourTmpFilename(String yourTmpFilename) {
        this.yourTmpFilename = yourTmpFilename;
    }

    protected P4JRpcPerforceFile getBaseTmpFile() {
        return this.baseTmpFile;
    }

    protected void setBaseTmpFile(P4JRpcPerforceFile baseTmpFile) {
        this.baseTmpFile = baseTmpFile;
    }

    protected P4JRpcPerforceFile getTheirTmpFile() {
        return this.theirTmpFile;
    }

    protected void setTheirTmpFile(P4JRpcPerforceFile theirTmpFile) {
        this.theirTmpFile = theirTmpFile;
    }

    protected P4JRpcPerforceFile getYourTmpFile() {
        return this.yourTmpFile;
    }

    protected void setYourTmpFile(P4JRpcPerforceFile yourTmpFile) {
        this.yourTmpFile = yourTmpFile;
    }

    protected P4JRpcOutputStream getBaseTmpFileStream() {
        return this.baseTmpFileStream;
    }

    protected void setBaseTmpFileStream(P4JRpcOutputStream baseTmpFileStream) {
        this.baseTmpFileStream = baseTmpFileStream;
    }

    protected P4JRpcOutputStream getYourTmpFileStream() {
        return this.yourTmpFileStream;
    }

    protected void setYourTmpFileStream(P4JRpcOutputStream yourTmpFileStream) {
        this.yourTmpFileStream = yourTmpFileStream;
    }

    protected P4JRpcOutputStream getTheirTmpFileStream() {
        return this.theirTmpFileStream;
    }

    protected void setTheirTmpFileStream(P4JRpcOutputStream theirTmpFileStream) {
        this.theirTmpFileStream = theirTmpFileStream;
    }

    protected int getYourChunks() {
        return this.yourChunks;
    }

    protected void setYourChunks(int yourChunks) {
        this.yourChunks = yourChunks;
    }

    protected int getTheirChunks() {
        return this.theirChunks;
    }

    protected void setTheirChunks(int theirChunks) {
        this.theirChunks = theirChunks;
    }

    protected int getConflictChunks() {
        return this.conflictChunks;
    }

    protected void setConflictChunks(int conflictChunks) {
        this.conflictChunks = conflictChunks;
    }

    protected int getBothChunks() {
        return this.bothChunks;
    }

    protected void setBothChunks(int bothChunks) {
        this.bothChunks = bothChunks;
    }

    protected int getBits() {
        return this.bits;
    }

    protected void setBits(int bits) {
        this.bits = bits;
    }

    protected int getOldBits() {
        return this.oldBits;
    }

    protected void setOldBits(int oldBits) {
        this.oldBits = oldBits;
    }

    protected String getTmpDir() {
        return this.tmpDir;
    }

    protected void setTmpDir(String tmpDir) {
        this.tmpDir = tmpDir;
    }

    protected boolean isExternalStreamMerge() {
        return this.externalStreamMerge;
    }

    protected void setExternalStreamMerge(boolean externalStreamMerge) {
        this.externalStreamMerge = externalStreamMerge;
    }

    protected String getExternalTmpFilename() {
        return this.externalTmpFilename;
    }

    protected void setExternalTmpFilename(String externalTmpFilename) {
        this.externalTmpFilename = externalTmpFilename;
    }

    protected P4JRpcPerforceFile getResultTmpFile() {
        return this.resultTmpFile;
    }

    protected void setResultTmpFile(P4JRpcPerforceFile resultTmpFile) {
        this.resultTmpFile = resultTmpFile;
    }

    protected P4JRpcOutputStream getResultTmpFileStream() {
        return this.resultTmpFileStream;
    }

    protected void setResultTmpFileStream(P4JRpcOutputStream resultTmpFileStream) {
        this.resultTmpFileStream = resultTmpFileStream;
    }

    private boolean checkStream(P4JRpcOutputStream stream) {
        try {
            FileDescriptor fd;
            if (stream != null && (fd = stream.getFD()) != null && fd.valid()) {
                return true;
            }
        }
        catch (IOException ioexc) {
            P4JLog.exception(ioexc);
        }
        return false;
    }

    protected boolean isSafeMerge() {
        return this.safeMerge;
    }

    protected void setSafeMerge(boolean safeMerge) {
        this.safeMerge = safeMerge;
    }

    protected boolean isAutoMerge() {
        return this.autoMerge;
    }

    protected void setAutoMerge(boolean autoMerge) {
        this.autoMerge = autoMerge;
    }

    protected boolean isShowAll() {
        return this.showAll;
    }

    protected void setShowAll(boolean showAll) {
        this.showAll = showAll;
    }
}

