/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.impl.mapbased.rpc;

import com.perforce.p4java.P4JLog;
import com.perforce.p4java.exception.P4JAccessException;
import com.perforce.p4java.exception.P4JConfigException;
import com.perforce.p4java.exception.P4JConnectionException;
import com.perforce.p4java.exception.P4JError;
import com.perforce.p4java.exception.P4JException;
import com.perforce.p4java.exception.P4JNullPointerError;
import com.perforce.p4java.exception.P4JRequestException;
import com.perforce.p4java.impl.mapbased.rpc.P4JRpcServerStats;
import com.perforce.p4java.impl.mapbased.rpc.func.proto.P4JRpcPerformanceMonitor;
import com.perforce.p4java.impl.mapbased.rpc.msg.P4JRpcMessage;
import com.perforce.p4java.impl.mapbased.server.P4JServerImpl;
import com.perforce.p4java.server.P4JServerImplMetadata;
import com.perforce.p4java.server.P4JServerStatus;
import com.perforce.p4java.server.P4JTicketsHelper;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class P4JRpcServerImpl
extends P4JServerImpl {
    public static final P4JServerImplMetadata.ImplType IMPL_TYPE = P4JServerImplMetadata.ImplType.NATIVE_RPC;
    public static final String DEFAULT_PROG_NAME = "p4jrpc";
    public static final String DEFAULT_PROG_VERSION = "Beta 1.0";
    public static final int DEFAULT_CLIENT_API_LEVEL = 65;
    public static final int DEFAULT_SERVER_API_LEVEL = 99999;
    public static final boolean RPC_TAGS_USED = true;
    public static final String RPC_ENV_CWD_KEY = "user.dir";
    public static final String RPC_ENV_OS_NAME_KEY = "os.name";
    public static final String RPC_ENV_WINDOWS_PREFIX = "windows";
    public static final String RPC_ENV_WINDOWS_SPEC = "NT";
    public static final String RPC_ENV_UNIX_SPEC = "UNIX";
    public static final String RPC_ENV_NOCLIENT_SPEC = "unknownclient";
    public static final String RPC_ENV_NOHOST_SPEC = "nohost";
    public static final String RPC_ENV_NOUSER_SPEC = "nouser";
    public static final String TRACE_PREFIX = "P4JRpcServerImpl";
    public static final String RPC_TMP_OUTFILE_STREAM_KEY = "";
    public static final String RPC_TMP_CONVERTER_KEY = "RPC_TMP_CONVERTER_KEY";
    protected String localHostName = null;
    protected String fqdn = null;
    protected int clientApiLevel = 65;
    protected int serverApiLevel = 99999;
    private static final String AUTH_FAIL_STRING_1 = "Single sign-on on client failed";
    private static final String[] accessErrMsgs = new String[]{"Perforce password (P4PASSWD)", "Access for user", "Your session has expired", "Your session was logged out", "Single sign-on on client failed"};
    protected long connectionStart = 0L;
    protected Map<String, Object> serverProtocolMap = new HashMap<String, Object>();
    private P4JRpcPerformanceMonitor perfMonitor = new P4JRpcPerformanceMonitor();
    protected P4JRpcServerStats serverStats = null;
    protected String serverId = null;

    @Override
    public P4JServerStatus init(String host, int port, Properties props) throws P4JConfigException, P4JConnectionException {
        super.init(host, port, props);
        try {
            this.fqdn = InetAddress.getLocalHost().getCanonicalHostName();
            this.localHostName = InetAddress.getLocalHost().getHostName();
            if (this.localHostName == null) {
                throw new P4JNullPointerError("Null client host name in RPC connection init");
            }
            this.serverStats = new P4JRpcServerStats();
        }
        catch (UnknownHostException uhe) {
            throw new P4JConfigException("Unable to determine client host name: " + uhe.getLocalizedMessage());
        }
        return this.status;
    }

    @Override
    public void connect() throws P4JConnectionException, P4JAccessException, P4JRequestException, P4JConfigException {
        this.connectionStart = System.currentTimeMillis();
        super.connect();
    }

    @Override
    public void disconnect() throws P4JConnectionException, P4JAccessException {
        super.disconnect();
        if (this.connectionStart != 0L) {
            P4JLog.stats("RPC connection connected for " + (System.currentTimeMillis() - this.connectionStart) + " msec elapsed time");
        }
        this.serverStats.logStats();
    }

    @Override
    public boolean supportsSmartMove() throws P4JConnectionException, P4JRequestException, P4JAccessException {
        return this.serverVersion >= 20091;
    }

    @Override
    public String getErrorOrInfoStr(Map<String, Object> map) {
        return this.getString(map, 1);
    }

    @Override
    public boolean isInfoMessage(Map<String, Object> map) {
        if (map != null) {
            return P4JRpcMessage.getSeverity((String)map.get("code0")) == 1;
        }
        return false;
    }

    @Override
    public int getSeverityCode(Map<String, Object> map) {
        if (map != null && map.containsKey("code0")) {
            return P4JRpcMessage.getSeverity((String)map.get("code0"));
        }
        return 0;
    }

    @Override
    protected int getGenericCode(Map<String, Object> map) {
        if (map != null && map.containsKey("code0")) {
            return P4JRpcMessage.getGeneric((String)map.get("code0"));
        }
        return 0;
    }

    private String getString(Map<String, Object> map, int minimumCode) {
        if (map != null) {
            int index = 0;
            String code = (String)map.get("code" + index);
            if (code == null) {
                return null;
            }
            boolean foundCode = false;
            StringBuilder codeString = new StringBuilder();
            while (code != null) {
                int severity = P4JRpcMessage.getSeverity(code);
                if (severity >= minimumCode) {
                    foundCode = true;
                    String fmtStr = (String)map.get("fmt" + index);
                    if (fmtStr != null) {
                        if (fmtStr.indexOf(37) != -1) {
                            fmtStr = P4JRpcMessage.interpolateArgs(fmtStr, map);
                        }
                        codeString.insert(0, fmtStr);
                        codeString.insert(fmtStr.length(), '\n');
                    }
                }
                code = (String)map.get("code" + ++index);
            }
            if (foundCode) {
                return codeString.toString();
            }
        }
        return null;
    }

    @Override
    public String getErrorStr(Map<String, Object> map) {
        return this.getString(map, 3);
    }

    @Override
    public String getInfoStr(Map<String, Object> map) {
        String code0;
        int severity;
        if (map != null && (severity = P4JRpcMessage.getSeverity(code0 = (String)map.get("code0"))) == 1) {
            String fmtStr = (String)map.get("fmt0");
            if (fmtStr == null) {
                return RPC_TMP_OUTFILE_STREAM_KEY;
            }
            if (!fmtStr.contains("%")) {
                return fmtStr;
            }
            return P4JRpcMessage.interpolateArgs(fmtStr, map);
        }
        return null;
    }

    @Override
    public boolean isAuthFail(String errStr) {
        if (errStr != null) {
            for (String str : accessErrMsgs) {
                if (!errStr.contains(str)) continue;
                return true;
            }
        }
        return false;
    }

    public int getClientApiLevel() {
        return this.clientApiLevel;
    }

    public void setClientApiLevel(int clientApiLevel) {
        this.clientApiLevel = clientApiLevel;
    }

    public P4JRpcPerformanceMonitor getPerfMonitor() {
        return this.perfMonitor;
    }

    public void setPerfMonitor(P4JRpcPerformanceMonitor perfMonitor) {
        this.perfMonitor = perfMonitor;
    }

    protected String getCwdForEnv() {
        String cwd = this.workingDirectoryPath;
        if (cwd == null) {
            cwd = System.getProperty(RPC_ENV_CWD_KEY);
        }
        if (cwd == null) {
            throw new P4JError("Unable to retrieve current working directory from JVM system properties");
        }
        return cwd;
    }

    protected String getOsTypeForEnv() {
        String osName = System.getProperty(RPC_ENV_OS_NAME_KEY);
        if (osName != null && osName.toLowerCase().contains(RPC_ENV_WINDOWS_PREFIX)) {
            return RPC_ENV_WINDOWS_SPEC;
        }
        return RPC_ENV_UNIX_SPEC;
    }

    protected String getLanguageForEnv() {
        return null;
    }

    protected String getClientNameForEnv() {
        if (this.getClientName() != null) {
            return this.getClientName();
        }
        if (this.localHostName != null) {
            int dotPos = this.localHostName.indexOf(".");
            if (dotPos > 0) {
                return this.localHostName.substring(0, dotPos);
            }
            return this.localHostName;
        }
        return RPC_ENV_NOCLIENT_SPEC;
    }

    protected String getHostForEnv() {
        if (this.localHostName != null) {
            return this.localHostName;
        }
        return RPC_ENV_NOHOST_SPEC;
    }

    protected String getUserForEnv() {
        if (this.getUserName() != null) {
            return this.getUserName();
        }
        return RPC_ENV_NOUSER_SPEC;
    }

    protected void processCmdCallbacks(int cmdCallBackKey, long timeTaken, Map<String, Object>[] retMap) {
        this.commandCallback.completedServerCommand(cmdCallBackKey, timeTaken);
        if (retMap != null) {
            for (Map<String, Object> map : retMap) {
                String str = this.getErrorOrInfoStr(map);
                if (str != null) {
                    str = str.trim();
                }
                int severity = this.getSeverityCode(map);
                int generic = this.getGenericCode(map);
                if (severity != 0) {
                    this.commandCallback.receivedServerMessage(cmdCallBackKey, generic, severity, str);
                }
                if (severity == 1) {
                    this.commandCallback.receivedServerInfoLine(cmdCallBackKey, str);
                    continue;
                }
                if (severity < 3) continue;
                this.commandCallback.receivedServerErrorLine(cmdCallBackKey, str);
            }
        }
    }

    public void saveCurrentTicket() throws P4JException {
        this.saveTicket(this.getAuthTicket());
    }

    public void saveTicket(String ticketValue) throws P4JConfigException {
        P4JConfigException exception;
        block14: {
            String ticketsFile = System.getenv("P4TICKETS");
            if (ticketsFile == null) {
                ticketsFile = this.getP4TicketsOSLocation();
            }
            exception = null;
            if (ticketsFile != null) {
                String name = this.getUserName();
                String serverId = this.getServerId();
                if (serverId != null) {
                    try {
                        P4JTicketsHelper.saveTicket(name, serverId, ticketValue, ticketsFile);
                    }
                    catch (IOException e) {
                        exception = new P4JConfigException(e);
                    }
                }
                if (ticketValue == null || serverId == null) {
                    String server = null;
                    if (this.serverHost != null) {
                        server = this.serverHost;
                        if (this.serverPort != -1) {
                            server = server + ":" + Integer.toString(this.serverPort);
                        }
                    } else if (this.serverPort != -1) {
                        server = Integer.toString(this.serverPort);
                    }
                    if (server != null) {
                        try {
                            P4JTicketsHelper.saveTicket(name, server, ticketValue, ticketsFile);
                        }
                        catch (IOException e) {
                            if (exception != null) break block14;
                            exception = new P4JConfigException(e);
                        }
                    }
                }
            }
        }
        if (exception != null) {
            throw exception;
        }
    }

    public String loadTicket(String serverId) {
        String ticketValue = null;
        String name = this.getUserName();
        if (name != null) {
            String ticketsLocation = this.props.getProperty("ticketPath", this.props.getProperty("com.perforce.p4java.ticketPath"));
            if (ticketsLocation == null) {
                ticketsLocation = System.getenv("P4TICKETS");
            }
            if (ticketsLocation == null) {
                ticketsLocation = this.getP4TicketsOSLocation();
            }
            if (ticketsLocation != null) {
                try {
                    ticketValue = P4JTicketsHelper.getTicketValue(name, serverId, ticketsLocation);
                }
                catch (IOException e) {
                    ticketValue = null;
                }
                if (ticketValue == null) {
                    String server = null;
                    if (this.serverHost != null) {
                        server = this.serverHost;
                        if (this.serverPort != -1) {
                            server = server + ":" + Integer.toString(this.serverPort);
                        }
                    } else if (this.serverPort != -1) {
                        server = Integer.toString(this.serverPort);
                    }
                    try {
                        ticketValue = P4JTicketsHelper.getTicketValue(name, server, ticketsLocation);
                    }
                    catch (IOException e) {
                        ticketValue = null;
                    }
                }
            }
        }
        return ticketValue;
    }

    public void setServerId(String serverId) {
        this.serverId = serverId;
    }

    public String getServerId() {
        return this.serverId;
    }
}

