/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.impl.generic.core;

import com.perforce.p4java.core.P4JServerResource;
import com.perforce.p4java.exception.P4JAccessException;
import com.perforce.p4java.exception.P4JConnectionException;
import com.perforce.p4java.exception.P4JRequestException;
import com.perforce.p4java.exception.P4JUnimplementedError;
import com.perforce.p4java.server.P4JServer;

public abstract class P4JServerResourceImpl
implements P4JServerResource {
    protected boolean complete = true;
    protected boolean completable = false;
    protected boolean refreshable = false;
    protected boolean updateable = false;
    protected P4JServer server = null;

    protected P4JServerResourceImpl() {
    }

    protected P4JServerResourceImpl(P4JServer server) {
        this.server = server;
    }

    protected P4JServerResourceImpl(boolean complete, boolean completable, boolean refreshable, boolean updateable) {
        this(complete, completable, refreshable, updateable, null);
    }

    protected P4JServerResourceImpl(boolean complete, boolean completable, boolean refreshable, boolean updateable, P4JServer server) {
        this(server);
        this.complete = complete;
        this.completable = completable;
        this.refreshable = refreshable;
        this.updateable = updateable;
    }

    public boolean canComplete() {
        return this.completable && this.server != null;
    }

    public boolean canRefresh() {
        return this.refreshable && this.server != null;
    }

    public boolean canUpdate() {
        return this.updateable && this.server != null;
    }

    public void complete() throws P4JConnectionException, P4JRequestException, P4JAccessException {
        throw new P4JUnimplementedError("called default P4JServerResourceImpl.complete");
    }

    public boolean isComplete() {
        return this.complete;
    }

    public void refresh() throws P4JConnectionException, P4JRequestException, P4JAccessException {
        throw new P4JUnimplementedError("called default P4JServerResourceImpl.refresh");
    }

    public void update() throws P4JConnectionException, P4JRequestException, P4JAccessException {
        throw new P4JUnimplementedError("called default P4JServerResourceImpl.update");
    }

    public void setComplete(boolean complete) {
        this.complete = complete;
    }

    public void setCompletable(boolean completable) {
        this.completable = completable;
    }

    public void setRefreshable(boolean refreshable) {
        this.refreshable = refreshable;
    }
}

