/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.core.file;

import com.perforce.p4java.P4JLog;
import com.perforce.p4java.exception.P4JError;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum P4JFileAction {
    ADD,
    BRANCH,
    EDIT,
    INTEGRATE,
    DELETE,
    SYNC,
    UPDATED,
    ADDED,
    REFRESHED,
    IGNORED,
    ABANDONED,
    EDIT_IGNORED,
    MOVE,
    MOVE_ADD,
    MOVE_DELETE;

    private static final String[] names;

    public static P4JFileAction fromString(String str) {
        if (str != null) {
            for (String name : names) {
                if (name == null || !name.equalsIgnoreCase(str)) continue;
                try {
                    return P4JFileAction.valueOf(name.toUpperCase().replace('/', '_'));
                }
                catch (IllegalArgumentException iae) {
                    P4JLog.error("Bad conversion attempt in P4JFileAction.fromString; string: " + str + "; message: " + iae.getMessage());
                    P4JLog.exception(iae);
                    throw new P4JError("Bad conversion attempt in P4JFileAction.fromString: " + iae.getMessage(), iae);
                }
            }
        }
        return null;
    }

    public String toString() {
        int ord = this.ordinal();
        if (ord >= names.length) {
            throw new P4JError("name / ordinal mismatch in P4JFileAction.toString; ord: " + ord + "; names.length: " + names.length);
        }
        return names[ord];
    }

    static {
        names = new String[]{"add", "branch", "edit", "integrate", "delete", "sync", "updated", "added", "refreshed", "ignored", "abandoned", "edit/ignored", "move", "move/add", "move/delete"};
    }
}

