/*
 * Decompiled with CFR 0.152.
 */
package com.payu.india.Payu;

import android.app.Activity;
import android.content.Context;
import android.content.SharedPreferences;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Build;
import android.telephony.CellInfo;
import android.telephony.CellInfoCdma;
import android.telephony.CellInfoGsm;
import android.telephony.CellInfoLte;
import android.telephony.CellInfoWcdma;
import android.telephony.CellSignalStrengthCdma;
import android.telephony.CellSignalStrengthGsm;
import android.telephony.CellSignalStrengthLte;
import android.telephony.CellSignalStrengthWcdma;
import android.telephony.TelephonyManager;
import android.util.DisplayMetrics;
import com.payu.india.Model.PayuConfig;
import com.payu.india.Model.PostData;
import com.payu.india.Model.StoredCard;
import com.payu.india.Tasks.PayuUploadDeviceAnalytics;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.json.JSONObject;

public class PayuUtils {
    public static Set<String> SBI_MAES_BIN = new HashSet<String>();
    private static String keyAnalyticsUtil;

    public Boolean validateCardNumber(String cardNumber) {
        if (cardNumber.length() < 12) {
            return false;
        }
        if (this.getIssuer(cardNumber).contentEquals("RUPAY") && cardNumber.length() == 16) {
            return this.luhn(cardNumber);
        }
        if (this.getIssuer(cardNumber).contentEquals("VISA") && cardNumber.length() == 16) {
            return this.luhn(cardNumber);
        }
        if (this.getIssuer(cardNumber).contentEquals("MAST") && cardNumber.length() == 16) {
            return this.luhn(cardNumber);
        }
        if ((this.getIssuer(cardNumber).contentEquals("MAES") || this.getIssuer(cardNumber).contentEquals("SMAE")) && cardNumber.length() >= 12 && cardNumber.length() <= 19) {
            return this.luhn(cardNumber);
        }
        if (this.getIssuer(cardNumber).contentEquals("DINR") && cardNumber.length() == 14) {
            return this.luhn(cardNumber);
        }
        if (this.getIssuer(cardNumber).contentEquals("AMEX") && cardNumber.length() == 15) {
            return this.luhn(cardNumber);
        }
        if (this.getIssuer(cardNumber).contentEquals("JCB") && cardNumber.length() == 16) {
            return this.luhn(cardNumber);
        }
        return false;
    }

    public Boolean luhn(String cardNumber) {
        int sum = 0;
        boolean alternate = false;
        for (int i = cardNumber.length() - 1; i >= 0; --i) {
            int n = Integer.parseInt(cardNumber.substring(i, i + 1));
            if (alternate && (n *= 2) > 9) {
                n = n % 10 + 1;
            }
            sum += n;
            alternate = !alternate;
        }
        if (sum % 10 == 0) {
            return true;
        }
        return false;
    }

    public String getIssuer(String mCardNumber) {
        if (mCardNumber.startsWith("4")) {
            return "VISA";
        }
        if (mCardNumber.matches("^508[5-9][0-9][0-9]|60698[5-9]|60699[0-9]|607[0-8][0-9][0-9]|6079[0-7][0-9]|60798[0-4]|(?!608000)608[0-4][0-9][0-9]|608500|6521[5-9][0-9]|652[2-9][0-9][0-9]|6530[0-9][0-9]|6531[0-4][0-9]")) {
            return "RUPAY";
        }
        if (mCardNumber.matches("^((6304)|(6706)|(6771)|(6709))[\\d]+")) {
            return "LASER";
        }
        if (mCardNumber.matches("6(?:011|5[0-9]{2})[0-9]{12}[\\d]+")) {
            return "LASER";
        }
        if (mCardNumber.matches("(5[06-8]|6\\d)\\d{14}(\\d{2,3})?[\\d]+") || mCardNumber.matches("(5[06-8]|6\\d)[\\d]+") || mCardNumber.matches("((504([435|645|774|775|809|993]))|(60([0206]|[3845]))|(622[018])\\d)[\\d]+")) {
            if (mCardNumber.length() >= 6 && SBI_MAES_BIN.contains(mCardNumber.substring(0, 6))) {
                return "SMAE";
            }
            return "MAES";
        }
        if (mCardNumber.matches("^5[1-5][\\d]+")) {
            return "MAST";
        }
        if (mCardNumber.matches("^3[47][\\d]+")) {
            return "AMEX";
        }
        if (mCardNumber.startsWith("36") || mCardNumber.matches("^30[0-5][\\d]+") || mCardNumber.matches("2(014|149)[\\d]+")) {
            return "DINR";
        }
        if (mCardNumber.matches("^35(2[89]|[3-8][0-9])[\\d]+")) {
            return "JCB";
        }
        return "";
    }

    public boolean validateCvv(String cardNumber, String cvv) {
        String issuer = this.getIssuer(cardNumber);
        if (issuer.contentEquals("SMAE")) {
            return true;
        }
        if (issuer.contentEquals("AMEX") & cvv.length() == 4) {
            return true;
        }
        return !issuer.contentEquals("AMEX") && cvv.length() == 3;
    }

    public boolean validateExpiry(int expiryMonth, int expiryYear) {
        Calendar calendar = Calendar.getInstance();
        if (expiryMonth < 1 || expiryMonth > 12 || String.valueOf(expiryYear).length() != 4) {
            return false;
        }
        return calendar.get(1) <= expiryYear && (calendar.get(1) != expiryYear || calendar.get(2) + 1 <= expiryMonth);
    }

    protected String concatParams(String key, String value) {
        return key + "=" + value + "&";
    }

    protected PostData getReturnData(String result) {
        return this.getReturnData(5001, "ERROR", result);
    }

    protected PostData getReturnData(int code, String result) {
        return this.getReturnData(code, "ERROR", result);
    }

    protected PostData getReturnData(int code, String status, String result) {
        PostData postData = new PostData();
        postData.setCode(code);
        postData.setStatus(status);
        postData.setResult(result);
        return postData;
    }

    protected String trimAmpersand(String data) {
        return data.charAt(data.length() - 1) == '&' ? data.substring(0, data.length() - 1) : data;
    }

    static String getNetworkStatus(Activity activity) {
        try {
            if (null != activity && !activity.isFinishing()) {
                ConnectivityManager cm = (ConnectivityManager)activity.getSystemService("connectivity");
                NetworkInfo info = cm.getActiveNetworkInfo();
                if (info == null || !info.isConnected()) {
                    return "Not connected";
                }
                if (info.getType() == 1) {
                    return "WIFI";
                }
                if (info.getType() == 0) {
                    int networkType = info.getSubtype();
                    switch (networkType) {
                        case 1: {
                            return "GPRS";
                        }
                        case 2: {
                            return "EDGE";
                        }
                        case 4: {
                            return "CDMA";
                        }
                        case 7: 
                        case 11: {
                            return "2G";
                        }
                        case 3: 
                        case 5: 
                        case 6: 
                        case 8: 
                        case 9: 
                        case 10: {
                            return "HSPA";
                        }
                        case 12: 
                        case 14: 
                        case 15: {
                            return "3G";
                        }
                        case 13: {
                            return "4G";
                        }
                    }
                    return "?";
                }
            }
        }
        catch (Exception e) {
            return "?";
        }
        return "?";
    }

    private String getDeviceDensity(Activity activity) {
        DisplayMetrics metrics = new DisplayMetrics();
        activity.getWindowManager().getDefaultDisplay().getMetrics(metrics);
        return metrics.densityDpi + "";
    }

    private int getNetworkStrength(Activity activity) {
        try {
            ConnectivityManager connectivityManager = (ConnectivityManager)activity.getSystemService("connectivity");
            NetworkInfo[] netInfo = connectivityManager.getAllNetworkInfo();
            TelephonyManager telephonyManager = (TelephonyManager)activity.getSystemService("phone");
            int strength = 0;
            for (NetworkInfo networkInfo : netInfo) {
                if (Build.VERSION.SDK_INT < 18 || !networkInfo.getTypeName().equalsIgnoreCase("MOBILE") || !networkInfo.isConnected()) continue;
                for (CellInfo info : telephonyManager.getAllCellInfo()) {
                    if (!info.isRegistered()) continue;
                    if (info instanceof CellInfoGsm) {
                        CellSignalStrengthGsm gsm = ((CellInfoGsm)info).getCellSignalStrength();
                        strength = gsm.getDbm();
                        continue;
                    }
                    if (info instanceof CellInfoCdma) {
                        CellSignalStrengthCdma cdma = ((CellInfoCdma)info).getCellSignalStrength();
                        strength = cdma.getDbm();
                        continue;
                    }
                    if (info instanceof CellInfoLte) {
                        CellSignalStrengthLte lte = ((CellInfoLte)info).getCellSignalStrength();
                        strength = lte.getDbm();
                        continue;
                    }
                    if (!(info instanceof CellInfoWcdma)) continue;
                    CellSignalStrengthWcdma wcdma = ((CellInfoWcdma)info).getCellSignalStrength();
                    strength = wcdma.getDbm();
                }
            }
            return strength;
        }
        catch (Exception e) {
            return 0;
        }
    }

    public void deviceAnalytics(Activity activity, String cbVersion, String merchantKey, String transactionId) {
        JSONObject deviceDetails = new JSONObject();
        try {
            deviceDetails.put("resolution", (Object)(this.getDeviceDensity(activity) + ""));
            deviceDetails.put("device_manufacturer", (Object)Build.MANUFACTURER);
            deviceDetails.put("device_model", (Object)Build.MODEL);
            if (keyAnalyticsUtil != null && !keyAnalyticsUtil.trim().equals("")) {
                deviceDetails.put("merchant_key", (Object)keyAnalyticsUtil);
            } else {
                deviceDetails.put("merchant_key", (Object)merchantKey);
            }
            deviceDetails.put("txnid", (Object)transactionId);
            deviceDetails.put("sdk_version", (Object)"4.3.4");
            deviceDetails.put("cb_version", (Object)cbVersion);
            deviceDetails.put("os_version", (Object)(Build.VERSION.SDK_INT + ""));
            deviceDetails.put("network_info", (Object)(PayuUtils.getNetworkStatus(activity) + ""));
            deviceDetails.put("network_strength", (Object)(this.getNetworkStrength(activity) + ""));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        new PayuUploadDeviceAnalytics(activity, "sdk_local_cache_device").log(deviceDetails.toString());
    }

    public void storeInSharedPreferences(Context context, String key, String value) {
        SharedPreferences sharedPreferences = context.getSharedPreferences("PayuPreference", 0);
        SharedPreferences.Editor editor = sharedPreferences.edit();
        editor.putString(key, value);
        editor.commit();
    }

    public String getFromSharedPreferences(Context context, String key) {
        return this.getFromSharedPreferences(context, key, "default");
    }

    public String getFromSharedPreferences(Context context, String key, String defaultValue) {
        SharedPreferences sharedPreferences = context.getSharedPreferences("PayuPreference", 0);
        return sharedPreferences.getString(key, defaultValue);
    }

    public void removeFromSharedPreferences(Context context, String key) {
        SharedPreferences sharedPreferences = context.getSharedPreferences("PayuPreference", 0);
        SharedPreferences.Editor editor = sharedPreferences.edit();
        editor.remove(key);
        editor.apply();
    }

    public HashMap<String, ArrayList<StoredCard>> getStoredCard(Context context, ArrayList<StoredCard> cardList) {
        ArrayList<StoredCard> oneClickCards = new ArrayList<StoredCard>();
        ArrayList<StoredCard> storedCards = new ArrayList<StoredCard>();
        HashMap<String, ArrayList<StoredCard>> cardMap = new HashMap<String, ArrayList<StoredCard>>();
        SharedPreferences sharedPreferences = context.getSharedPreferences("PayuPreference", 0);
        if (null != cardList) {
            for (StoredCard card : cardList) {
                if (card.getEnableOneClickPayment() == 1 && !sharedPreferences.getString(card.getCardToken(), "default").contains("default") || this.getIssuer(card.getCardBin()).contentEquals("SMAE")) {
                    oneClickCards.add(card);
                    continue;
                }
                storedCards.add(card);
            }
        }
        cardMap.put("one_click_checkout", oneClickCards);
        cardMap.put("store_card", storedCards);
        return cardMap;
    }

    public HashMap<String, ArrayList<StoredCard>> getStoredCard(ArrayList<StoredCard> cardList, HashMap<String, String> oneClickCardTokens) {
        ArrayList<StoredCard> oneClickCards = new ArrayList<StoredCard>();
        ArrayList<StoredCard> storedCards = new ArrayList<StoredCard>();
        HashMap<String, ArrayList<StoredCard>> cardMap = new HashMap<String, ArrayList<StoredCard>>();
        if (null != cardList) {
            for (StoredCard card : cardList) {
                if (null != oneClickCardTokens && card.getEnableOneClickPayment() == 1 && oneClickCardTokens.containsKey(card.getCardToken()) || this.getIssuer(card.getCardBin()).contentEquals("SMAE")) {
                    oneClickCards.add(card);
                    continue;
                }
                storedCards.add(card);
            }
        }
        cardMap.put("one_click_checkout", oneClickCards);
        cardMap.put("store_card", storedCards);
        return cardMap;
    }

    public static void setAnalyticsKeyCB(PayuConfig payuConfig) {
        String analyticsKey = PayuUtils.getAnalyticsKeyFromConfig(payuConfig);
        PayuUtils.setAnalyticsKeyCB(analyticsKey);
    }

    public static void setAnalyticsKeyCB(String analyticsKey) {
        try {
            if (analyticsKey != null && !analyticsKey.trim().equals("")) {
                keyAnalyticsUtil = analyticsKey;
                Class<?> aClass = Class.forName("com.payu.custombrowser.Bank");
                Field field = aClass.getDeclaredField("keyAnalytics");
                field.setAccessible(true);
                field.set(null, analyticsKey);
                field.setAccessible(false);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static String getAnalyticsKeyFromConfig(PayuConfig payuConfig) {
        try {
            String[] list = payuConfig.getData().split("&");
            Object merchantKey = null;
            for (String item : list) {
                String id;
                String[] items = item.split("=");
                if (items.length < 2) continue;
                switch (id = items[0]) {
                    case "key": {
                        return items[1];
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    static {
        SBI_MAES_BIN.add("504435");
        SBI_MAES_BIN.add("504645");
        SBI_MAES_BIN.add("504775");
        SBI_MAES_BIN.add("504809");
        SBI_MAES_BIN.add("504993");
        SBI_MAES_BIN.add("600206");
        SBI_MAES_BIN.add("603845");
        SBI_MAES_BIN.add("622018");
        SBI_MAES_BIN.add("504774");
    }
}

