package com.payu.otpparser

import android.content.BroadcastReceiver
import android.content.Context
import android.content.Intent
import android.os.Build
import android.telephony.SmsMessage
import com.google.android.gms.auth.api.phone.SmsRetriever
import com.google.android.gms.common.api.CommonStatusCodes
import com.google.android.gms.common.api.Status


class SMSReceiver(var smsBroadcastReceiverListener: SmsBroadcastReceiverListener) :
    BroadcastReceiver() {
    private var isConsentFired: Boolean = false

    override fun onReceive(context: Context?, intent: Intent?) {
        if (intent?.action == SmsRetriever.SMS_RETRIEVED_ACTION) {
            val extras = intent.extras
            val smsRetrieverStatus = extras?.get(SmsRetriever.EXTRA_STATUS) as Status
            L.v("smsRetrieverStatus -"+smsRetrieverStatus.statusCode)
            when (smsRetrieverStatus.statusCode) {
                        CommonStatusCodes.SUCCESS -> {
                        extras.getParcelable<Intent>(SmsRetriever.EXTRA_CONSENT_INTENT).also {
                            smsBroadcastReceiverListener.onSuccess(it)
                        }
                }

                CommonStatusCodes.TIMEOUT -> {
                    smsBroadcastReceiverListener.onFailure()
                }
            }
        } else {
            val msgs: Array<SmsMessage?>
            var msgBody = ""
            val pdus = intent?.extras?.get("pdus") as Array<Any>
            if (pdus != null) {
                msgs = arrayOfNulls<SmsMessage>(pdus.size)
                for (i in msgs.indices) {
                    if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.M) {
                        val format: String? = intent.extras?.getString("format")
                        msgs[i] = SmsMessage.createFromPdu(pdus[i] as ByteArray, format)
                    } else {
                        msgs[i] = SmsMessage.createFromPdu(pdus[i] as ByteArray)
                    }
                    //  msgs[i] = SmsMessage.createFromPdu((byte[]) pdus[i]);
                    msgBody += msgs[i]?.getMessageBody()
                }
            }
            smsBroadcastReceiverListener.onSuccess(msgBody)
        }
    }

    interface SmsBroadcastReceiverListener {
        fun onSuccess(intent: Intent?)
        fun onSuccess(message: String?)
        fun onFailure()
    }
}
