package com.payu.custombrowser.bean;

import android.os.Parcel;
import android.os.Parcelable;

import com.payu.custombrowser.util.CBConstant;

/**
 * Created by franklin.michael on 24/06/16.
 *
 * Simple bean to contain network api call data.
 * it contains http method, url, postData, and content type.
 * default method is GET and contentType is HTTP_URLENCODED.
 */

public class CustomBrowserAsyncTaskData implements Parcelable {

    protected CustomBrowserAsyncTaskData(Parcel in) {
        httpMethod = in.readString();
        url = in.readString();
        postData = in.readString();
        contentType = in.readString();
    }

    public static final Creator<CustomBrowserAsyncTaskData> CREATOR = new Creator<CustomBrowserAsyncTaskData>() {
        @Override
        public CustomBrowserAsyncTaskData createFromParcel(Parcel in) {
            return new CustomBrowserAsyncTaskData(in);
        }

        @Override
        public CustomBrowserAsyncTaskData[] newArray(int size) {
            return new CustomBrowserAsyncTaskData[size];
        }
    };

    public CustomBrowserAsyncTaskData(){
        this.httpMethod = "GET";
        this.contentType = CBConstant.HTTP_URLENCODED;
    }

    public String getHttpMethod() {
        return httpMethod;
    }

    public void setHttpMethod(String httpMethod) {
        this.httpMethod = httpMethod;
    }

    public String getUrl() {
        return url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getPostData() {
        return postData;
    }

    public void setPostData(String postData) {
        this.postData = postData;
    }

    public String getContentType() {
        return contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    private String httpMethod;
    private String url;
    private String postData;
    private String contentType;

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel parcel, int i) {
        parcel.writeString(httpMethod);
        parcel.writeString(url);
        parcel.writeString(postData);
        parcel.writeString(contentType);
    }
}
