package com.paystack.android.ui.paymentchannels.mobilemoney.mpesa.paymenterror

import androidx.compose.foundation.layout.Column
import androidx.compose.foundation.layout.Spacer
import androidx.compose.foundation.layout.fillMaxSize
import androidx.compose.foundation.layout.fillMaxWidth
import androidx.compose.foundation.layout.height
import androidx.compose.foundation.layout.padding
import androidx.compose.material3.Surface
import androidx.compose.runtime.Composable
import androidx.compose.ui.Alignment
import androidx.compose.ui.Modifier
import androidx.compose.ui.graphics.Color
import androidx.compose.ui.res.stringResource
import androidx.compose.ui.tooling.preview.Preview
import com.paystack.android.ui.R
import com.paystack.android.ui.components.PaymentErrorUi
import com.paystack.android.ui.components.buttons.PrimaryButton
import com.paystack.android.ui.components.buttons.SecondaryButton
import com.paystack.androiddesignsystem.PaystackTheme

@Composable
internal fun MpesaPaymentErrorUi(
    message: String,
    onSwitchToOffline: () -> Unit,
    onRetrySameNumber: () -> Unit,
    onTryAnotherNumber: () -> Unit,
    modifier: Modifier = Modifier
) {
    Column(
        modifier = modifier
            .fillMaxWidth()
            .padding(PaystackTheme.dimensions.spacing.double),
        horizontalAlignment = Alignment.CenterHorizontally
    ) {
        PaymentErrorUi(
            message = message,
            modifier = modifier
        )

        Spacer(Modifier.height(PaystackTheme.dimensions.spacing.double))

        PrimaryButton(
            buttonText = stringResource(id = R.string.pstk_switch_to_mpesa_pay_bill),
            onClick = { onSwitchToOffline() },
            isEnabled = true
        )
        Spacer(Modifier.height(PaystackTheme.dimensions.spacing.double))

        SecondaryButton(
            text = stringResource(id = R.string.pstk_retry_mpesa_payment_with_same_number),
            onClick = onRetrySameNumber,
            modifier = Modifier.fillMaxWidth(),
            borderColor = PaystackTheme.colors.neutralColors.silver,
            contentColor = PaystackTheme.colors.primaryColors.navy01
        )

        Spacer(Modifier.height(PaystackTheme.dimensions.spacing.double))

        SecondaryButton(
            text = stringResource(id = R.string.pstk_try_mpesa_payment_with_another_number),
            onClick = onTryAnotherNumber,
            modifier = Modifier.fillMaxWidth(),
            showBorder = false,
            contentColor = PaystackTheme.colors.primaryColors.navy01
        )
    }
}

@Preview
@Composable
private fun MpesaPaymentErrorUiPreview() {
    PaystackTheme {
        Surface(color = Color.White) {
            Column(Modifier.fillMaxSize()) {
                MpesaPaymentErrorUi("Unable to reach your phone. Please, try again", {}, {}, {})
            }
        }
    }
}
