package com.paystack.android.ui

import android.os.Parcelable
import com.paystack.android.core.api.models.PaymentChannel
import kotlinx.parcelize.Parcelize

internal sealed class PaymentProcessState : Parcelable {
    @Parcelize
    object SelectPaymentChannel : PaymentProcessState()

    @Parcelize
    data class PaymentChannelProcess(
        val selectedPaymentChannel: PaymentChannel,
        val providerKey: String,
    ) : PaymentProcessState()

    @Parcelize
    data class Error(val error: Throwable) : PaymentProcessState()
}
