/*
 * Decompiled with CFR 0.152.
 */
package com.paystack.android.ui.paymentchannels.card.cardform.models;

import com.paystack.android.ui.components.views.inputs.validators.CardExpirationDateFormatter;
import com.paystack.android.ui.components.views.inputs.validators.CardType;
import com.paystack.android.ui.components.views.inputs.validators.CardValidationUtils;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0010\b\n\u0002\b\u0002\b\u0080\b\u0018\u00002\u00020\u0001B#\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0003H\u00c6\u0003J'\u0010\u0018\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0019\u001a\u00020\u00102\b\u0010\u001a\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001b\u001a\u00020\u001cH\u00d6\u0001J\t\u0010\u001d\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\bR\u0011\u0010\u000b\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0011R\u0011\u0010\u0013\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0011R\u0011\u0010\u0014\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0011\u00a8\u0006\u001e"}, d2={"Lcom/paystack/android/ui/paymentchannels/card/cardform/models/CardFormData;", "", "cardNumber", "", "cardExpiry", "cardCVV", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getCardCVV", "()Ljava/lang/String;", "getCardExpiry", "getCardNumber", "cardType", "Lcom/paystack/android/ui/components/views/inputs/validators/CardType;", "getCardType", "()Lcom/paystack/android/ui/components/views/inputs/validators/CardType;", "isCardNumberValid", "", "()Z", "isCvvValid", "isExpiryDateValid", "isValid", "component1", "component2", "component3", "copy", "equals", "other", "hashCode", "", "toString", "paystack-ui_release"})
public final class CardFormData {
    @NotNull
    private final String cardNumber;
    @NotNull
    private final String cardExpiry;
    @NotNull
    private final String cardCVV;

    public CardFormData(@NotNull String cardNumber, @NotNull String cardExpiry, @NotNull String cardCVV) {
        Intrinsics.checkNotNullParameter((Object)cardNumber, (String)"cardNumber");
        Intrinsics.checkNotNullParameter((Object)cardExpiry, (String)"cardExpiry");
        Intrinsics.checkNotNullParameter((Object)cardCVV, (String)"cardCVV");
        this.cardNumber = cardNumber;
        this.cardExpiry = cardExpiry;
        this.cardCVV = cardCVV;
    }

    public /* synthetic */ CardFormData(String string2, String string3, String string4, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string2 = "";
        }
        if ((n & 2) != 0) {
            string3 = "";
        }
        if ((n & 4) != 0) {
            string4 = "";
        }
        this(string2, string3, string4);
    }

    @NotNull
    public final String getCardNumber() {
        return this.cardNumber;
    }

    @NotNull
    public final String getCardExpiry() {
        return this.cardExpiry;
    }

    @NotNull
    public final String getCardCVV() {
        return this.cardCVV;
    }

    public final boolean isCardNumberValid() {
        return CardValidationUtils.INSTANCE.isCardValid(this.cardNumber);
    }

    public final boolean isExpiryDateValid() {
        String formattedExpiryDate = CardExpirationDateFormatter.INSTANCE.formatEnteredCardDate(this.cardExpiry);
        return CardValidationUtils.INSTANCE.isCardExpiryDateValid(formattedExpiryDate);
    }

    @NotNull
    public final CardType getCardType() {
        return CardValidationUtils.INSTANCE.checkCardScheme(this.cardNumber);
    }

    public final boolean isCvvValid() {
        return this.cardCVV.length() == this.getCardType().getMaxCvvLength();
    }

    public final boolean isValid() {
        return this.isCardNumberValid() && this.isExpiryDateValid() && this.isCvvValid();
    }

    @NotNull
    public final String component1() {
        return this.cardNumber;
    }

    @NotNull
    public final String component2() {
        return this.cardExpiry;
    }

    @NotNull
    public final String component3() {
        return this.cardCVV;
    }

    @NotNull
    public final CardFormData copy(@NotNull String cardNumber, @NotNull String cardExpiry, @NotNull String cardCVV) {
        Intrinsics.checkNotNullParameter((Object)cardNumber, (String)"cardNumber");
        Intrinsics.checkNotNullParameter((Object)cardExpiry, (String)"cardExpiry");
        Intrinsics.checkNotNullParameter((Object)cardCVV, (String)"cardCVV");
        return new CardFormData(cardNumber, cardExpiry, cardCVV);
    }

    public static /* synthetic */ CardFormData copy$default(CardFormData cardFormData, String string2, String string3, String string4, int n, Object object) {
        if ((n & 1) != 0) {
            string2 = cardFormData.cardNumber;
        }
        if ((n & 2) != 0) {
            string3 = cardFormData.cardExpiry;
        }
        if ((n & 4) != 0) {
            string4 = cardFormData.cardCVV;
        }
        return cardFormData.copy(string2, string3, string4);
    }

    @NotNull
    public String toString() {
        return "CardFormData(cardNumber=" + this.cardNumber + ", cardExpiry=" + this.cardExpiry + ", cardCVV=" + this.cardCVV + ")";
    }

    public int hashCode() {
        int result = this.cardNumber.hashCode();
        result = result * 31 + this.cardExpiry.hashCode();
        result = result * 31 + this.cardCVV.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof CardFormData)) {
            return false;
        }
        CardFormData cardFormData = (CardFormData)other;
        if (!Intrinsics.areEqual((Object)this.cardNumber, (Object)cardFormData.cardNumber)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.cardExpiry, (Object)cardFormData.cardExpiry)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.cardCVV, (Object)cardFormData.cardCVV);
    }

    public CardFormData() {
        this(null, null, null, 7, null);
    }
}

