package com.paystack.android.ui.paymentchannels.mobilemoney.mpesa.numberform

import com.paystack.android.core.api.models.MobileMoneyChannelOption
import com.paystack.android.ui.utilities.CurrencyFormatter

internal data class MpesaNumberFormState(
    val amount: Long,
    val currency: String,
    val providers: List<MobileMoneyChannelOption>,
    val providerKey: String,
    val phoneNumber: String = "",
    val isProcessing: Boolean = false,
) {
    val amountText: String
        get() = CurrencyFormatter.format(amount, currency)
    private val channelOption: MobileMoneyChannelOption
        get() = providers.first { it.key == providerKey }
            .copy(
                phoneNumberRegex =
                if (providerKey.equals(MPESA_KEY, ignoreCase = true)) KE_PHONE_NUMBER_REGEX
                else channelOption.phoneNumberRegex
            )

    val isPhoneNumberValid: Boolean
        get() = Regex(channelOption.phoneNumberRegex).matches(phoneNumber)

    companion object {
        private const val MPESA_KEY = "MPESA"
        private const val KE_PHONE_NUMBER_REGEX =
            "(\\+254|254|0|^)([7][0-9]|[1][0-1]){1}[0-9]{1}[0-9]{6}"
    }
}
