package com.paystack.android.ui.components.views.inputs

import androidx.compose.foundation.clickable
import androidx.compose.foundation.layout.Box
import androidx.compose.foundation.layout.fillMaxWidth
import androidx.compose.foundation.layout.padding
import androidx.compose.material3.Text
import androidx.compose.runtime.Composable
import androidx.compose.ui.Modifier
import com.paystack.androiddesignsystem.PaystackTheme

@Composable
fun DropDownMenuItem(
    text: String,
    onClick: () -> Unit
) {
    Box(modifier = Modifier
        .clickable { onClick() }
        .fillMaxWidth()
        .padding(PaystackTheme.dimensions.spacing.double)) {
        Text(text = text, style = PaystackTheme.typography.body.body14M)
    }
}
