package com.paystack.android.ui.paymentchannels.card.auth.pin

import androidx.lifecycle.ViewModel
import androidx.lifecycle.viewModelScope
import com.paystack.android.core.api.models.AccessCodeData
import com.paystack.android.ui.data.transaction.TransactionRepository
import com.paystack.android.ui.models.Charge
import kotlinx.coroutines.flow.MutableStateFlow
import kotlinx.coroutines.flow.asStateFlow
import kotlinx.coroutines.flow.update
import kotlinx.coroutines.launch

internal const val PIN_LENGTH = 4

internal class PinFormViewModel(
    private val transactionAccessData: AccessCodeData,
    private val transactionRepository: TransactionRepository,
) : ViewModel() {
    private val _pin = MutableStateFlow("")
    val pin = _pin.asStateFlow()

    private val _isSubmittingPin = MutableStateFlow(false)
    val isSubmittingPin = _isSubmittingPin.asStateFlow()

    private val _result = MutableStateFlow<Result<Charge>?>(null)
    val result = _result.asStateFlow()

    fun onPinChanged(pin: String) {
        _pin.update { pin }
        if (pin.length == PIN_LENGTH) {
            submitPin()
        }
    }

    private fun submitPin() {
        viewModelScope.launch {
            _isSubmittingPin.value = true
            _result.value = transactionRepository.authenticateWithPin(
                accessCode = transactionAccessData.accessCode,
                encryptionKey = transactionAccessData.encryptionKey,
                pin = _pin.value
            )
            _isSubmittingPin.value = false
        }
    }
}
