package com.paystack.android.ui.utilities

import android.content.Context
import androidx.annotation.StringRes

internal interface StringProvider {
    fun getString(resId: Int): String

    fun getString(@StringRes resId: Int, vararg formatArgs: Any): String
}

internal class StringProviderImpl(private val context: Context) : StringProvider {
    override fun getString(resId: Int): String {
        return context.getString(resId)
    }

    override fun getString(resId: Int, vararg formatArgs: Any): String {
        return context.getString(resId, *formatArgs)
    }
}
