package com.paystack.android.ui.paymentchannels.mobilemoney.mpesa.numberform

import com.paystack.android.core.api.models.MobileMoneyChannelOption
import com.paystack.android.ui.utilities.CurrencyFormatter

internal data class MpesaNumberFormState(
    val amount: Long,
    val currency: String,
    val providers: List<MobileMoneyChannelOption>,
    val providerKey: String,
    val phoneNumber: String = "",
    val isProcessing: Boolean = false,
) {
    val amountText: String
        get() = CurrencyFormatter.format(amount, currency)
    private val channelOption: MobileMoneyChannelOption
        get() = providers.first { it.key == providerKey }
    val isPhoneNumberValid: Boolean
        get() = Regex(channelOption.phoneNumberRegex).matches(phoneNumber)
}
