package com.paystack.android_sdk.ui.paymentchannels.card.dateofbirth.views

import androidx.lifecycle.ViewModel
import androidx.lifecycle.viewModelScope
import com.paystack.android_sdk.ui.utilities.capitaliseFirst
import kotlinx.coroutines.delay
import kotlinx.coroutines.flow.MutableStateFlow
import kotlinx.coroutines.flow.StateFlow
import kotlinx.coroutines.flow.asStateFlow
import kotlinx.coroutines.launch
import kotlinx.datetime.Month

internal class DateOfBirthViewModel : ViewModel() {

    private var _selectedMonthIndex: MutableStateFlow<Int?> = MutableStateFlow(null)
    val selectedMonthIndex: StateFlow<Int?> = _selectedMonthIndex.asStateFlow()

    private var _monthList: MutableStateFlow<List<String>> = MutableStateFlow(listOf(""))
    val monthList: StateFlow<List<String>> = _monthList.asStateFlow()

    private var _dayText: MutableStateFlow<String> = MutableStateFlow("")
    val dayText: StateFlow<String> = _dayText.asStateFlow()

    private var _yearText: MutableStateFlow<String> = MutableStateFlow("")
    val yearText: StateFlow<String> = _yearText.asStateFlow()

    private var _isAuthorizeButtonEnabled: MutableStateFlow<Boolean> = MutableStateFlow(false)
    val isAuthorizationButtonEnabled: StateFlow<Boolean> = _isAuthorizeButtonEnabled.asStateFlow()

    private var _isSubmitting: MutableStateFlow<Boolean> = MutableStateFlow(false)
    val isSubmitting: StateFlow<Boolean> = _isSubmitting.asStateFlow()

    private var _result: MutableStateFlow<Boolean> = MutableStateFlow(false)
    val result: StateFlow<Boolean> = _result.asStateFlow()

    init {
        populateMonthList()
    }

    fun setSelectedMonthIndex(index: Int) {
        _selectedMonthIndex.value = index
        validateDateInfo()
    }

    fun setDay(dayText: String) {
        _dayText.value = dayText
        validateDateInfo()
    }

    fun submitData() {
        viewModelScope.launch {
            _isSubmitting.value = true
            delay(SAMPLE_DEMO_DELAY)
            _isSubmitting.value = false
            _result.value = true
        }
    }

    fun setBirthYear(yearText: String) {
        _yearText.value = yearText
        validateDateInfo()
    }

    private fun populateMonthList() {
        _monthList.value = Month.values().map { it.name.capitaliseFirst() }
    }

    private fun validateDateInfo() {
        _isAuthorizeButtonEnabled.value = selectedMonthIndex.value != null &&
            dayText.value.length == DAY_INPUT_LENGTH &&
            yearText.value.length == YEAR_INPUT_LENGTH
    }

    companion object {
        private const val DAY_INPUT_LENGTH = 2
        private const val YEAR_INPUT_LENGTH = 4
        private const val SAMPLE_DEMO_DELAY: Long = 3000
    }
}
