package com.paystack.android_sdk.ui.paymentchannels.card.auth.pin

import androidx.compose.animation.Crossfade
import androidx.compose.foundation.layout.Column
import androidx.compose.foundation.layout.Spacer
import androidx.compose.foundation.layout.fillMaxWidth
import androidx.compose.foundation.layout.height
import androidx.compose.foundation.layout.size
import androidx.compose.material3.Text
import androidx.compose.runtime.Composable
import androidx.compose.runtime.LaunchedEffect
import androidx.compose.runtime.collectAsState
import androidx.compose.runtime.getValue
import androidx.compose.ui.Alignment
import androidx.compose.ui.Modifier
import androidx.compose.ui.res.stringResource
import androidx.compose.ui.text.style.TextAlign
import androidx.lifecycle.viewmodel.compose.viewModel
import com.paystack.android_sdk.ui.R
import com.paystack.android_sdk.ui.components.buttons.StackTextButton
import com.paystack.android_sdk.ui.components.progressbars.LoadingIndicator
import com.paystack.android_sdk.ui.components.views.inputs.PinInputField
import com.paystack.android_sdk.ui.models.Charge
import com.paystack.android_sdk.ui.paymentchannels.card.CardViewModelsProviderFactory
import com.paystack.androiddesignsystem.PaystackTheme

@Composable
internal fun PinForm(
    viewModelsProviderFactory: CardViewModelsProviderFactory,
    modifier: Modifier = Modifier,
    viewModel: PinFormViewModel = viewModel(factory = viewModelsProviderFactory),
    onComplete: (Result<Charge>) -> Unit,
    onCancel: () -> Unit,
) {
    val pin by viewModel.pin.collectAsState()
    val isSubmitting by viewModel.isSubmittingPin.collectAsState()
    val result by viewModel.result.collectAsState()

    LaunchedEffect(result) {
        result?.let { onComplete(it) }
    }

    Column(
        horizontalAlignment = Alignment.CenterHorizontally,
        modifier = modifier,
    ) {
        Text(
            text = stringResource(R.string.pstk_card_payment_pin_instruction),
            textAlign = TextAlign.Center,
            style = PaystackTheme.typography.body.body16M,
            color = PaystackTheme.colors.primaryColors.stackBlue,
        )
        Spacer(modifier = Modifier.height(PaystackTheme.dimensions.spacing.triple))
        Crossfade(targetState = isSubmitting, label = "PinInputStateAnim") { showLoadingIndicator ->
            Column(
                horizontalAlignment = Alignment.CenterHorizontally,
                modifier = Modifier.fillMaxWidth()
            ) {
                if (showLoadingIndicator) {
                    LoadingIndicator(
                        modifier = Modifier.size(PaystackTheme.dimensions.spacing.triple),
                        color = PaystackTheme.colors.primaryColors.navy04
                    )
                } else {
                    PinInputField(
                        text = pin,
                        onTextChanged = viewModel::onPinChanged,
                    )
                    Spacer(modifier = Modifier.height(PaystackTheme.dimensions.spacing.double))
                    StackTextButton(
                        text = stringResource(R.string.pstk_payment_action_cancel_text),
                        onClick = onCancel
                    )
                }
            }
        }
    }
}
